/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.HtmlTableEntry;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.SortedArrayList;
import net.kentcom.easyforums.ConfUtilities;
import net.kentcom.easyforums.EasyForumsConstants;
import net.kentcom.easyforums.ForumListener;
import net.kentcom.easyforums.StatusType;
import net.kentcom.easyforums.TableColumnHeadings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForumMacro
implements Macro {
    private final PageManager pageManager_m;
    private final CommentManager commentManager_m;
    private final BandanaManager bandanaManager_m;
    private final SettingsManager settingsManager_m;
    private final AppConfigSettings appConfigSetting_m;
    private final ForumListener forumListener_m;
    private final PermissionManager permissionManager_m;
    private final SpaceManager spaceManager_m;
    private final UserAccessor userAccessor_m;
    private final ConfUtilities confUtilities_m;
    private final LicenseCheck licenseCheck_m;
    private final StatusType statusType_m;
    private final I18nResolver i18nResolver_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final PageBuilderService pageBuilderService_m;
    private final Logger logger_m = LoggerFactory.getLogger(ForumMacro.class);
    private Boolean isUserModerator_m = false;
    private Boolean isUserAdministrator_m = false;
    private Boolean showHiddenContent_m = false;
    private Integer forumStatus_m;
    private Boolean showAvatars_m;
    private EasyForumsConstants.ForumColumns sortColumn_m;

    @Inject
    public ForumMacro(@ComponentImport PageManager pageManager, @ComponentImport CommentManager commentManager, @ComponentImport BandanaManager bandanaManager, @ComponentImport SettingsManager settingsManager, @ComponentImport PermissionManager permissionManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport SpaceManager spaceManager, @ComponentImport UserAccessor userAccessor, @ComponentImport PageBuilderService pageBuilderService, ForumListener forumListener, AppConfigSettings appConfigSetting, ConfUtilities confUtilities, LicenseCheck licenseCheck, StatusType statusType, ConfluenceUtilities confluenceUtilities) {
        this.pageManager_m = pageManager;
        this.commentManager_m = commentManager;
        this.bandanaManager_m = bandanaManager;
        this.settingsManager_m = settingsManager;
        this.forumListener_m = forumListener;
        this.permissionManager_m = permissionManager;
        this.i18nResolver_m = i18nResolver;
        this.spaceManager_m = spaceManager;
        this.userAccessor_m = userAccessor;
        this.appConfigSetting_m = appConfigSetting;
        this.confUtilities_m = confUtilities;
        this.licenseCheck_m = licenseCheck;
        this.statusType_m = statusType;
        this.confluenceUtilities_m = confluenceUtilities;
        this.pageBuilderService_m = pageBuilderService;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        this.pageBuilderService_m.assembler().resources().requireWebResource("net.kentcom.easy-forums:easy-forums-resources");
        this.statusType_m.initialise();
        Integer myId = (Integer)conversionContext.getProperty("EasyForums-ForumMacro", (Object)1);
        if (myId > 1) {
            return "<div><b><em>" + this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.duperror") + "</em></b></div>";
        }
        conversionContext.setProperty("EasyForums-ForumMacro", (Object)(myId + 1));
        StringBuilder builder = new StringBuilder();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Space space = this.spaceManager_m.getSpace(conversionContext.getSpaceKey());
        Page page = (Page)conversionContext.getEntity();
        boolean renderTableOnly = (Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_renderTablesOnly);
        int max = (Integer)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_maxTableItems);
        String topicCreators = (String)this.bandanaManager_m.getValue(EasyForumsConstants.m_topicCreatorsContext, page.getIdAsString());
        String showHiddenStr = null;
        if (user != null) {
            showHiddenStr = (String)this.bandanaManager_m.getValue(EasyForumsConstants.m_showHiddenContext, user.getKey().getStringValue());
        }
        this.showHiddenContent_m = showHiddenStr != null && showHiddenStr.equals("true");
        this.isUserAdministrator_m = this.confluenceUtilities_m.isUserAdministrator(user, conversionContext.getSpaceKey());
        this.isUserModerator_m = this.confUtilities_m.isUserModerator(user, page.getIdAsString());
        if (this.licenseCheck_m.isLicenseOK("Easy Forums")) {
            SortedArrayList<HtmlTableEntry> topics = new SortedArrayList<HtmlTableEntry>();
            this.forumStatus_m = this.statusType_m.getPageStatus(page);
            if (this.isUserAdministrator_m.booleanValue() || this.isUserModerator_m.booleanValue()) {
                builder.append(this.addEditModeratorsControl(user, page.getIdAsString()));
            }
            if (!renderTableOnly) {
                builder.append(this.confUtilities_m.renderSearchBox(this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.search"), conversionContext));
            }
            if (this.forumStatus_m != StatusType.Read_Only && (this.isUserModerator_m.booleanValue() || this.isUserAdministrator_m.booleanValue() || topicCreators == null && this.permissionManager_m.hasCreatePermission((User)user, (Object)space, Page.class) && this.permissionManager_m.hasPermission((User)user, Permission.EDIT, (Object)page) || topicCreators != null && this.confluenceUtilities_m.isUserInGroup(user, topicCreators))) {
                builder.append(this.confUtilities_m.addCreateNewButton(this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.new"), "easy-forums-topic-blueprint", conversionContext, false));
            }
            Map context = MacroUtils.defaultVelocityContext();
            ArrayList<List> data = new ArrayList<List>();
            context.put("tableHeadings", this.addColumnHeadings());
            context.put("isAdmin", this.isUserAdministrator_m != false || this.isUserModerator_m != false);
            context.put("version", this.licenseCheck_m.getPluginVersion());
            context.put("class", "ef-forum-heading");
            this.createListOfTopics(page, topics, user);
            int count = 0;
            for (HtmlTableEntry entry : topics) {
                this.logger_m.info(entry.row_m.toString());
                data.add((List)entry.row_m);
                if (++count < max) continue;
                break;
            }
            context.put("tableData", data);
            builder.append(VelocityUtils.getRenderedTemplate((String)"templates/forum-macro.vm", (Map)context));
        } else {
            builder.append("<p><h3>");
            builder.append(this.i18nResolver_m.getText("net.kentcom.easy-forums.unlicensed"));
            builder.append("</h3></p>");
        }
        builder.append(this.confUtilities_m.hidePageElements(this.isUserAdministrator_m == false && this.isUserModerator_m == false, true, false, true, this.isUserAdministrator_m == false && this.isUserModerator_m == false, this.isUserAdministrator_m == false && this.isUserModerator_m == false));
        return builder.toString();
    }

    private List<TableColumnHeadings> addColumnHeadings() {
        ArrayList<TableColumnHeadings> headers = new ArrayList<TableColumnHeadings>();
        ForumListener.ForumMap forumMap = this.forumListener_m.getForumMap();
        for (EasyForumsConstants.ForumColumns column : EasyForumsConstants.ForumColumns.values()) {
            ForumListener.ColumnAttributes attr = (ForumListener.ColumnAttributes)forumMap.get((Object)column);
            if (!attr.isVisible().booleanValue()) continue;
            if (column == EasyForumsConstants.ForumColumns.SUBSCRIBE) {
                String baseUrl = this.settingsManager_m.getGlobalSettings().getBaseUrl();
                String infoUrl = baseUrl + "/download/resources/net.kentcom.easy-forums:easy-forums-resources/images/info.jpg";
                String name = "<abbr title=\"" + this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.subscribe") + "\">" + attr.Name() + "&nbsp;&nbsp;<img src=\"" + infoUrl + "\" style=\"padding-top:2px\" align=\"top\" width=\"15\" height=\"15\"></abbr>";
                headers.add(new TableColumnHeadings(name, attr.Name()));
                continue;
            }
            headers.add(new TableColumnHeadings(attr.Name(), attr.Name()));
        }
        return headers;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private void createListOfTopics(Page parent, SortedArrayList<HtmlTableEntry> table, ConfluenceUser user) {
        List topics = parent.getChildren();
        this.showAvatars_m = (Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showAvatar);
        String sortColumn = (String)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_defaultSortColumn);
        this.sortColumn_m = EasyForumsConstants.ForumColumns.LAST_POST;
        if (sortColumn.toUpperCase().equals(EasyForumsConstants.ForumColumns.NAME.name())) {
            this.sortColumn_m = EasyForumsConstants.ForumColumns.NAME;
        } else if (sortColumn.toUpperCase().equals(EasyForumsConstants.ForumColumns.STATUS.name())) {
            this.sortColumn_m = EasyForumsConstants.ForumColumns.STATUS;
        }
        if (topics.size() == 0) {
            HtmlTableEntry entry = new HtmlTableEntry();
            entry.row_m = this.addDataToRow(null, null);
            entry.id_m = "0";
            table.insertSorted(entry);
        } else {
            for (Page page : topics) {
                if (!EasyForumsConstants.isPageTopic((Labelable)page)) continue;
                this.addTopicToTable(page, table, user);
            }
        }
    }

    private void addTopicToTable(Page topic, SortedArrayList<HtmlTableEntry> table, ConfluenceUser user) {
        EnumMap<EasyForumsConstants.ForumColumns, String> data = new EnumMap<EasyForumsConstants.ForumColumns, String>(EasyForumsConstants.ForumColumns.class);
        EnumMap<EasyForumsConstants.ForumColumns, String> avatar = new EnumMap<EasyForumsConstants.ForumColumns, String>(EasyForumsConstants.ForumColumns.class);
        String anonymous = this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous");
        List comments = topic.getComments();
        int statusId = this.statusType_m.getPageStatus(topic);
        boolean statusOverridden = false;
        HtmlTableEntry entry = new HtmlTableEntry();
        boolean sortAscending = false;
        this.logger_m.info("Processing " + topic.getTitle() + " Status: " + statusId);
        this.logger_m.info("admin: " + this.isUserAdministrator_m.toString() + " moderator: " + this.isUserModerator_m.toString() + " hidden: " + this.showHiddenContent_m.toString());
        if (!(statusId != StatusType.Hidden || (this.isUserAdministrator_m.booleanValue() || this.isUserModerator_m.booleanValue()) && this.showHiddenContent_m.booleanValue())) {
            this.logger_m.info("This topic is hidden - skipping");
            return;
        }
        if (statusId != StatusType.Read_Only && this.forumStatus_m == StatusType.Read_Only) {
            statusId = StatusType.Read_Only;
            statusOverridden = true;
        }
        if (this.permissionManager_m.hasPermission((User)user, Permission.VIEW, (Object)topic)) {
            Long pageViews;
            Long ceoId = (Long)this.bandanaManager_m.getValue(EasyForumsConstants.m_bandanaContext, topic.getIdAsString());
            entry.id_m = "0";
            data.put(EasyForumsConstants.ForumColumns.LAST_POST, "");
            data.put(EasyForumsConstants.ForumColumns.BY_USER, "");
            avatar.put(EasyForumsConstants.ForumColumns.BY_USER, "");
            if (ceoId != null) {
                Page ceo = this.pageManager_m.getPage(ceoId.longValue());
                if (ceo == null) {
                    ceo = this.commentManager_m.getComment(ceoId.longValue());
                }
                if (ceo != null) {
                    Date lastModDate = ceo.getLastModificationDate();
                    data.put(EasyForumsConstants.ForumColumns.LAST_POST, EasyForumsConstants.m_dateFormat.format(lastModDate));
                    try {
                        data.put(EasyForumsConstants.ForumColumns.BY_USER, ceo.getLastModifier().getFullName());
                    }
                    catch (Exception e) {
                        data.put(EasyForumsConstants.ForumColumns.BY_USER, anonymous);
                    }
                    avatar.put(EasyForumsConstants.ForumColumns.BY_USER, this.confluenceUtilities_m.getImageUrlString(ceo.getLastModifier(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")) + "  ");
                    entry.id_m = EasyForumsConstants.m_sortFormat.format(lastModDate);
                }
            }
            if ((pageViews = (Long)this.bandanaManager_m.getValue(EasyForumsConstants.m_pageViewContext, topic.getIdAsString())) != null) {
                String viewStr = pageViews.toString();
                data.put(EasyForumsConstants.ForumColumns.NUM_VIEWS, viewStr);
            } else {
                data.put(EasyForumsConstants.ForumColumns.NUM_VIEWS, "0");
            }
            data.put(EasyForumsConstants.ForumColumns.STATUS, this.statusType_m.getStatusLink(topic, statusId, statusOverridden, this.isUserModerator_m != false || this.isUserAdministrator_m != false));
            data.put(EasyForumsConstants.ForumColumns.NAME, this.confluenceUtilities_m.getHtmlLink((ContentEntityObject)topic));
            data.put(EasyForumsConstants.ForumColumns.CREATED_ON, EasyForumsConstants.m_dateFormat.format(topic.getCreationDate()));
            data.put(EasyForumsConstants.ForumColumns.NUM_REPLIES, Integer.toString(comments.size()));
            data.put(EasyForumsConstants.ForumColumns.SUBSCRIBE, this.confUtilities_m.getWatchLink(topic, user));
            avatar.put(EasyForumsConstants.ForumColumns.AUTHOR, this.confluenceUtilities_m.getImageUrlString(topic.getCreator(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")) + "  ");
            try {
                data.put(EasyForumsConstants.ForumColumns.AUTHOR, topic.getCreator().getFullName());
            }
            catch (NullPointerException e) {
                data.put(EasyForumsConstants.ForumColumns.AUTHOR, anonymous);
            }
            entry.row_m = this.addDataToRow(data, avatar);
            if (this.sortColumn_m == EasyForumsConstants.ForumColumns.NAME) {
                entry.id_m = topic.getTitle();
                sortAscending = true;
            } else if (this.sortColumn_m == EasyForumsConstants.ForumColumns.STATUS) {
                entry.id_m = this.statusType_m.getValue(statusId);
                sortAscending = true;
            }
            this.logger_m.info("Inserting into table: " + entry.row_m);
            this.logger_m.info("Inserting into table: " + entry.id_m);
            table.insertSorted(entry, sortAscending);
            this.logger_m.info("Inserted OK");
        } else {
            this.logger_m.info("User does not have View permissions to this page " + topic.getTitle());
        }
        this.logger_m.info("Finished");
    }

    private List<String> addDataToRow(Map<EasyForumsConstants.ForumColumns, String> data, Map<EasyForumsConstants.ForumColumns, String> avatar) {
        ArrayList<String> row = new ArrayList<String>();
        ForumListener.ForumMap forumMap = this.forumListener_m.getForumMap();
        for (EasyForumsConstants.ForumColumns column : EasyForumsConstants.ForumColumns.values()) {
            ForumListener.ColumnAttributes attr = (ForumListener.ColumnAttributes)forumMap.get((Object)column);
            if (!attr.isVisible().booleanValue()) continue;
            String cell = "";
            if ((column == EasyForumsConstants.ForumColumns.AUTHOR || column == EasyForumsConstants.ForumColumns.BY_USER) && this.showAvatars_m.booleanValue() && avatar != null) {
                cell = avatar.get((Object)column);
            }
            if (data != null) {
                cell = cell + data.get((Object)column);
            }
            row.add(cell);
        }
        return row;
    }

    private String addEditModeratorsControl(ConfluenceUser user, String pageId) {
        String currentGroup;
        Map context = MacroUtils.defaultVelocityContext();
        String userKey = user.getKey().getStringValue();
        ArrayList groups = this.userAccessor_m.getGroupsAsList();
        if (groups == null) {
            groups = new ArrayList();
        }
        if ((currentGroup = (String)this.bandanaManager_m.getValue(EasyForumsConstants.m_topicCreatorsContext, pageId)) == null) {
            currentGroup = "";
        }
        int max = (Integer)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_maxForumModerators);
        ConfluenceBandanaContext modContext = new ConfluenceBandanaContext(EasyForumsConstants.m_moderatorContentPrefix + pageId);
        List modKeys = (List)this.bandanaManager_m.getKeys((BandanaContext)modContext);
        ArrayList<ConfluenceUser> moderators = new ArrayList<ConfluenceUser>();
        for (String modKey : modKeys) {
            moderators.add(this.userAccessor_m.getUserByKey(new UserKey(modKey)));
        }
        context.put("userKey", userKey);
        context.put("checked", (String)this.bandanaManager_m.getValue(EasyForumsConstants.m_showHiddenContext, userKey));
        context.put("currentGroup", currentGroup);
        context.put("allGroups", groups);
        context.put("maxLimit", moderators.size() >= max);
        context.put("moderators", moderators);
        return VelocityUtils.getRenderedTemplate((String)"templates/forum-settings.vm", (Map)context);
    }
}

