/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.easyforums.EasyForumsConstants;
import net.kentcom.easyforums.ForumListener;
import net.kentcom.easyforums.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationServlet
extends HttpServlet {
    private final UserManager userManager_m;
    private final PageTemplateManager pageTemplateManager_m;
    private final ForumListener forumListener_m;
    private final AppConfigSettings appConfigSetting_m;
    private final StatusType statusType_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private static final Logger logger_m = LoggerFactory.getLogger(ConfigurationServlet.class);

    @Inject
    public ConfigurationServlet(@ComponentImport UserManager userManager, @ComponentImport PageTemplateManager pageTemplateManager, ConfluenceUtilities confluenceUtilities, ForumListener forumListener, AppConfigSettings appConfigSetting, StatusType statusType) {
        this.userManager_m = userManager;
        this.pageTemplateManager_m = pageTemplateManager;
        this.forumListener_m = forumListener;
        this.appConfigSetting_m = appConfigSetting;
        this.statusType_m = statusType;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger_m.info("doGet");
        UserProfile user = this.userManager_m.getRemoteUser(request);
        if (user == null || !this.userManager_m.isSystemAdmin(user.getUserKey())) {
            response.setStatus(401);
        } else {
            String requestData = request.getParameter("grab");
            logger_m.info("request type: " + requestData);
            if (requestData.equals("configuration")) {
                String json = this.createJsonData();
                response.setContentType("application/json; charset=UTF-8");
                response.getWriter().write(json);
                response.setStatus(200);
            } else {
                response.setContentType("text/html; charset=UTF-8");
                response.getWriter().write(this.createUserFieldTable());
                response.setStatus(200);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger_m.info("doPost");
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(405);
            return;
        }
        UserProfile user = this.userManager_m.getRemoteUser(request);
        if (user == null || !this.userManager_m.isSystemAdmin(user.getUserKey())) {
            response.setStatus(401);
        } else {
            String updateData = request.getParameter("store");
            if (updateData.equals("configuration")) {
                this.appConfigSetting_m.setSetting(EasyForumsConstants.m_showAvatar, Boolean.parseBoolean(request.getParameter("showAvatar")));
                this.appConfigSetting_m.setSetting(EasyForumsConstants.m_renderTablesOnly, Boolean.parseBoolean(request.getParameter("renderTablesOnly")));
                this.appConfigSetting_m.setSetting(EasyForumsConstants.m_forumTemplate, request.getParameter("forumTemplate"));
                this.appConfigSetting_m.setSetting(EasyForumsConstants.m_maxTableItems, Integer.parseInt(request.getParameter("maxTableItems")));
                this.appConfigSetting_m.setSetting(EasyForumsConstants.m_defaultSortColumn, request.getParameter("defaultSortColumn"));
                this.appConfigSetting_m.setSetting(EasyForumsConstants.m_showLabels, Boolean.parseBoolean(request.getParameter("showLabels")));
                this.appConfigSetting_m.setSetting(EasyForumsConstants.m_showSidebar, Boolean.parseBoolean(request.getParameter("showSidebar")));
                this.appConfigSetting_m.setSetting(EasyForumsConstants.m_maxForumModerators, Integer.parseInt(request.getParameter("maxForumModerators")));
                this.forumListener_m.updateSummaryMap(EasyForumsConstants.SummaryColumns.TOP_CONTRIBUTORS, Boolean.parseBoolean(request.getParameter("showTopContributors")));
                this.forumListener_m.updateForumMap(EasyForumsConstants.ForumColumns.NUM_VIEWS, Boolean.parseBoolean(request.getParameter("showPageViews")));
                response.setStatus(200);
            } else {
                String action = request.getParameter("action");
                if (action.equals("add")) {
                    String value = request.getParameter("value");
                    Integer statusId = this.statusType_m.addValue(value);
                    if (statusId > 0) {
                        response.setContentType("text/html; charset=UTF-8");
                        response.getWriter().write(this.createUserFieldTable());
                        response.setStatus(200);
                    }
                } else if (action.equals("modify")) {
                    String newValue;
                    String oldValue = request.getParameter("oldValue");
                    if (this.statusType_m.renameValue(oldValue, newValue = request.getParameter("newValue"))) {
                        response.setContentType("text/html; charset=UTF-8");
                        response.getWriter().write(this.createUserFieldTable());
                        response.setStatus(200);
                    }
                } else {
                    String value = request.getParameter("value");
                    String newValue = request.getParameter("newValue");
                    if (this.statusType_m.deleteValue(value)) {
                        response.setContentType("text/html; charset=UTF-8");
                        response.getWriter().write(this.createUserFieldTable());
                        response.setStatus(200);
                    }
                }
            }
        }
    }

    private String createJsonData() {
        JSONObject json = new JSONObject();
        json.put("showAvatar", (Object)((Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showAvatar)));
        json.put("renderTablesOnly", (Object)((Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_renderTablesOnly)));
        json.put("forumTemplate", (Object)((String)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_forumTemplate)));
        json.put("maxTableItems", (Object)((Integer)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_maxTableItems)));
        json.put("defaultSortColumn", (Object)((String)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_defaultSortColumn)));
        json.put("showLabels", (Object)((Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showLabels)));
        json.put("showSidebar", (Object)((Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showSidebar)));
        json.put("maxForumModerators", (Object)((Integer)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_maxForumModerators)));
        json.put("showTopContributors", (Object)((Boolean)this.appConfigSetting_m.getSetting("EF-Summary-" + EasyForumsConstants.SummaryColumns.TOP_CONTRIBUTORS.name())));
        json.put("showPageViews", (Object)((Boolean)this.appConfigSetting_m.getSetting("EF-Forum-" + EasyForumsConstants.ForumColumns.NUM_VIEWS.name())));
        JSONArray templateList = new JSONArray();
        List pageTemplates = this.pageTemplateManager_m.getGlobalPageTemplates();
        for (PageTemplate page : pageTemplates) {
            templateList.put((Object)page.getName());
        }
        json.put("templates", (Object)templateList);
        return json.toString();
    }

    private String createUserFieldTable() {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("map", this.statusType_m.typeValues_m);
        return VelocityUtils.getRenderedTemplate((String)"templates/status-table.vm", (Map)context);
    }
}

