/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class MailService {
    private final MultiQueueTaskManager multiQueueTaskManager_m;
    private final MailServerManager mailServerManager_m;
    private final Logger logger_m = LoggerFactory.getLogger(MailService.class);
    private final String MAIL_m = "mail";

    @Inject
    public MailService(@ComponentImport MailServerManager mailServerManager, @ComponentImport MultiQueueTaskManager taskManager) {
        this.multiQueueTaskManager_m = taskManager;
        this.mailServerManager_m = mailServerManager;
    }

    public void sendEmail(MailQueueItem mailQueueItem) throws Exception {
        List mailServers = this.mailServerManager_m.getServerNames();
        if (mailServers.isEmpty()) {
            this.logger_m.error("No Mail servers configured");
            throw new RuntimeException("No Mail servers configured");
        }
        this.multiQueueTaskManager_m.addTask("mail", (Task & Serializable)() -> mailQueueItem.send());
    }
}

