/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.spring.container.ContainerManager;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.StringUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class MacroMigrationThread
implements Runnable {
    private static String oldMacroName_m;
    private static String newMacroName_m;
    private static String paramExist_m;
    private static NodeList macros_m;
    private static List<Pair<String, String>> addParams_m;
    private static List<Triple<String, String, String>> replaceValues_m;
    private final CQLSearchService cqlSearchService_m;
    private final PageManager pageManager_m;
    private final String appName_m;
    private final ConfluenceUser user_m;
    private final TransactionTemplate transactionTemplate_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private static final Logger logger_m;

    public MacroMigrationThread(String oldMacroName, String newMacroName, String paramExist, List<Pair<String, String>> addParams, List<Triple<String, String, String>> replaceValues, ConfluenceUser user, String appName, TransactionTemplate transactionTemplate, ConfluenceUtilities confluenceUtilities) {
        oldMacroName_m = oldMacroName;
        newMacroName_m = newMacroName;
        paramExist_m = paramExist;
        addParams_m = addParams;
        replaceValues_m = replaceValues;
        this.user_m = user;
        this.appName_m = appName;
        this.pageManager_m = (PageManager)ContainerManager.getComponent((String)"pageManager");
        this.cqlSearchService_m = (CQLSearchService)ContainerManager.getComponent((String)"cQLSearchService");
        this.transactionTemplate_m = transactionTemplate;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    @Override
    public void run() {
        AuthenticatedUserThreadLocal.set((ConfluenceUser)this.user_m);
        logger_m.info("Renaming " + oldMacroName_m + " macro to " + newMacroName_m);
        logger_m.info("Running as User: " + this.user_m.getName());
        this.transactionTemplate_m.execute(new TransactionCallback(){

            public Object doInTransaction() {
                try {
                    int limit = 100;
                    int start = 0;
                    boolean finished = false;
                    while (!finished) {
                        PageResponse searchResults = MacroMigrationThread.this.cqlSearchService_m.searchContent("macroName:" + oldMacroName_m, (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                        for (Content content : searchResults.getResults()) {
                            String pageName = content.getTitle();
                            ContentEntityObject ceo = MacroMigrationThread.this.pageManager_m.getById(content.getId().asLong());
                            logger_m.info("Migrating macros on page: " + pageName + " of type " + ceo.getType());
                            MacroMigrationThread.this.replaceMacroName(ceo);
                        }
                        if (searchResults.hasMore()) {
                            start += limit;
                            continue;
                        }
                        finished = true;
                    }
                }
                catch (Exception e) {
                    logger_m.error("Error renaming macro: " + e.getMessage());
                }
                return null;
            }
        });
        logger_m.info("Process Complete");
    }

    public boolean replaceMacroName(ContentEntityObject ceo) {
        String body = "<div>" + ceo.getBodyAsString() + "</div>";
        body = StringUtil.strtr(body, StringUtil.HTML401NamedToNumeric_m);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(body));
            Document doc = builder.parse(is);
            macros_m = doc.getElementsByTagName("ac:structured-macro");
            boolean modified = MacroMigrationThread.replaceMacros(doc);
            macros_m = doc.getElementsByTagName("ac:macro");
            boolean modified1 = MacroMigrationThread.replaceMacros(doc);
            if (modified || modified1) {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(doc), new StreamResult(writer));
                String result = HtmlUtils.htmlUnescape((String)writer.getBuffer().toString());
                String versionComment = oldMacroName_m + " renamed to " + newMacroName_m + " by " + this.appName_m;
                this.confluenceUtilities_m.savePageVersion(ceo, this.user_m, versionComment, result, false, false);
            }
            return true;
        }
        catch (Exception e) {
            logger_m.error("Failed to Update macros on page: " + ceo.getDisplayTitle());
            logger_m.error("Due to: " + e.getMessage());
            return false;
        }
    }

    private static boolean replaceMacros(Document doc) {
        boolean modified = false;
        for (int i = 0; i < macros_m.getLength(); ++i) {
            Node child;
            Node macro = macros_m.item(i);
            NamedNodeMap attribs = macro.getAttributes();
            Node name = attribs.getNamedItem("ac:name");
            if (!name.getNodeValue().equals(oldMacroName_m)) continue;
            logger_m.info("Found: " + oldMacroName_m);
            if (paramExist_m != null || replaceValues_m != null) {
                NodeList children = macro.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    child = children.item(j);
                    if (!child.getNodeName().equals("ac:parameter")) continue;
                    NamedNodeMap parAtts = child.getAttributes();
                    Node attr = parAtts.getNamedItem("ac:name");
                    if (paramExist_m == null || attr.getNodeValue().equals(paramExist_m)) {
                        logger_m.info("Renaming Macro");
                        name.setNodeValue(newMacroName_m);
                        modified = true;
                        if (replaceValues_m == null) break;
                    }
                    if (replaceValues_m == null) continue;
                    for (Triple<String, String, String> entry : replaceValues_m) {
                        if (!attr.getNodeValue().equals(entry.getLeft())) continue;
                        Node node = child.getFirstChild();
                        logger_m.info("replacing value: " + node.getNodeValue());
                        String value = node.getNodeValue().replace((CharSequence)entry.getMiddle(), (CharSequence)entry.getRight());
                        logger_m.info("with: " + value);
                        node.setNodeValue(value);
                        modified = true;
                    }
                }
            } else {
                logger_m.info("Renaming Macro");
                name.setNodeValue(newMacroName_m);
                modified = true;
            }
            if (!modified || addParams_m == null) continue;
            for (Pair<String, String> entry : addParams_m) {
                logger_m.info("Adding Param: " + (String)entry.getKey() + ", " + (String)entry.getValue());
                child = doc.createElement("ac:parameter");
                child.setAttribute("ac:name", (String)entry.getKey());
                Text node = doc.createTextNode((String)entry.getValue());
                child.appendChild(node);
                child.setNodeValue((String)entry.getValue());
                macro.appendChild(child);
            }
        }
        return modified;
    }

    public static String replaceMacroName(String content, String oldMacroName, String newMacroName, String paramExist, List<Pair<String, String>> addParams, List<Triple<String, String, String>> replaceValues) {
        oldMacroName_m = oldMacroName;
        newMacroName_m = newMacroName;
        paramExist_m = paramExist;
        addParams_m = addParams;
        replaceValues_m = replaceValues;
        String result = null;
        String body = "<div>" + content + "</div>";
        body = StringUtil.strtr(body, StringUtil.HTML401NamedToNumeric_m);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(body));
            Document doc = builder.parse(is);
            macros_m = doc.getElementsByTagName("ac:structured-macro");
            boolean modified = MacroMigrationThread.replaceMacros(doc);
            macros_m = doc.getElementsByTagName("ac:macro");
            boolean modified1 = MacroMigrationThread.replaceMacros(doc);
            if (modified || modified1) {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(doc), new StreamResult(writer));
                result = HtmlUtils.htmlUnescape((String)writer.getBuffer().toString());
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        logger_m = LoggerFactory.getLogger(MacroMigrationThread.class);
    }
}

