/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.ConfluenceUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class LicenseCheck {
    public final PluginLicenseManager pluginLicenseManager_m;
    public final PluginAccessor pluginAccessor_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger(LicenseCheck.class);
    private Long jarFileTime_m = 0L;
    private LocalDate lastLogTime_m = null;

    @Inject
    public LicenseCheck(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginAccessor pluginAccessor, ConfluenceUtilities confluenceUtilities) {
        this.pluginLicenseManager_m = pluginLicenseManager;
        this.pluginAccessor_m = pluginAccessor;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    public String getPluginVersion() {
        return LicenseCheck.class.getPackage().getImplementationVersion();
    }

    public String getPluginVersion(String pluginKey) {
        return this.pluginAccessor_m.getPlugin(pluginKey).getPluginInformation().getVersion();
    }

    public Plugin getPlugin(String pluginKey) {
        return this.pluginAccessor_m.getPlugin(pluginKey);
    }

    private void logLicenseError(String message) {
        LocalDate now = LocalDate.now();
        if (this.lastLogTime_m == null || this.lastLogTime_m.isBefore(now.minusDays(1L))) {
            this.lastLogTime_m = now;
            this.logger_m.error(message);
        }
    }

    public boolean isLicenseOK(String pluginName) {
        boolean licenseValid = false;
        boolean trialValid = false;
        this.logger_m.info("Confluence Version: " + GeneralUtil.getVersionNumber() + " Plugin Version: " + this.getPluginVersion());
        try {
            if (this.pluginLicenseManager_m.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.pluginLicenseManager_m.getLicense().get();
                if (license.getError().isDefined()) {
                    block14: for (LicenseError error : license.getError()) {
                        switch (error.name()) {
                            case "EXPIRED": {
                                this.logLicenseError("Invalid license: Your license of \"" + pluginName + "\" has expired. Please use the 'Buy' button to purchase or renew this license.");
                                continue block14;
                            }
                            case "USER_MISMATCH": {
                                this.logLicenseError("Invalid license: Your \"" + pluginName + "\" plugin license User Limit is lower than your Confluence license User Limit. Please upgrade your \"" + pluginName + "\" license.");
                                continue block14;
                            }
                            case "VERSION_MISMATCH": {
                                this.logLicenseError("Invalid license: Your license for maintenance of \"" + pluginName + "\" is not valid for this Confluence version. Please use the 'Renew' button to renew your license.");
                                continue block14;
                            }
                            case "TYPE_MISMATCH": {
                                this.logLicenseError("Invalid license: Your \"" + pluginName + "\" license does not match the license type on this Confluence installation. Please purchase the correct license.");
                                continue block14;
                            }
                        }
                        this.logLicenseError("Invalid license: \"" + pluginName + "\" Unknown license error.");
                    }
                } else {
                    licenseValid = true;
                }
            } else {
                licenseValid = false;
                this.logLicenseError(pluginName + ": Plugin is unlicensed, there is no license installed for this plugin");
            }
            if (!licenseValid) {
                Calendar timeNow = Calendar.getInstance();
                Calendar sevenDays = Calendar.getInstance();
                sevenDays.setTimeInMillis(this.getJarFileTime(LicenseCheck.class));
                sevenDays.add(5, 7);
                boolean bl = trialValid = timeNow.compareTo(sevenDays) < 0;
                if (trialValid) {
                    this.logger_m.info(pluginName + ": Trial License is Active");
                }
            }
        }
        catch (Exception e) {
            this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
            return false;
        }
        return licenseValid || trialValid;
    }

    private Long getJarFileTime(Class<?> cl) {
        if (this.jarFileTime_m == 0L) {
            try {
                String url = cl.getProtectionDomain().getCodeSource().getLocation().getPath();
                url = URLDecoder.decode(url, "UTF-8");
                String path = url.replace("file:", "");
                JarFile jf = new JarFile(path);
                ZipEntry manifest = jf.getEntry("META-INF/MANIFEST.MF");
                this.jarFileTime_m = manifest.getTime();
                jf.close();
            }
            catch (Exception e) {
                this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
            }
        }
        return this.jarFileTime_m;
    }
}

