/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.ManagedCache;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.ConfluenceDCChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AppConfigSettings {
    private final BandanaManager bandanaManager_m;
    private final CacheManager cacheManager_m;
    private final Logger logger_m = LoggerFactory.getLogger(AppConfigSettings.class);
    private Cache<String, Object> appCache_m = null;
    private BandanaContext bandanaContext_m = null;
    private boolean isDataCentre_m = false;

    @Inject
    public AppConfigSettings(@ComponentImport BandanaManager bandanaManager, @ComponentImport CacheManager cacheManager, ConfluenceDCChecker confluenceDCChecker) {
        this.bandanaManager_m = bandanaManager;
        this.cacheManager_m = cacheManager;
        this.isDataCentre_m = confluenceDCChecker.isDataCenter();
    }

    public void initialise(String appStoreContext, String pluginKey, String pluginName) {
        this.bandanaContext_m = new ConfluenceBandanaContext(appStoreContext);
        String cacheName = String.format("%s (%s)", pluginName, pluginKey);
        this.appCache_m = this.isDataCentre_m ? this.cacheManager_m.getCache(cacheName, (CacheLoader)new AppSettingsCacheLoader(), new CacheSettingsBuilder().remote().replicateViaCopy().expireAfterAccess(365L, TimeUnit.DAYS).expireAfterWrite(365L, TimeUnit.DAYS).build()) : this.cacheManager_m.getCache(cacheName, (CacheLoader)new AppSettingsCacheLoader(), new CacheSettingsBuilder().local().expireAfterAccess(365L, TimeUnit.DAYS).expireAfterWrite(365L, TimeUnit.DAYS).build());
        ManagedCache mc = this.cacheManager_m.getManagedCache(cacheName);
        mc.updateExpireAfterAccess(365L, TimeUnit.DAYS);
        mc.updateExpireAfterWrite(365L, TimeUnit.DAYS);
    }

    public <T> boolean addSetting(String key, T defaultValue) {
        if (this.bandanaContext_m == null) {
            throw new ExceptionInInitializerError();
        }
        this.logger_m.info("Key: " + key + " Default: " + defaultValue);
        boolean inCache = this.appCache_m.containsKey((Object)key);
        Object inBandana = this.bandanaManager_m.getValue(this.bandanaContext_m, key);
        if (!this.appCache_m.containsKey((Object)key) || this.bandanaManager_m.getValue(this.bandanaContext_m, key) == null) {
            T data = this.getInitialValue(key, defaultValue);
            this.appCache_m.put((Object)key, data);
            this.bandanaManager_m.setValue(this.bandanaContext_m, key, data);
            this.logger_m.info("Adding Key: " + key + " Data: " + data);
            return true;
        }
        return false;
    }

    public <T> boolean setSetting(String key, T newData) {
        this.logger_m.info("Setting Key: " + key + " Data: " + newData);
        Object currentData = this.bandanaManager_m.getValue(this.bandanaContext_m, key);
        if (currentData != null) {
            if (!newData.getClass().equals(currentData.getClass())) {
                throw new IncompatibleClassChangeError();
            }
            this.appCache_m.put((Object)key, newData);
            this.bandanaManager_m.setValue(this.bandanaContext_m, key, newData);
            return true;
        }
        this.logger_m.error("Key not found: " + key + " not storing new value: " + newData);
        return false;
    }

    public <T> T getSetting(String key) {
        try {
            Object value = this.appCache_m.get((Object)key);
            return (T)value;
        }
        catch (Exception value) {
            Object value2 = this.bandanaManager_m.getValue(this.bandanaContext_m, key);
            if (value2 == null) {
                this.logger_m.error("Key not found: " + key);
            }
            return (T)value2;
        }
    }

    private <T> T getInitialValue(String key, T defaultVal) {
        T value = this.getSetting(key);
        return value == null ? defaultVal : value;
    }

    public void dumpSettings() {
        this.logger_m.info("Data from cache");
        for (String key : this.appCache_m.getKeys()) {
            this.logger_m.info(key + " = " + this.appCache_m.get((Object)key).toString());
        }
        this.logger_m.info("Data from bandana");
        for (String key : this.bandanaManager_m.getKeys(this.bandanaContext_m)) {
            this.logger_m.info(key + " = " + this.bandanaManager_m.getValue(this.bandanaContext_m, key).toString());
        }
    }

    private class AppSettingsCacheLoader
    implements CacheLoader<String, Object> {
        private AppSettingsCacheLoader() {
        }

        public Object load(String key) {
            return AppConfigSettings.this.bandanaManager_m.getValue(AppConfigSettings.this.bandanaContext_m, key);
        }
    }
}

