/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common.scheduler;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kentcom.common.scheduler.SchedulerJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class SchedulerManager
implements JobRunner {
    private final TransactionTemplate transactionTemplate_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());
    private final SchedulerService schedulerService_m;
    private SchedulerJobManager jobManager_m = null;
    private JobRunnerKey jobRunnerKey_m;

    @Autowired
    public SchedulerManager(@ComponentImport TransactionTemplate transactionTemplate, @ComponentImport SchedulerService scheduler) {
        this.schedulerService_m = scheduler;
        this.transactionTemplate_m = transactionTemplate;
    }

    public void initialise(SchedulerJobManager jobManager, String pluginKey) {
        this.jobRunnerKey_m = JobRunnerKey.of((String)pluginKey);
        this.logger_m.info("Creating JobRunnerKey: {}", (Object)this.jobRunnerKey_m);
        this.schedulerService_m.registerJobRunner(this.jobRunnerKey_m, (JobRunner)this);
        this.jobManager_m = jobManager;
    }

    public Optional<JobId> schedule(Schedule schedule, @Nullable String jobName) {
        return this.schedule(schedule, jobName, Collections.emptyMap());
    }

    public Optional<JobId> schedule(Schedule schedule, @Nullable String jobId, @NonNull Map<String, Serializable> parameters) {
        this.logger_m.info("Scheduling job: {} schedule: {}", (Object)jobId, (Object)schedule);
        try {
            return Optional.of(this.internalSchedule(schedule, jobId, parameters));
        }
        catch (Exception e) {
            this.logger_m.error("Exception when scheduling the new job: {}", (Object)e.toString());
            return Optional.empty();
        }
    }

    private JobId internalSchedule(Schedule schedule, @Nullable String jobId, @NonNull Map<String, Serializable> parameters) throws SchedulerServiceException {
        if (jobId == null || ((String)jobId).isEmpty()) {
            jobId = String.valueOf(this.jobRunnerKey_m) + ":" + String.valueOf(UUID.randomUUID());
        }
        this.schedulerService_m.scheduleJob(JobId.of((String)jobId), JobConfig.forJobRunnerKey((JobRunnerKey)this.jobRunnerKey_m).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(schedule).withParameters(parameters));
        this.logger_m.info("Job scheduled: {} for interval: {}", jobId, (Object)schedule.toString());
        return JobId.of((String)jobId);
    }

    public boolean isJobScheduled(JobId jobId) {
        JobDetails jobDetails = this.schedulerService_m.getJobDetails(jobId);
        return jobDetails != null;
    }

    public boolean cancel(JobId jobId) {
        this.logger_m.info("Cancel job: {}", (Object)jobId);
        JobDetails details = this.schedulerService_m.getJobDetails(jobId);
        if (details != null) {
            this.schedulerService_m.unscheduleJob(jobId);
            return true;
        }
        this.logger_m.info("Job not found, nothing to cancel: " + String.valueOf(jobId));
        return false;
    }

    public JobRunnerResponse runJob(final JobRunnerRequest request) {
        this.logger_m.info("Job executing: {}", (Object)request.getJobId());
        try {
            return (JobRunnerResponse)this.transactionTemplate_m.execute((TransactionCallback)new TransactionCallback<JobRunnerResponse>(){

                public JobRunnerResponse doInTransaction() {
                    SchedulerManager.this.jobManager_m.processSchedulerJob(request);
                    return JobRunnerResponse.success();
                }
            });
        }
        catch (Exception e) {
            this.logger_m.error("Job execution failed, due to: {}", (Object)e.toString());
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    public void dump() {
        List allJobs = this.schedulerService_m.getJobsByJobRunnerKey(this.jobRunnerKey_m).stream().map(JobDetails::getJobId).collect(Collectors.toList());
        this.logger_m.info("Dumping all known scheduled jobs:");
        for (JobId jobId : allJobs) {
            JobDetails details = this.schedulerService_m.getJobDetails(jobId);
            this.logger_m.info(details.getSchedule().toString());
        }
    }

    public void cancelAllScheduledJobs() {
        try {
            List allJobs = this.schedulerService_m.getJobsByJobRunnerKey(this.jobRunnerKey_m).stream().map(JobDetails::getJobId).collect(Collectors.toList());
            for (JobId jobId : allJobs) {
                this.cancel(jobId);
            }
        }
        catch (Exception e) {
            this.logger_m.error("Exception while unregistering jobs", (Throwable)e);
        }
    }

    public void destroy() {
        this.logger_m.info("Plugin Shutdown");
        try {
            this.cancelAllScheduledJobs();
            this.schedulerService_m.unregisterJobRunner(this.jobRunnerKey_m);
        }
        catch (RuntimeException e) {
            this.logger_m.error("Exception when shutting down: {}", (Object)e.toString());
        }
    }
}

