/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common.cron.parser;

import com.atlassian.scheduler.cron.CronSyntaxException;
import com.atlassian.scheduler.cron.ErrorCode;
import java.util.HashMap;
import java.util.Map;
import net.kentcom.common.cron.parser.CronLexer;
import net.kentcom.common.cron.parser.TokenType;

class NameResolver {
    private static final Map<String, Integer> MONTH_NAMES = new HashMap<String, Integer>();
    private static final Map<String, Integer> DAY_OF_WEEK_NAMES;
    static final NameResolver MONTH;
    static final NameResolver DAY_OF_WEEK;
    private final Map<String, Integer> names;
    private final ErrorCode errorCode;

    private NameResolver(Map<String, Integer> names, ErrorCode errorCode) {
        this.names = names;
        this.errorCode = errorCode;
    }

    final int resolveName(CronLexer.Token token) throws CronSyntaxException {
        if (token.getType() != TokenType.NAME) {
            throw new IllegalArgumentException("Called name resolver with something that wasn't a NAME: " + String.valueOf(token));
        }
        String name = token.getText();
        Integer value = this.names.get(name);
        if (value == null) {
            throw CronSyntaxException.builder().cronExpression(token.getCronExpression()).errorCode(this.errorCode).errorOffset(token.getStart()).value(name).build();
        }
        return value;
    }

    static {
        MONTH_NAMES.put("JAN", 1);
        MONTH_NAMES.put("FEB", 2);
        MONTH_NAMES.put("MAR", 3);
        MONTH_NAMES.put("APR", 4);
        MONTH_NAMES.put("MAY", 5);
        MONTH_NAMES.put("JUN", 6);
        MONTH_NAMES.put("JUL", 7);
        MONTH_NAMES.put("AUG", 8);
        MONTH_NAMES.put("SEP", 9);
        MONTH_NAMES.put("OCT", 10);
        MONTH_NAMES.put("NOV", 11);
        MONTH_NAMES.put("DEC", 12);
        DAY_OF_WEEK_NAMES = new HashMap<String, Integer>();
        DAY_OF_WEEK_NAMES.put("SUN", 1);
        DAY_OF_WEEK_NAMES.put("MON", 2);
        DAY_OF_WEEK_NAMES.put("TUE", 3);
        DAY_OF_WEEK_NAMES.put("WED", 4);
        DAY_OF_WEEK_NAMES.put("THU", 5);
        DAY_OF_WEEK_NAMES.put("FRI", 6);
        DAY_OF_WEEK_NAMES.put("SAT", 7);
        MONTH = new NameResolver(MONTH_NAMES, ErrorCode.INVALID_NAME_MONTH);
        DAY_OF_WEEK = new NameResolver(DAY_OF_WEEK_NAMES, ErrorCode.INVALID_NAME_DAY_OF_WEEK);
    }
}

