/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common.cron;

import com.atlassian.scheduler.config.CronScheduleInfo;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.cron.CronSyntaxException;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import net.kentcom.common.cron.parser.CronExpressionParser;
import net.kentcom.common.cron.rule.CronExpression;
import net.kentcom.common.cron.rule.DateTimeTemplate;
import org.springframework.lang.Nullable;

public class RunTimeCalculator {
    @Nullable
    public Date nextRunTime(Schedule schedule, @Nullable Date prevRunTime) throws CronSyntaxException {
        Objects.requireNonNull(schedule, "schedule");
        switch (schedule.getType()) {
            case CRON_EXPRESSION: {
                return this.nextRunTime(schedule.getCronScheduleInfo(), prevRunTime);
            }
        }
        throw new IllegalArgumentException("Unsupported schedule type: " + String.valueOf(schedule.getType()));
    }

    @Nullable
    private Date nextRunTime(CronScheduleInfo info, @Nullable Date prevRunTime) throws CronSyntaxException {
        String cronExpression = info.getCronExpression();
        TimeZone timeZone = info.getTimeZone();
        CronExpression cron = CronExpressionParser.parse(cronExpression);
        Date runTimeForCalc = prevRunTime == null ? this.now() : prevRunTime;
        DateTimeTemplate when = new DateTimeTemplate(runTimeForCalc, timeZone.toZoneId());
        while (cron.next(when)) {
            ZonedDateTime dateTime = when.toZonedDateTime();
            if (dateTime == null) continue;
            return new Date(dateTime.toInstant().toEpochMilli());
        }
        return null;
    }

    private Date now() {
        return new Date();
    }
}

