/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.kentcom.common.ContentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class VelocityHelper {
    private final XhtmlContent xhtmlContent_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String DATETIME_FORMAT = "d/M/yyyy";
    private final SimpleDateFormat dateFormat_m = new SimpleDateFormat("d/M/yyyy");
    private final SimpleDateFormat sortFormat_m = new SimpleDateFormat("yyyyMMdd");

    @Autowired
    public VelocityHelper(@ComponentImport XhtmlContent xhtmlContent) {
        this.xhtmlContent_m = xhtmlContent;
    }

    @HtmlSafe
    public String convertStorageToView(String storage, Long pageId) {
        String view = "";
        DefaultConversionContext cc = new DefaultConversionContext(new RenderContext());
        try {
            this.logger_m.info(storage);
            view = this.xhtmlContent_m.convertStorageToView(storage, (ConversionContext)cc);
            this.logger_m.info(view);
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
        }
        return view;
    }

    public Content getById(Long contentId) {
        return ContentManager.getContentById(contentId);
    }

    public String getUrl(Content content) {
        return ContentManager.getUrlPath(content);
    }

    public List<Label> getLabels(Content content) {
        LinkedList<Label> labels = new LinkedList<Label>((Collection)Objects.requireNonNull(ContentManager.getLabels(content)));
        return labels;
    }

    public String getLabelName(Label label) {
        if (label.getPrefix().equalsIgnoreCase("global")) {
            return label.getLabel();
        }
        return null;
    }

    public String displayCurrency(Double money) {
        try {
            NumberFormat formatter = NumberFormat.getCurrencyInstance();
            return formatter.format(money);
        }
        catch (Exception e) {
            return "";
        }
    }

    @HtmlSafe
    public String displayDate(Date date) {
        try {
            String temp = String.format("<span data-sort=\"%s\" style=\"display:none\">%s</span><span>%s</span>", this.sortFormat_m.format(date), this.sortFormat_m.format(date), this.dateFormat_m.format(date));
            return temp;
        }
        catch (Exception e) {
            return "";
        }
    }

    public Integer toInteger(String value) {
        return Integer.valueOf(value);
    }

    public Long toLong(String value) {
        return Long.valueOf(value);
    }
}

