/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordManager {
    private Map<String, UserInfo> userDatabase = new HashMap<String, UserInfo>();

    public static void main(String[] args) throws Exception {
        PasswordManager passManager = new PasswordManager();
        String userName = "admin";
        String password = "password";
        passManager.signUp(userName, password);
        Scanner scanner = new Scanner(System.in);
        System.out.println("Please enter username:");
        String inputUser = scanner.nextLine();
        System.out.println("Please enter password:");
        String inputPass = scanner.nextLine();
        boolean status = passManager.authenticateUser(inputUser, inputPass);
        if (status) {
            System.out.println("Logged in!");
        } else {
            System.out.println("Sorry, wrong username/password");
        }
        scanner.close();
    }

    private boolean authenticateUser(String inputUser, String inputPass) throws Exception {
        UserInfo user = this.userDatabase.get(inputUser);
        if (user == null) {
            return false;
        }
        String salt = user.userSalt;
        String calculatedHash = this.getEncryptedPassword(inputPass, salt);
        return calculatedHash.equals(user.userEncryptedPassword);
    }

    private void signUp(String userName, String password) throws Exception {
        String salt = this.getNewSalt();
        String encryptedPassword = this.getEncryptedPassword(password, salt);
        UserInfo user = new UserInfo(this);
        user.userEncryptedPassword = encryptedPassword;
        user.userName = userName;
        user.userSalt = salt;
        this.saveUser(user);
    }

    public String getEncryptedPassword(String password, String salt) throws Exception {
        String algorithm = "PBKDF2WithHmacSHA1";
        int derivedKeyLength = 160;
        int iterations = 10000;
        byte[] saltBytes = Base64.getDecoder().decode(salt);
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), saltBytes, iterations, derivedKeyLength);
        SecretKeyFactory f = SecretKeyFactory.getInstance(algorithm);
        byte[] encBytes = f.generateSecret(spec).getEncoded();
        return Base64.getEncoder().encodeToString(encBytes);
    }

    public String getNewSalt() throws Exception {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[4];
        random.nextBytes(salt);
        return Base64.getEncoder().encodeToString(salt);
    }

    private void saveUser(UserInfo user) {
        this.userDatabase.put(user.userName, user);
    }

    class UserInfo {
        String userEncryptedPassword;
        String userSalt;
        String userName;

        UserInfo(PasswordManager this$0) {
        }
    }
}

