/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.stereotype.Component;

@Component
public class NotificationSender
implements BundleContextAware,
DisposableBean {
    private ServiceTracker serviceTracker_m = null;
    private static String className_m = "com.atlassian.mywork.service.LocalNotificationService";
    private static final Logger logger_m = LoggerFactory.getLogger(NotificationSender.class);

    public void sendNotification(String pluginKey, String userName, String title, String pageUrl, String message) {
        try {
            LocalNotificationService localNotificationService = (LocalNotificationService)this.serviceTracker_m.getService();
            if (localNotificationService != null) {
                localNotificationService.createOrUpdate(userName, new NotificationBuilder().application(pluginKey).title(title).itemTitle(title).itemUrl(pageUrl).description(message).groupingId(pluginKey + ".notifications").createNotification()).get();
            } else {
                logger_m.error("LocalNotificationService class not found");
            }
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.serviceTracker_m = new ServiceTracker(bundleContext, className_m, null);
        this.serviceTracker_m.open();
    }

    public void destroy() throws Exception {
        this.serviceTracker_m.close();
    }
}

