/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseCheck {
    public final PluginLicenseManager pluginLicenseManager_m;
    public final PluginAccessor pluginAccessor_m;
    private final AppConfigSettings appConfigSettings_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());
    private Long jarFileTime_m = 0L;
    private LocalDate lastLogTime_m = null;
    private LocalDate lastValidCheckTime_m = null;
    private final String key_m = "lc-check";
    private final String pluginName_m;
    private final String pluginKey_m;
    private final Plugin plugin_m;
    private static LicenseCheck thisObject_m;

    @Autowired
    public LicenseCheck(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginAccessor pluginAccessor, AppConfigSettings appConfigSettings) {
        this.pluginLicenseManager_m = pluginLicenseManager;
        this.appConfigSettings_m = appConfigSettings;
        this.pluginAccessor_m = pluginAccessor;
        this.pluginKey_m = pluginLicenseManager.getPluginKey();
        this.plugin_m = pluginAccessor.getPlugin(this.pluginKey_m);
        this.pluginName_m = this.plugin_m.getName();
        this.appConfigSettings_m.addLong("lc-check", 0L);
        thisObject_m = this;
    }

    public static LicenseCheck getInstance() {
        return thisObject_m;
    }

    public String getPluginKey() {
        return this.pluginKey_m;
    }

    public Plugin getPlugin() {
        return this.plugin_m;
    }

    public Plugin getPlugin(String pluginKey) {
        return this.pluginAccessor_m.getPlugin(pluginKey);
    }

    public String getPluginVersion() {
        return this.plugin_m.getPluginInformation().getVersion();
    }

    private void logLicenseError(String message) {
        LocalDate now = LocalDate.now();
        if (this.lastLogTime_m == null || this.lastLogTime_m.isBefore(now.minusDays(1L))) {
            this.lastLogTime_m = now;
            this.logger_m.error(message);
        }
    }

    public boolean isLicenseOK() {
        LocalDate now;
        block20: {
            now = LocalDate.now();
            if (this.lastValidCheckTime_m != null && now.isBefore(this.lastValidCheckTime_m.plusDays(1L))) {
                this.logger_m.info("License still valid, less than one day");
                return true;
            }
            Map params = this.plugin_m.getPluginInformation().getParameters();
            boolean paidApp = false;
            if (params.containsKey("atlassian-licensing-enabled")) {
                paidApp = ((String)params.get("atlassian-licensing-enabled")).equalsIgnoreCase("true");
            }
            String pluginVersion = this.plugin_m.getPluginInformation().getVersion();
            this.logger_m.info("Confluence Version: {} Plugin Version: {}", (Object)GeneralUtil.getVersionNumber(), (Object)pluginVersion);
            if (!paidApp) {
                this.lastValidCheckTime_m = now;
                return true;
            }
            try {
                if (this.pluginLicenseManager_m.getLicense().isDefined()) {
                    PluginLicense license = (PluginLicense)this.pluginLicenseManager_m.getLicense().get();
                    if (license.getError().isDefined()) {
                        LicenseError error = (LicenseError)license.getError().get();
                        switch (error.name()) {
                            case "EXPIRED": {
                                this.logLicenseError("Invalid license: Your license of \"" + this.pluginName_m + "\" has expired. Please use the 'Buy' button to purchase or renew this license.");
                                return false;
                            }
                            case "USER_MISMATCH": {
                                this.logLicenseError("Invalid license: Your \"" + this.pluginName_m + "\" plugin license User Limit is lower than your Confluence license User Limit. Please upgrade your \"" + this.pluginName_m + "\" license.");
                                return false;
                            }
                            case "VERSION_MISMATCH": {
                                this.logLicenseError("Invalid license: Your license for maintenance of \"" + this.pluginName_m + "\" is not valid for this Confluence version. Please use the 'Renew' button to renew your license.");
                                return false;
                            }
                            case "TYPE_MISMATCH": {
                                this.logLicenseError("Invalid license: Your \"" + this.pluginName_m + "\" license does not match the license type on this Confluence installation. Please purchase the correct license.");
                                return false;
                            }
                        }
                        this.logLicenseError("Invalid license: \"" + this.pluginName_m + "\" Unknown license error.");
                        return false;
                    }
                    if (license.isEvaluation() && this.evaluationExceededTime(now)) {
                        this.logLicenseError("Invalid license: You've exceeded the max number of Evaluation licenses for \"" + this.pluginName_m + "\". Please use the 'Buy' button to purchase a license.");
                        return false;
                    }
                    break block20;
                }
                this.logLicenseError(this.pluginName_m + ": Plugin is unlicensed, there is no license installed for this plugin");
                return false;
            }
            catch (Exception e) {
                this.logger_m.error(e.getMessage());
                return false;
            }
        }
        this.lastValidCheckTime_m = now;
        return true;
    }

    private boolean evaluationExceededTime(LocalDate now) {
        long milliPerDay = 86400000L;
        long MAX_EVAL_PERIOD = 120L;
        try {
            Long value = this.appConfigSettings_m.getLong("lc-check");
            if (value == null || value == 0L) {
                this.appConfigSettings_m.setLong("lc-check", now.toEpochDay());
                return false;
            }
            if (value > 86400000L) {
                this.appConfigSettings_m.setLong("lc-check", now.toEpochDay());
                return false;
            }
            return now.toEpochDay() - 120L > value;
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
            this.appConfigSettings_m.setLong("lc-check", now.toEpochDay());
            return false;
        }
    }

    private boolean isTrialValid(String pluginName) {
        boolean trialValid;
        Calendar timeNow = Calendar.getInstance();
        Calendar gracePeriod = Calendar.getInstance();
        gracePeriod.setTimeInMillis(this.getJarFileTime());
        int gracePeriodDays_m = 30;
        gracePeriod.add(5, gracePeriodDays_m);
        boolean bl = trialValid = timeNow.compareTo(gracePeriod) < 0;
        if (trialValid) {
            this.logLicenseError(pluginName + ": Trial License is Active");
        }
        return trialValid;
    }

    private Long getJarFileTime() {
        if (this.jarFileTime_m == 0L) {
            try {
                String url = LicenseCheck.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                url = URLDecoder.decode(url, "UTF-8");
                String path = url.replace("file:", "");
                JarFile jf = new JarFile(path);
                ZipEntry manifest = jf.getEntry("META-INF/MANIFEST.MF");
                this.jarFileTime_m = manifest.getTime();
                jf.close();
            }
            catch (Exception e) {
                this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
            }
        }
        return this.jarFileTime_m;
    }
}

