/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.lang.management.ManagementFactory;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceDCChecker {
    private final ClusterManager clusterManager_m;
    private final LicenseService baseLicenseDetails_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());

    @Autowired
    public ConfluenceDCChecker(@ComponentImport ClusterManager clusterManager, @ComponentImport LicenseService baseLicenseDetails) {
        this.clusterManager_m = clusterManager;
        this.baseLicenseDetails_m = baseLicenseDetails;
        this.logger_m.info("DataCenter version: " + this.isDataCenter());
    }

    public boolean isDataCenter() {
        boolean inDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-Datlassian.dev.mode=true");
        return this.baseLicenseDetails_m.isLicensedForDataCenter() || inDebug;
    }

    public boolean hasCurrentNodeLowestId() {
        if (!this.clusterManager_m.isClustered()) {
            return true;
        }
        return this.clusterManager_m.getAllNodesInformation().stream().sorted(Comparator.comparing(ClusterNodeInformation::getAnonymizedNodeIdentifier)).findFirst().map(ClusterNodeInformation::getAnonymizedNodeIdentifier).map(this.clusterManager_m.getThisNodeInformation().getAnonymizedNodeIdentifier()::equals).orElse(true);
    }
}

