/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class AppConfigSettings {
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());
    private final PluginSettings pluginSettings_m;
    private final String delimiter_m = "\u00b1";

    @Autowired
    public AppConfigSettings(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.pluginSettings_m = pluginSettingsFactory.createSettingsForKey(pluginLicenseManager.getPluginKey());
    }

    public void addString(String key, String defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, (Object)defaultValue);
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)defaultValue);
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, (Object)defaultValue);
        }
    }

    public void setString(String key, String newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, (Object)newData);
        this.pluginSettings_m.put(key, (Object)newData);
    }

    public String getString(String key) {
        String temp = (String)this.pluginSettings_m.get(key);
        return temp == null ? "" : temp;
    }

    public void addBoolean(String key, Boolean defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, (Object)defaultValue);
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)Boolean.toString(defaultValue));
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, (Object)defaultValue);
        }
    }

    public void setBoolean(String key, Boolean newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, (Object)newData);
        this.pluginSettings_m.put(key, (Object)Boolean.toString(newData));
    }

    @Nullable
    public Boolean getBoolean(String key) {
        String value = (String)this.pluginSettings_m.get(key);
        if (value == null) {
            this.logger_m.error("Key not found: {}", (Object)key);
            return null;
        }
        return Boolean.valueOf(value);
    }

    public void addLong(String key, Long defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, (Object)defaultValue);
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)Long.toString(defaultValue));
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, (Object)defaultValue);
        }
    }

    public void setLong(String key, Long newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, (Object)newData);
        this.pluginSettings_m.put(key, (Object)Long.toString(newData));
    }

    @Nullable
    public Long getLong(String key) {
        String value = (String)this.pluginSettings_m.get(key);
        if (value == null) {
            this.logger_m.error("Key not found: {}", (Object)key);
            return null;
        }
        return Long.valueOf(value);
    }

    public void addInstant(String key, Instant defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, (Object)defaultValue);
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)defaultValue.toString());
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, (Object)defaultValue);
        }
    }

    public void setInstant(String key, Instant newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, (Object)newData);
        this.pluginSettings_m.put(key, (Object)newData.toString());
    }

    @Nullable
    public Instant getInstant(String key) {
        String value = (String)this.pluginSettings_m.get(key);
        if (value == null) {
            this.logger_m.error("Key not found: {}", (Object)key);
            return null;
        }
        return Instant.parse(value);
    }

    public void addList(String key, List<String> defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, defaultValue);
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)String.join((CharSequence)"\u00b1", defaultValue));
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, (Object)String.join((CharSequence)"\u00b1", defaultValue));
        }
    }

    public void setList(String key, List<String> newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, newData);
        this.pluginSettings_m.put(key, (Object)String.join((CharSequence)"\u00b1", newData));
    }

    public List<String> getList(String key) {
        String values = (String)this.pluginSettings_m.get(key);
        if (values == null) {
            this.logger_m.error("Key not found: {}", (Object)key);
            return new LinkedList<String>();
        }
        return Arrays.stream(values.split("\u00b1")).filter(value -> !value.isEmpty()).collect(Collectors.toList());
    }
}

