/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.InputStream;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.ConfluenceUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class LicenseCheck {
    public final PluginLicenseManager pluginLicenseManager_m;
    public final PluginAccessor pluginAccessor_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final PluginSettingsFactory pluginSettingsFactory_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());
    private Long jarFileTime_m = 0L;
    private LocalDate lastLogTime_m = null;
    private LocalDate lastValidCheckTime_m = null;
    private String pluginKey_m = "";
    private String pluginName_m = "";

    @Inject
    public LicenseCheck(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginSettingsFactory pluginSettingsFactory, ConfluenceUtilities confluenceUtilities) {
        this.pluginLicenseManager_m = pluginLicenseManager;
        this.pluginAccessor_m = pluginAccessor;
        this.confluenceUtilities_m = confluenceUtilities;
        this.pluginSettingsFactory_m = pluginSettingsFactory;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("pom.properties");
            Properties props = new Properties();
            props.load(is);
            this.pluginKey_m = props.getProperty("atlassian.plugin.key");
            this.pluginName_m = props.getProperty("plugin.name");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPluginKey() {
        return this.pluginKey_m;
    }

    public String getPluginName() {
        return this.pluginName_m;
    }

    public String getPluginVersion() {
        return LicenseCheck.class.getPackage().getImplementationVersion();
    }

    public String getPluginVersion(String pluginKey) {
        return this.pluginAccessor_m.getPlugin(pluginKey).getPluginInformation().getVersion();
    }

    public Plugin getPlugin(String pluginKey) {
        return this.pluginAccessor_m.getPlugin(pluginKey);
    }

    private void logLicenseError(String message) {
        LocalDate now = LocalDate.now();
        if (this.lastLogTime_m == null || this.lastLogTime_m.isBefore(now.minusDays(1L))) {
            this.lastLogTime_m = now;
            this.logger_m.error(message);
        }
    }

    public boolean isLicenseOK() {
        return this.isLicenseOK(this.pluginKey_m);
    }

    public boolean isLicenseOK(String pluginKey) {
        LocalDate now;
        block20: {
            now = LocalDate.now();
            if (this.lastValidCheckTime_m != null && now.isBefore(this.lastValidCheckTime_m.plusDays(1L))) {
                this.logger_m.info("License still valid, less than one day");
                return true;
            }
            Plugin plugin = this.getPlugin(pluginKey);
            String pluginName = plugin.getName();
            String pluginVersion = plugin.getPluginInformation().getVersion();
            Map params = plugin.getPluginInformation().getParameters();
            boolean paidApp = false;
            if (params.containsKey("atlassian-licensing-enabled")) {
                paidApp = ((String)params.get("atlassian-licensing-enabled")).equalsIgnoreCase("true");
            }
            this.logger_m.info("Confluence Version: {} Plugin Version: {}", (Object)GeneralUtil.getVersionNumber(), (Object)pluginVersion);
            if (!paidApp) {
                this.lastValidCheckTime_m = now;
                return true;
            }
            try {
                if (this.pluginLicenseManager_m.getLicense().isDefined()) {
                    PluginLicense license = (PluginLicense)this.pluginLicenseManager_m.getLicense().get();
                    if (license.getError().isDefined()) {
                        LicenseError error = (LicenseError)license.getError().get();
                        switch (error.name()) {
                            case "EXPIRED": {
                                this.logLicenseError("Invalid license: Your license of \"" + pluginName + "\" has expired. Please use the 'Buy' button to purchase or renew this license.");
                                return false;
                            }
                            case "USER_MISMATCH": {
                                this.logLicenseError("Invalid license: Your \"" + pluginName + "\" plugin license User Limit is lower than your Confluence license User Limit. Please upgrade your \"" + pluginName + "\" license.");
                                return false;
                            }
                            case "VERSION_MISMATCH": {
                                this.logLicenseError("Invalid license: Your license for maintenance of \"" + pluginName + "\" is not valid for this Confluence version. Please use the 'Renew' button to renew your license.");
                                return false;
                            }
                            case "TYPE_MISMATCH": {
                                this.logLicenseError("Invalid license: Your \"" + pluginName + "\" license does not match the license type on this Confluence installation. Please purchase the correct license.");
                                return false;
                            }
                        }
                        this.logLicenseError("Invalid license: \"" + pluginName + "\" Unknown license error.");
                        return false;
                    }
                    if (license.isEvaluation() && this.evaluationExceededTime(pluginKey, now)) {
                        this.logLicenseError("Invalid license: You've exceeded the max number of Evaluation licenses for \"" + pluginName + "\". Please use the 'Buy' button to purchase a license.");
                        return false;
                    }
                    break block20;
                }
                this.logLicenseError(pluginName + ": Plugin is unlicensed, there is no license installed for this plugin");
                return false;
            }
            catch (Exception e) {
                this.logger_m.error(e.getMessage());
                return false;
            }
        }
        this.lastValidCheckTime_m = now;
        return true;
    }

    private boolean evaluationExceededTime(String pluginKey, LocalDate now) {
        long milliPerDay = 86400000L;
        long MAX_EVAL_PERIOD = 120L;
        String key = "articles";
        PluginSettings settings = this.pluginSettingsFactory_m.createSettingsForKey(pluginKey);
        try {
            String its = (String)settings.get("articles");
            if (its == null) {
                settings.put("articles", (Object)Long.toString(now.toEpochDay()));
                return false;
            }
            long value = Long.parseLong(its);
            if (value > 86400000L) {
                settings.remove("articles");
                return false;
            }
            return now.toEpochDay() - 120L > value;
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
            settings.remove("articles");
            return false;
        }
    }

    private boolean isTrialValid(String pluginName) {
        boolean trialValid;
        Calendar timeNow = Calendar.getInstance();
        Calendar gracePeriod = Calendar.getInstance();
        gracePeriod.setTimeInMillis(this.getJarFileTime(LicenseCheck.class));
        int gracePeriodDays_m = 30;
        gracePeriod.add(5, gracePeriodDays_m);
        boolean bl = trialValid = timeNow.compareTo(gracePeriod) < 0;
        if (trialValid) {
            this.logLicenseError(pluginName + ": Trial License is Active");
        }
        return trialValid;
    }

    private Long getJarFileTime(Class<?> cl) {
        if (this.jarFileTime_m == 0L) {
            try {
                String url = cl.getProtectionDomain().getCodeSource().getLocation().getPath();
                url = URLDecoder.decode(url, "UTF-8");
                String path = url.replace("file:", "");
                JarFile jf = new JarFile(path);
                ZipEntry manifest = jf.getEntry("META-INF/MANIFEST.MF");
                this.jarFileTime_m = manifest.getTime();
                jf.close();
            }
            catch (Exception e) {
                this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
            }
        }
        return this.jarFileTime_m;
    }
}

