/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.SpaceStatus;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.service.content.AttachmentService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ContentManager {
    private static final Expansion body = new Expansion("body", new Expansions(new Expansion[]{new Expansion("storage")}));
    private static final Expansion space = new Expansion("space");
    private static final Expansion metadata = new Expansion("metadata", new Expansions(new Expansion[]{new Expansion("labels")}));
    private static final Expansion descendants = new Expansion("descendants");
    private static final Expansion container = new Expansion("container");
    private static final Expansion children = new Expansion("children", new Expansions(new Expansion[]{new Expansion("attachment"), new Expansion("comment"), new Expansion("page")}));
    private static final Expansion ancestors = new Expansion("ancestors");
    private static final Expansion version = new Expansion("version");
    private static final Expansion restrictions = new Expansion("restrictions");
    private static final Expansion[] expansions = new Expansion[]{body, space, metadata, descendants, container, children, ancestors, version, restrictions};
    private static PageManager pageManager_m;
    private static ContentService contentService_m;
    private static SpaceService spaceService_m;
    private static AttachmentService attachmentService_m;
    private static CQLSearchService searchService_m;
    private static SearchContext searchContext_m;
    private static Logger logger_m;
    private static String baseUrl_m;

    @Inject
    public ContentManager(@ComponentImport ContentService contentService, @ComponentImport SpaceService spaceService, @ComponentImport AttachmentService attachmentService, @ComponentImport CQLSearchService searchService, @ComponentImport PageManager pageManager, @ComponentImport GlobalSettingsManager settingsManager) {
        contentService_m = contentService;
        spaceService_m = spaceService;
        attachmentService_m = attachmentService;
        searchService_m = searchService;
        pageManager_m = pageManager;
        ArrayList<ContentStatus> list = new ArrayList<ContentStatus>();
        list.add(ContentStatus.CURRENT);
        searchContext_m = SearchContext.builder().contentStatus(list).build();
        baseUrl_m = settingsManager.getGlobalSettings().getBaseUrl();
    }

    @Nullable
    public static String getContentBody(String contentId) {
        Content content = (Content)contentService_m.find(expansions).withId(ContentId.valueOf((String)contentId)).fetchOrNull();
        if (content != null) {
            Map body = content.getBody();
            return ((ContentBody)body.get(ContentRepresentation.VIEW)).getValue();
        }
        return null;
    }

    @Nullable
    public static Content getContentById(Long contentId) {
        return (Content)contentService_m.find(expansions).withStatus(new ContentStatus[]{ContentStatus.CURRENT}).withId(ContentId.of((long)contentId)).fetchOrNull();
    }

    @Nullable
    public static Content getPageByTitle(String spaceKey, String title) {
        return (Content)contentService_m.find(expansions).withSpace(new Space[]{Space.builder().key(spaceKey).build()}).withTitle(title).withType(new ContentType[]{ContentType.PAGE}).withStatus(new ContentStatus[]{ContentStatus.CURRENT}).fetchOrNull();
    }

    @Nullable
    public static Content getBlogPost(String spaceKey, String title, Calendar posted) {
        LocalDate localDate = LocalDateTime.ofInstant(posted.toInstant(), posted.getTimeZone().toZoneId()).toLocalDate();
        return (Content)contentService_m.find(expansions).withSpace(new Space[]{Space.builder().key(spaceKey).build()}).withTitle(title).withCreatedDate(localDate).withType(new ContentType[]{ContentType.BLOG_POST}).withStatus(new ContentStatus[]{ContentStatus.CURRENT}).fetchOrNull();
    }

    @Nullable
    public static Content getBlogPost(long id) {
        return (Content)contentService_m.find(expansions).withId(ContentId.of((long)id)).fetchOrNull();
    }

    @Nullable
    public static PageResponse<Content> getPages(String spaceKey) {
        return contentService_m.find(expansions).withSpace(new Space[]{Space.builder().key(spaceKey).build()}).withStatus(new ContentStatus[]{ContentStatus.CURRENT}).fetchMany(ContentType.PAGE, (PageRequest)new SimplePageRequest(0, 1000));
    }

    @Nullable
    public static PageResponse<Content> getNextPages(String spaceKey, PageResponse<Content> results) {
        int limit = results.getPageRequest().getLimit();
        if (results.hasMore()) {
            int start = results.getPageRequest().getStart() + limit;
            return contentService_m.find(expansions).withSpace(new Space[]{Space.builder().key(spaceKey).build()}).withStatus(new ContentStatus[]{ContentStatus.CURRENT}).fetchMany(ContentType.PAGE, (PageRequest)new SimplePageRequest(start, limit));
        }
        return null;
    }

    @Nullable
    public static PageResponse<Content> getBlogPosts(String spaceKey) {
        return contentService_m.find(expansions).withSpace(new Space[]{Space.builder().key(spaceKey).build()}).withStatus(new ContentStatus[]{ContentStatus.CURRENT}).fetchMany(ContentType.BLOG_POST, (PageRequest)new SimplePageRequest(0, 1000));
    }

    @Nullable
    public static PageResponse<Content> getNextBlogPosts(String spaceKey, PageResponse<Content> results) {
        int limit = results.getPageRequest().getLimit();
        if (results.hasMore()) {
            int start = results.getPageRequest().getStart() + limit;
            return contentService_m.find(expansions).withSpace(new Space[]{Space.builder().key(spaceKey).build()}).withStatus(new ContentStatus[]{ContentStatus.CURRENT}).fetchMany(ContentType.BLOG_POST, (PageRequest)new SimplePageRequest(start, limit));
        }
        return null;
    }

    @Nullable
    public static SearchPageResponse<Content> startSearch(String text) {
        return (SearchPageResponse)searchService_m.searchContent(text, searchContext_m, (PageRequest)new SimplePageRequest(0, 1000), expansions);
    }

    @Nullable
    public static SearchPageResponse<Content> nextSearch(SearchPageResponse<Content> results) {
        int limit = results.getPageRequest().getLimit();
        if (results.hasMore()) {
            int start = results.getPageRequest().getStart() + limit;
            return (SearchPageResponse)searchService_m.searchContent(results.getCqlQuery(), searchContext_m, (PageRequest)new SimplePageRequest(start, limit), expansions);
        }
        return null;
    }

    public static long countPages(String spaceKey) {
        return searchService_m.countContent("type=page AND space=\"" + spaceKey + "\"");
    }

    public static long countBlogPosts(String spaceKey) {
        return searchService_m.countContent("type=blogpost AND space=\"" + spaceKey + "\"");
    }

    public static long countAttachments(String spaceKey) {
        return searchService_m.countContent("type=attachment AND space=\"" + spaceKey + "\"");
    }

    @Nullable
    public static Space getSpace(String spaceKey) {
        return (Space)spaceService_m.find(expansions).withKeys(new String[]{spaceKey}).withStatus(SpaceStatus.CURRENT).fetchOrNull();
    }

    public static void savePageVersion(Content content, ConfluenceUser user, String versionComment, String body, boolean sendEmail, boolean sendEvent) throws InterruptedException {
        int ver = content.getVersion().getNumber();
        Version version = Version.builder().number(ver + 1).message(versionComment).by((Person)User.fromUsername((String)user.getName())).minorEdit(sendEmail || sendEvent).build();
        Content toBeUpdatedContent = Content.builder((Content)content).body(body, ContentRepresentation.STORAGE).version(version).build();
        contentService_m.update(toBeUpdatedContent);
    }

    @Deprecated
    public static PageResponse<Content> getComments(Content content) {
        Expansion children = new Expansion("children", new Expansions(new Expansion[]{new Expansion("comment")}));
        return contentService_m.find(new Expansion[]{children}).withContainer((Container)content).fetchMany(ContentType.COMMENT, (PageRequest)new SimplePageRequest(0, 1000));
    }

    public static List<Content> getContentChildren(Content content) {
        Map children = content.getChildren();
        if (children.containsKey(ContentType.PAGE)) {
            return (List)children.get(ContentType.PAGE);
        }
        return null;
    }

    public static List<Content> getContentComments(Content content) {
        Map children = content.getChildren();
        if (children.containsKey(ContentType.COMMENT)) {
            return (List)children.get(ContentType.COMMENT);
        }
        return null;
    }

    public static List<Content> getContentAttachments(Content content) {
        Map children = content.getChildren();
        if (children.containsKey(ContentType.ATTACHMENT)) {
            return (List)children.get(ContentType.ATTACHMENT);
        }
        return null;
    }

    public static String getUrlPath(Content content) {
        if (content.getLinks().containsKey(LinkType.TINY_UI)) {
            return baseUrl_m + ((Link)content.getLinks().get(LinkType.TINY_UI)).getPath();
        }
        return baseUrl_m;
    }

    @Nullable
    public static List<Label> getLabels(Content content) {
        Map metadata = content.getMetadata();
        if (metadata.containsKey("labels")) {
            return (List)metadata.get("labels");
        }
        return null;
    }

    @Nullable
    public static Content getAttachment(Long attachmentId) {
        return (Content)attachmentService_m.find(expansions).withId(ContentId.of((long)attachmentId)).fetchOrNull();
    }

    @Nullable
    public static User getCreator(Content content) {
        ConfluenceUser user;
        ContentEntityObject ceo = pageManager_m.getById(content.getId().asLong());
        if (ceo != null && (user = ceo.getCreator()) != null) {
            return User.fromUserkey((UserKey)user.getKey());
        }
        return null;
    }

    static {
        logger_m = LoggerFactory.getLogger(ContentManager.class);
    }
}

