/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools.servlets;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionReplacer;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.IOException;
import java.util.GregorianCalendar;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.blogtools.BlogToolsMain;
import net.kentcom.blogtools.MetadataAccessor;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.ContentManager;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBlogServlet
extends HttpServlet {
    private final PageManager pageManager_m;
    private final DraftManager draftManager_m;
    private final TrashManager trashManager_m;
    private final SpaceManager spaceManager_m;
    private final XhtmlContent xhtmlContent_m;
    private final TransactionTemplate transactionTemplate_m;
    private final BlogToolsMain blogToolsMain_m;
    private final LicenseCheck licenseCheck_m;
    private final MetadataAccessor metadataAccessor_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    @Inject
    public CreateBlogServlet(@ComponentImport PageManager pageManager, @ComponentImport DraftManager draftManager, @ComponentImport TrashManager trashManager, @ComponentImport SpaceManager spaceManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport TransactionTemplate transactionTemplate, ConfluenceUtilities confluenceUtilities, BlogToolsMain blogToolsMain, MetadataAccessor metadataAccessor, LicenseCheck licenseCheck) {
        this.pageManager_m = pageManager;
        this.draftManager_m = draftManager;
        this.trashManager_m = trashManager;
        this.spaceManager_m = spaceManager;
        this.xhtmlContent_m = xhtmlContent;
        this.blogToolsMain_m = blogToolsMain;
        this.licenseCheck_m = licenseCheck;
        this.metadataAccessor_m = metadataAccessor;
        this.transactionTemplate_m = transactionTemplate;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    @LicensedOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger_m.info("doPost");
        if (!this.licenseCheck_m.isLicenseOK()) {
            response.setStatus(402);
            return;
        }
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(405);
            return;
        }
        String pageTitle = request.getParameter("pageTitle");
        String draftIdStr = StringUtil.htmlEscape(request.getParameter("draftId"));
        String spaceKey = StringUtil.htmlEscape(request.getParameter("spaceKey"));
        GregorianCalendar today = new GregorianCalendar();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        this.logger_m.info("pageTitle: " + pageTitle + " SpaceKey: " + spaceKey + " DraftId: " + draftIdStr);
        if (pageTitle == null || pageTitle.isEmpty()) {
            this.logger_m.info("Missing Page Title");
            response.setStatus(420);
            return;
        }
        if (ContentManager.getBlogPost(spaceKey, pageTitle, today) != null) {
            this.logger_m.info("Duplicate Page Title");
            response.setStatus(421);
            return;
        }
        Space space = this.spaceManager_m.getSpace(spaceKey);
        if (space == null) {
            this.logger_m.info("Invalid Space");
            response.setStatus(422);
            return;
        }
        try {
            long draftId = Long.parseLong(draftIdStr);
            Page source = null;
            try {
                source = this.pageManager_m.getPage(draftId);
            }
            catch (Exception e) {
                this.logger_m.info("getPage threw Exception draftId is a Draft??");
                source = this.draftManager_m.getDraft(draftId);
            }
            if (source == null) {
                this.logger_m.info("source not page, looking for draft...");
                source = this.draftManager_m.getDraft(draftId);
                if (source == null) {
                    this.logger_m.info("draft not found, looking for user draft...");
                    for (Draft draft : this.draftManager_m.findDraftsForUser(user)) {
                        this.logger_m.info("Draft ID:     " + draft.getIdAsString());
                        this.logger_m.info("============");
                        if (!draft.getIdAsString().equals(draftIdStr)) continue;
                        source = draft;
                        this.logger_m.info("From Draft");
                        break;
                    }
                }
            } else {
                this.logger_m.info("From Page");
            }
            if (source != null) {
                this.logger_m.info("Creating blog");
                BlogPost blog = this.createBlog(spaceKey, pageTitle, user, (ContentEntityObject)source);
                this.logger_m.info("Deleting Original source");
                if (source instanceof Page) {
                    this.pageManager_m.removeContentEntity((ContentEntityObject)source);
                } else {
                    this.draftManager_m.removeDraft((Draft)source);
                }
                this.trashManager_m.purge(spaceKey, draftId);
                this.logger_m.info("Original source removed");
                response.setStatus(200);
                try {
                    response.getWriter().write(blog.getUrlPath());
                }
                catch (IOException e) {
                    this.logger_m.error(e.getMessage());
                }
            } else {
                this.logger_m.info("Unable to find source");
                response.setStatus(426);
            }
        }
        catch (NumberFormatException e) {
            this.logger_m.info("Invalid Draft ID");
            response.setStatus(423);
        }
        catch (IllegalStateException e) {
            this.logger_m.info("Unable to purge Draft");
            response.setStatus(424);
        }
    }

    private BlogPost createBlog(String spaceKey, String pageTitle, ConfluenceUser user, ContentEntityObject draft) {
        this.logger_m.info("createBlog");
        BlogPost blog = new BlogPost();
        Space space = this.spaceManager_m.getSpace(spaceKey);
        blog.setSpace(space);
        blog.setTitle(pageTitle);
        blog.setCreationDate(draft.getCreationDate());
        blog.setCreator(user);
        blog.setBodyContent(draft.getBodyContent());
        blog.setLastModifier(user);
        this.removeMacroFromPage((ContentEntityObject)blog);
        this.blogToolsMain_m.copyRestrictionsByType(draft, (ContentEntityObject)blog, "View");
        this.blogToolsMain_m.copyRestrictionsByType(draft, (ContentEntityObject)blog, "Edit");
        this.blogToolsMain_m.copyLabels((Labelable)draft, (Labelable)blog);
        this.metadataAccessor_m.copyMetadata(draft, (ContentEntityObject)blog);
        this.blogToolsMain_m.copyAttachments(draft, (ContentEntityObject)blog);
        DefaultSaveContext.Builder builder = DefaultSaveContext.builder();
        builder.suppressEvents(false);
        builder.suppressAutowatch(false);
        builder.suppressNotifications(false);
        DefaultSaveContext saveContext = builder.build();
        this.pageManager_m.saveContentEntity((ContentEntityObject)blog, (SaveContext)saveContext);
        this.logger_m.info("End of createBlog");
        return blog;
    }

    private void removeMacroFromPage(ContentEntityObject ceo) {
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)new PageContext(ceo));
        try {
            ceo.setBodyAsString(this.xhtmlContent_m.replaceMacroDefinitionsWithString(ceo.getBodyAsString(), (ConversionContext)context, new MacroDefinitionReplacer(){
                final /* synthetic */ ConversionContext val$context;
                {
                    this.val$context = conversionContext;
                }

                public String replace(MacroDefinition macroDefinition) throws XhtmlException {
                    if ("page-to-blog-macro".equals(macroDefinition.getName())) {
                        return "";
                    }
                    return CreateBlogServlet.this.xhtmlContent_m.convertMacroDefinitionToStorage(macroDefinition, this.val$context);
                }
            }));
        }
        catch (XhtmlException e) {
            this.logger_m.error(e.getMessage());
        }
    }
}

