/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common.cron.rule.field;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import net.kentcom.common.cron.rule.field.DayOfWeekConstantConverter;
import net.kentcom.common.cron.rule.field.SpecialDayFieldRule;

public class SpecialDayOfWeekNthFieldRule
extends SpecialDayFieldRule {
    private static final long serialVersionUID = 6051673567197325589L;
    private final int isoDayOfWeek;
    private final int nth;

    public SpecialDayOfWeekNthFieldRule(int cronDayOfWeek, int nth) {
        if (cronDayOfWeek < 1 || cronDayOfWeek > 7) {
            throw new IllegalArgumentException(String.valueOf("cronDayOfWeek must be in the range [1,7]"));
        }
        if (nth < 1 || nth > 5) {
            throw new IllegalArgumentException(String.valueOf("nth must be in the range [1,5]"));
        }
        this.isoDayOfWeek = DayOfWeekConstantConverter.cronToIso(cronDayOfWeek);
        this.nth = nth;
    }

    @Override
    int calculateMatchingDay(int year, int month) {
        LocalDate lastDayOfMonth;
        LocalDate firstDayOfMonth = LocalDate.of(year, month, 1);
        LocalDate date = this.calculateNthDayOfWeekFromFirstOfMonth(firstDayOfMonth);
        if (date.isAfter(lastDayOfMonth = firstDayOfMonth.withDayOfMonth(firstDayOfMonth.lengthOfMonth()))) {
            return -1;
        }
        return date.getDayOfMonth();
    }

    private LocalDate calculateNthDayOfWeekFromFirstOfMonth(LocalDate firstDayOfMonth) {
        DayOfWeek targetDayOfWeek = DayOfWeek.of(this.isoDayOfWeek);
        LocalDate date = firstDayOfMonth.getDayOfWeek().getValue() < this.isoDayOfWeek ? firstDayOfMonth.with(TemporalAdjusters.next(targetDayOfWeek)) : firstDayOfMonth.with(TemporalAdjusters.previousOrSame(targetDayOfWeek));
        if (date.isBefore(firstDayOfMonth)) {
            return date.plusWeeks(this.nth);
        }
        return date.plusWeeks(this.nth - 1);
    }

    @Override
    protected void appendTo(StringBuilder sb) {
        sb.append(DayOfWeekConstantConverter.isoToName(this.isoDayOfWeek)).append('#').append(this.nth);
    }
}

