/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.text.NumberFormat;
import java.util.List;
import javax.inject.Inject;
import net.kentcom.common.ContentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityHelper {
    private final XhtmlContent xhtmlContent_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());

    @Inject
    public VelocityHelper(@ComponentImport XhtmlContent xhtmlContent) {
        this.xhtmlContent_m = xhtmlContent;
    }

    @HtmlSafe
    public String convertStorageToView(String storage, Long pageId) {
        String view = "";
        DefaultConversionContext cc = new DefaultConversionContext(new RenderContext());
        try {
            this.logger_m.info(storage);
            view = this.xhtmlContent_m.convertStorageToView(storage, (ConversionContext)cc);
            this.logger_m.info(view);
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
        }
        return view;
    }

    public Content getById(Long contentId) {
        return ContentManager.getContentById(contentId);
    }

    public String getUrl(Content content) {
        return ContentManager.getUrlPath(content);
    }

    public List<Label> getLabels(Content content) {
        return ContentManager.getLabels(content);
    }

    public String getLabelName(Label label) {
        if (label.getPrefix().equalsIgnoreCase("global")) {
            return label.getLabel();
        }
        return null;
    }

    public String displayCurrency(Double money) {
        try {
            NumberFormat formatter = NumberFormat.getCurrencyInstance();
            return formatter.format(money);
        }
        catch (Exception e) {
            return "";
        }
    }
}

