/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class MailService {
    private final MultiQueueTaskManager multiQueueTaskManager_m;
    private final MailServerManager mailServerManager_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String MAIL_m = "mail";

    @Inject
    public MailService(@ComponentImport MailServerManager mailServerManager, @ComponentImport MultiQueueTaskManager taskManager) {
        this.multiQueueTaskManager_m = taskManager;
        this.mailServerManager_m = mailServerManager;
    }

    public void sendSMTPEmail(MailQueueItem mailQueueItem) throws Exception {
        List mailServers = this.mailServerManager_m.getServerNames();
        if (mailServers.isEmpty()) {
            this.logger_m.error("No Mail servers configured");
            throw new RuntimeException("No Mail servers configured");
        }
        this.multiQueueTaskManager_m.addTask("mail", (Task & Serializable)() -> mailQueueItem.send());
    }

    public void sendSMTPEmail(String to, String subject, String message, String mimeType, String SMTPMailServer2) throws Exception {
        List servers = this.mailServerManager_m.getSmtpMailServers();
        for (SMTPMailServer server : servers) {
            if (!server.getName().equalsIgnoreCase(SMTPMailServer2)) continue;
            Email mail = new Email(to);
            mail.setBody(message);
            mail.setSubject(subject);
            mail.setMimeType(mimeType);
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(SMTPMailServer.class.getClassLoader());
            server.send(mail);
            Thread.currentThread().setContextClassLoader(threadClassLoader);
            return;
        }
        this.logger_m.error("SMTP Mail server missing: " + SMTPMailServer2);
        throw new RuntimeException("Missing requested SMTP Mail server: " + SMTPMailServer2);
    }
}

