/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.BlogPostResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.Modification;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.wysiwyg.DefaultConfluenceWysiwygConverter;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.Link;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.wysiwyg.WysiwygConverter;
import com.atlassian.renderer.wysiwyg.converter.DefaultWysiwygConverter;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.ContentManager;
import net.kentcom.common.StringUtil;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ConfluenceUtilities {
    private final GlobalSettingsManager settingsManager_m;
    private final UserAccessor userAccessor_m;
    private final PermissionManager permissionManager_m;
    private final SpaceManager spaceManager_m;
    private final PageManager pageManager_m;
    private final XhtmlContent xhtmlContent_m;
    private final ContentPermissionManager contentPermissionManager_m;
    private final AccessModeService accessModeService_m;
    private final ContentPropertyService contentPropertyService_m;
    private final UserManager userManager_m;
    private static final Logger logger_m = LoggerFactory.getLogger(ConfluenceUtilities.class);
    private final Safelist mySafelist_m;
    public static final boolean inDebug_m = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-Datlassian.dev.mode=true");
    public final DateTimeFormatter dateTimeFormat_m;
    public final DateTimeFormatter dateFormat_m;
    public final DateTimeFormatter timeFormat_m;
    private ZoneId zoneId_m;

    @Inject
    public ConfluenceUtilities(@ComponentImport GlobalSettingsManager settingsManager, @ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport UserAccessor userAccessor, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport ContentPermissionManager contentPermissionManager, @ComponentImport ContentPropertyService contentPropertyService, @ComponentImport UserManager userManager, @ComponentImport AccessModeService accessModeService) {
        this.settingsManager_m = settingsManager;
        this.userAccessor_m = userAccessor;
        this.permissionManager_m = permissionManager;
        this.spaceManager_m = spaceManager;
        this.pageManager_m = pageManager;
        this.xhtmlContent_m = xhtmlContent;
        this.contentPermissionManager_m = contentPermissionManager;
        this.accessModeService_m = accessModeService;
        this.contentPropertyService_m = contentPropertyService;
        this.userManager_m = userManager;
        this.mySafelist_m = Safelist.relaxed();
        this.mySafelist_m.removeTags(new String[]{"img"});
        this.mySafelist_m.addTags(new String[]{"hr"});
        this.mySafelist_m.addAttributes(":all", new String[]{"class", "id"});
        String language = settingsManager.getGlobalSettings().getGlobalDefaultLocale();
        String[] loc = language.split("_");
        Locale locale = new Locale(loc[0], loc[1]);
        this.dateTimeFormat_m = new DateTimeFormatterBuilder().appendPattern(formatSettingsManager.getDateTimeFormat()).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(locale);
        this.dateFormat_m = DateTimeFormatter.ofPattern(formatSettingsManager.getDateFormat()).withLocale(locale);
        this.timeFormat_m = DateTimeFormatter.ofPattern(formatSettingsManager.getTimeFormat()).withLocale(locale);
        String timezoneId = settingsManager.getGlobalSettings().getDefaultTimezoneId();
        this.zoneId_m = timezoneId != null ? ZoneId.of(settingsManager.getGlobalSettings().getDefaultTimezoneId()) : ZoneId.systemDefault();
    }

    public boolean isConfluenceReadOnly() {
        if (this.accessModeService_m.isReadOnlyAccessModeEnabled()) {
            logger_m.info("Confluence is in DC Read Only mode");
            return true;
        }
        return false;
    }

    public static void enableLogging() {
        if (inDebug_m) {
            // empty if block
        }
    }

    public String renderDateTime(Instant instant) {
        return this.dateTimeFormat_m.format(instant.atZone(this.zoneId_m));
    }

    public String renderDate(Instant instant) {
        return this.dateFormat_m.format(instant.atZone(this.zoneId_m));
    }

    public String renderDate(LocalDate date) {
        return this.renderDate(date.atStartOfDay().atZone(this.zoneId_m).toInstant());
    }

    public String renderTime(Instant instant) {
        return this.timeFormat_m.format(instant.atZone(this.zoneId_m));
    }

    public synchronized boolean SetPermission(ContentEntityObject ceo, String action, String type, String restrictionType, String restrictionName) {
        logger_m.info(action + " " + restrictionType + " for " + restrictionName);
        boolean modified = false;
        if (restrictionType.equalsIgnoreCase("Group")) {
            if (action.equalsIgnoreCase("Add")) {
                ContentPermission group = ContentPermission.createGroupPermission((String)type, (String)restrictionName);
                ceo.addPermission(group);
                modified = true;
                logger_m.info("Added group restriction " + group.toString());
            } else {
                List permissionSets = this.contentPermissionManager_m.getContentPermissionSets(ceo, type);
                block0: for (ContentPermissionSet permissionSet : permissionSets) {
                    for (ContentPermission permission : permissionSet) {
                        if (!permission.getGroupName().equalsIgnoreCase(restrictionName)) continue;
                        this.contentPermissionManager_m.removeContentPermission(permission);
                        modified = true;
                        logger_m.info("Removed group restriction " + permission.toString());
                        continue block0;
                    }
                }
            }
        } else if (action.equalsIgnoreCase("Add")) {
            ContentPermission user = ContentPermission.createUserPermission((String)type, (ConfluenceUser)this.userAccessor_m.getUserByName(restrictionName));
            ceo.addPermission(user);
            modified = true;
        } else {
            List permissionSets = this.contentPermissionManager_m.getContentPermissionSets(ceo, type);
            block2: for (ContentPermissionSet permissionSet : permissionSets) {
                for (ContentPermission permission : permissionSet) {
                    if (!permission.getUserSubject().getName().equalsIgnoreCase(restrictionName)) continue;
                    this.contentPermissionManager_m.removeContentPermission(permission);
                    modified = true;
                    logger_m.info("Removed User restriction: " + permission.toString());
                    continue block2;
                }
            }
        }
        return modified;
    }

    @Nullable
    public ConfluenceUser getAdminUser() {
        ConfluenceUser admin = this.userAccessor_m.getUserByName("admin");
        if (admin != null && this.userManager_m.isLicensed(admin.getKey())) {
            return admin;
        }
        admin = this.userAccessor_m.getUserByName("administrator");
        if (admin != null && this.userManager_m.isLicensed(admin.getKey())) {
            return admin;
        }
        Group adminGroup = this.userAccessor_m.getGroup("confluence-administrators");
        List admins = (List)this.userAccessor_m.getMembers(adminGroup);
        for (ConfluenceUser user : admins) {
            if (!this.userManager_m.isLicensed(user.getKey())) continue;
            return user;
        }
        return null;
    }

    public String getMacroId(ConversionContext conversionContext) {
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        Optional macroId = macroDefinition.getMacroIdentifier();
        try {
            return ((MacroId)macroId.get()).getId();
        }
        catch (Exception e) {
            return "draft";
        }
    }

    public String warningMessage(String macroName, String message, ConversionContext conversionContext) {
        if (!((String)message).startsWith("<p>")) {
            message = "<p>" + (String)message + "</p>";
        }
        String text = "<ac:structured-macro ac:name=\"warning\">\n<ac:parameter ac:name=\"title\">" + macroName + "</ac:parameter>\n<ac:rich-text-body>" + (String)message + "</ac:rich-text-body>\n</ac:structured-macro>";
        try {
            return this.xhtmlContent_m.convertStorageToView(text, conversionContext);
        }
        catch (Exception e) {
            logger_m.error(ConfluenceUtilities.getStackTrace(e));
            return "ERROR: " + e.toString();
        }
    }

    public String showMessage(String messageType, String macroName, String message, ConversionContext conversionContext) {
        if (!((String)message).startsWith("<p>")) {
            message = "<p>" + (String)message + "</p>";
        }
        String text = String.format("<ac:structured-macro ac:name=\"%s\"><ac:parameter ac:name=\"title\">%s</ac:parameter><ac:rich-text-body>%s</ac:rich-text-body></ac:structured-macro>", messageType.toLowerCase(), macroName, message);
        try {
            return this.xhtmlContent_m.convertStorageToView(text, conversionContext);
        }
        catch (Exception e) {
            logger_m.error(ConfluenceUtilities.getStackTrace(e));
            return "ERROR: " + e.toString();
        }
    }

    public String createLinkToPage(ContentEntityObject ceo) {
        return this.settingsManager_m.getGlobalSettings().getBaseUrl() + ceo.getUrlPath();
    }

    @Nullable
    public ConfluenceUser getUser(String userName) {
        return this.userAccessor_m.getUserByName(userName);
    }

    public boolean isUserAdministrator(ConfluenceUser user, @Nullable String spaceKey) {
        try {
            boolean confAdmin = this.permissionManager_m.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
            boolean spaceAdmin = spaceKey != null && this.permissionManager_m.hasPermission(user, Permission.ADMINISTER, (Object)this.spaceManager_m.getSpace(spaceKey));
            return confAdmin || spaceAdmin;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isUserInGroup(ConfluenceUser user, String group) {
        try {
            if (group == null || group.isEmpty()) {
                return true;
            }
            List groups = this.userAccessor_m.getGroupNamesForUserName(user.getName());
            return groups.contains(group);
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> getUsersInGroup(String groupName) {
        try {
            return this.userAccessor_m.getMemberNamesAsList(this.userAccessor_m.getGroup(groupName));
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public String getEmail(String userName) {
        return this.userAccessor_m.getUserByName(userName).getEmail();
    }

    public String getFullName(String userName) {
        return this.userAccessor_m.getUserByName(userName).getFullName();
    }

    public String getFullNameFromKey(String userKey) {
        UserKey userKey1 = new UserKey(userKey);
        ConfluenceUser user = this.userAccessor_m.getUserByKey(userKey1);
        return user != null ? user.getFullName() : null;
    }

    public ConfluenceUser getUserFromKey(String userKey) {
        return this.userAccessor_m.getUserByKey(new UserKey(userKey));
    }

    public ConfluenceUser getUserFromFullName(String fullName) {
        Pager users = this.userAccessor_m.getUsers();
        while (true) {
            for (User user : users.getCurrentPage()) {
                if (!fullName.equals(user.getFullName())) continue;
                return this.userAccessor_m.getUserByName(user.getName());
            }
            if (users.onLastPage()) break;
            users.nextPage();
        }
        return null;
    }

    public String getImageUrlString(ConfluenceUser user, String i18nAnonymous) {
        String userName;
        Object userPictureUrl;
        String template = "<img id=\"simple-tooltip\" src=\"@userPictureUrl\" class=\"ef-img-circle\" align=\"middle\" width=\"40\" height=\"40\" title=\"@userName\">";
        try {
            userPictureUrl = this.userAccessor_m.getUserProfilePicture((User)user).getUriReference();
            userName = user.getFullName();
        }
        catch (Exception e) {
            userPictureUrl = this.settingsManager_m.getGlobalSettings().getBaseUrl() + "/images/icons/profilepics/default.png";
            userName = i18nAnonymous;
        }
        String html = template.replace("@userPictureUrl", (CharSequence)userPictureUrl);
        return html.replace("@userName", userName);
    }

    public String getHtmlLink(ContentEntityObject page) {
        return "<a href=\"" + this.settingsManager_m.getGlobalSettings().getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
    }

    public String convertHTMLtoWiki(String htmlText) {
        DefaultConfluenceWysiwygConverter converter = new DefaultConfluenceWysiwygConverter();
        converter.setWysiwygConverter((WysiwygConverter)new DefaultWysiwygConverter());
        String wiki = this.replaceEmoticons(htmlText);
        wiki = wiki.replaceAll("<blockquote>[\\s.]*<p>(.*)<\\/p>[\\s.]*<\\/blockquote>", "bq. $1<br>");
        wiki = converter.convertXHtmlToWikiMarkup((ContentEntityObject)null, wiki);
        wiki = wiki.replaceAll("\\\\", "\\n");
        wiki = wiki.replaceAll("\\\\(\\*)|\\\\(\\!)|\\\\(\\-)|\\\\(\\#)", "$1");
        Pattern p = Pattern.compile("(h[\\d]\\..*\\n)(\\n)");
        Matcher m = p.matcher(wiki);
        if (m.find()) {
            wiki = m.replaceAll("$1");
        }
        if ((m = (p = Pattern.compile("(h[1|2]\\..*\\n)(\\n)")).matcher(wiki)).find()) {
            wiki = m.replaceAll("$1");
        }
        return wiki;
    }

    public String replaceEmoticons(String html) {
        Pattern p = Pattern.compile("<img class=\"emoticon (.+?)\" .*?>");
        Matcher m = p.matcher(html);
        String result = html;
        while (m.find()) {
            result = m.group().contains("emoticon-tick") ? m.replaceFirst("(/)") : (m.group().contains("emoticon-smile") ? m.replaceFirst(":)") : (m.group().contains("emoticon-wink") ? m.replaceFirst(";)") : (m.group().contains("emoticon-sad") ? m.replaceFirst(":(") : (m.group().contains("emoticon-cheeky") ? m.replaceFirst(":P") : (m.group().contains("emoticon-laugh") ? m.replaceFirst(":D") : (m.group().contains("emoticon-yellow-star") ? m.replaceFirst("(*y)") : (m.group().contains("emoticon-red-star") ? m.replaceFirst("(*r)") : (m.group().contains("emoticon-green-star") ? m.replaceFirst("(*g)") : (m.group().contains("emoticon-blue-star") ? m.replaceFirst("(*b)") : (m.group().contains("emoticon-warning") ? m.replaceFirst("(!)") : (m.group().contains("emoticon-minus") ? m.replaceFirst("(-)") : (m.group().contains("emoticon-plus") ? m.replaceFirst("(+)") : (m.group().contains("emoticon-question") ? m.replaceFirst("(?)") : (m.group().contains("emoticon-information") ? m.replaceFirst("(i)") : (m.group().contains("emoticon-thumbs-up") ? m.replaceFirst("(y)") : (m.group().contains("emoticon-thumbs-down") ? m.replaceFirst("(n)") : (m.group().contains("emoticon-heart") ? m.replaceFirst("<3") : (m.group().contains("emoticon-broken-heart") ? m.replaceFirst("</3") : (m.group().contains("emoticon-light-on") ? m.replaceFirst("(on)") : (m.group().contains("emoticon-light-off") ? m.replaceFirst("(off)") : m.replaceFirst("Unknown Emoticon: $1")))))))))))))))))))));
            m = p.matcher(result);
        }
        return result;
    }

    public String convertWikitoHTML(String wikiText, ConversionContext pageContext) {
        try {
            return this.xhtmlContent_m.convertWikiToView(wikiText, pageContext, null);
        }
        catch (Exception e) {
            return this.xhtmlContent_m.convertWikiToStorage(wikiText, pageContext, null);
        }
    }

    public String convertLinkToPage(String content, String blogTitle, String pageTitle) {
        Pattern p = Pattern.compile("(<ac:link><ri:)(blog-post)( ri:content-title=\")(" + blogTitle + ")(\" ri:posting-day=\"[0-9|\\/]+)(\" \\/><\\/ac:link>)");
        Matcher m = p.matcher(content);
        String result = content;
        while (m.find()) {
            result = m.replaceFirst("$1page$3" + pageTitle + "$6");
            m = p.matcher(result);
        }
        return result;
    }

    public String convertLinkToBlog(String content, String pageTitle, String blogTitle, String postingDay) {
        Pattern p = Pattern.compile("(<ac:link><ri:)(page)( ri:content-title=\")(" + pageTitle + ")(\" \\/><\\/ac:link>)");
        Matcher m = p.matcher(content);
        String result = content;
        while (m.find()) {
            result = m.replaceFirst("$1blog-post$3" + blogTitle + "\" ri:posting-day=\"" + postingDay + "$5");
            m = p.matcher(result);
        }
        return result;
    }

    public String updateOutgoingLinks(ContentEntityObject updatee, ContentEntityObject from, ContentEntityObject to) {
        if (to instanceof Page) {
            return this.convertLinkToPage(updatee.getBodyAsString(), from.getTitle(), to.getTitle());
        }
        BlogPost post = (BlogPost)to;
        return this.convertLinkToBlog(updatee.getBodyAsString(), from.getTitle(), post.getTitle(), post.getDatePath());
    }

    public String escapeScriptTagsDoNotUse(String text) {
        try {
            text = URLDecoder.decode(text, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text == null ? null : text.replaceAll("(?i)<(\\/?)\\s*(script|style|iframe)\\s*>?", "&lt;$1$2&gt;");
    }

    public String cleanHtml(String text, boolean wiki) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        if (wiki) {
            text = text.replaceAll("\\n", "<br>");
            text = text.replaceAll(" ", "&nbsp;");
        }
        text = StringUtil.htmlUnescape(text);
        String clean = Jsoup.clean((String)text, (Safelist)this.mySafelist_m);
        if (wiki) {
            clean = clean.replaceAll("\\n<br>", "");
            clean = clean.replaceAll("&nbsp;", " ");
        }
        return clean;
    }

    public static String getStackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public String getCallStack() {
        StackTraceElement[] cause = Thread.currentThread().getStackTrace();
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement el : cause) {
            builder.append(el.toString() + "\n");
        }
        return builder.toString();
    }

    public String convertMacroEditorToStorage(String html) {
        Document doc = Jsoup.parse((String)html);
        for (Element el : doc.select(".wysiwyg-macro")) {
            this.replaceHTMLwithXML(doc, el);
        }
        for (Element el : doc.select(".editor-inline-macro")) {
            this.replaceHTMLwithXML(doc, el);
        }
        return doc.body().html();
    }

    private void replaceHTMLwithXML(Document doc, Element el) {
        String macro_body_type;
        Element newEl = doc.createElement("ac:structured-macro");
        newEl.attr("ac:name", el.attr("data-macro-name"));
        newEl.attr("ac:schema-version", el.attr("data-macro-schema-version"));
        String macro_params = el.attr("data-macro-parameters");
        if (!macro_params.isEmpty()) {
            String[] params;
            for (String param : params = macro_params.split("\\|")) {
                String[] keyVal = param.split("=");
                Element parameter = doc.createElement("ac:parameter");
                parameter.attr("ac:name", keyVal[0]);
                parameter.text(keyVal[1]);
                newEl.appendChild((Node)parameter);
            }
        }
        if ((macro_body_type = el.attr("data-macro-body-type")).equalsIgnoreCase("RICH_TEXT")) {
            Element wmb = el.select(".wysiwyg-macro-body").first();
            Element rtb = doc.createElement("ac:rich-text-body");
            if (wmb != null) {
                rtb.html(wmb.html());
            }
            newEl.appendChild((Node)rtb);
        }
        el.replaceWith((Node)newEl);
    }

    public void savePageVersion(String pageId, String userName, String versionComment, String body, boolean sendEmail, boolean sendEvent) throws InterruptedException {
        this.savePageVersion(this.pageManager_m.getById(Long.parseLong(pageId)), this.userAccessor_m.getUserByName(userName), versionComment, body, sendEmail, sendEvent);
    }

    public synchronized void savePageVersion(ContentEntityObject page, final ConfluenceUser user, String versionComment, String body, boolean sendEmail, boolean sendEvent) throws InterruptedException {
        final String comment = versionComment;
        final String newBody = body;
        DefaultSaveContext.Builder builder = DefaultSaveContext.builder();
        builder.suppressEvents(!sendEvent);
        builder.suppressNotifications(!sendEmail);
        builder.updateLastModifier(true);
        DefaultSaveContext saveContext = builder.build();
        try {
            if (page instanceof Page) {
                this.pageManager_m.saveNewVersion((ContentEntityObject)((Page)page), (Modification)new Modification<Page>(){

                    public void modify(Page page) {
                        if (comment != null) {
                            page.setVersionComment(comment);
                        }
                        if (user != null) {
                            page.setLastModifier(user);
                        }
                        if (newBody != null) {
                            page.setBodyAsString(newBody);
                        }
                    }
                }, (SaveContext)saveContext);
            } else {
                this.pageManager_m.saveNewVersion((ContentEntityObject)((BlogPost)page), (Modification)new Modification<BlogPost>(){

                    public void modify(BlogPost page) {
                        if (comment != null) {
                            page.setVersionComment(comment);
                        }
                        if (user != null) {
                            page.setLastModifier(user);
                        }
                        if (newBody != null) {
                            page.setBodyAsString(newBody);
                        }
                    }
                }, (SaveContext)saveContext);
            }
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
        }
    }

    @Deprecated
    public ContentEntityObject getCeoFromMacroParam(ConversionContext conversionContext, String param) {
        Page ceo = null;
        String spaceKey = conversionContext.getSpaceKey();
        MacroDefinition macro = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        Link typedContent = (Link)macro.getTypedParameter(param, Link.class);
        PageResourceIdentifier ri = null;
        try {
            String title;
            Space space;
            BlogPostResourceIdentifier bpri;
            if (typedContent.getDestinationResourceIdentifier() instanceof PageResourceIdentifier && (ceo = this.pageManager_m.getPage((ri = (PageResourceIdentifier)typedContent.getDestinationResourceIdentifier()).getSpaceKey() != null ? ri.getSpaceKey() : spaceKey, ri.getTitle())) != null) {
                return ceo;
            }
            if (typedContent.getDestinationResourceIdentifier() instanceof BlogPostResourceIdentifier && (ceo = this.pageManager_m.getBlogPost((bpri = (BlogPostResourceIdentifier)typedContent.getDestinationResourceIdentifier()).getSpaceKey() != null ? bpri.getSpaceKey() : spaceKey, bpri.getTitle(), bpri.getPostingDay())) != null) {
                return ceo;
            }
            if (ri != null) {
                space = this.spaceManager_m.getSpace(ri.getSpaceKey() != null ? ri.getSpaceKey() : spaceKey);
                title = ri.getTitle();
                if (space != null) {
                    List blogs = this.pageManager_m.getBlogPosts(space, true);
                    for (BlogPost blog : blogs) {
                        if (!blog.getTitle().equals(title)) continue;
                        if (ceo == null) {
                            ceo = blog;
                            continue;
                        }
                        logger_m.error("Duplicate BlogPosts found: " + title);
                        return null;
                    }
                }
            } else {
                title = macro.getParameter(param);
                ceo = this.pageManager_m.getPage(spaceKey, title);
                if (ceo == null) {
                    space = this.spaceManager_m.getSpace(spaceKey);
                    List blogs = this.pageManager_m.getBlogPosts(space, true);
                    for (BlogPost blog : blogs) {
                        if (!blog.getTitle().equals(title)) continue;
                        if (ceo == null) {
                            ceo = blog;
                            continue;
                        }
                        logger_m.error("Duplicate BlogPosts found: " + title);
                        return null;
                    }
                }
            }
            if (ceo != null) {
                return ceo;
            }
            try {
                Long contentId = Long.parseLong(title);
                ceo = this.pageManager_m.getById(contentId.longValue());
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ceo;
    }

    @Nullable
    public Content getContentFromMacroParam(ConversionContext conversionContext, String param) {
        Content content = null;
        String spaceKey = conversionContext.getSpaceKey();
        MacroDefinition macro = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        Link typedContent = (Link)macro.getTypedParameter(param, Link.class);
        PageResourceIdentifier ri = null;
        try {
            PageResponse<Content> blogs;
            String title;
            BlogPostResourceIdentifier bpri;
            if (typedContent.getDestinationResourceIdentifier() instanceof PageResourceIdentifier && (content = ContentManager.getPageByTitle((ri = (PageResourceIdentifier)typedContent.getDestinationResourceIdentifier()).getSpaceKey() != null ? ri.getSpaceKey() : spaceKey, ri.getTitle())) != null) {
                return content;
            }
            if (typedContent.getDestinationResourceIdentifier() instanceof BlogPostResourceIdentifier && (content = ContentManager.getBlogPost((bpri = (BlogPostResourceIdentifier)typedContent.getDestinationResourceIdentifier()).getSpaceKey() != null ? bpri.getSpaceKey() : spaceKey, bpri.getTitle(), bpri.getPostingDay())) != null) {
                return content;
            }
            if (ri != null) {
                title = ri.getTitle();
                blogs = ContentManager.getBlogPosts(ri.getSpaceKey() != null ? ri.getSpaceKey() : spaceKey);
                for (Content blog : blogs.getResults()) {
                    if (!blog.getTitle().equals(title)) continue;
                    if (content == null) {
                        content = blog;
                        continue;
                    }
                    logger_m.error("Duplicate BlogPosts found: " + title);
                    return null;
                }
            } else {
                title = macro.getParameter(param);
                content = ContentManager.getPageByTitle(spaceKey, title);
                if (content == null) {
                    blogs = ContentManager.getBlogPosts(spaceKey);
                    for (Content blog : blogs.getResults()) {
                        if (!blog.getTitle().equals(title)) continue;
                        if (content == null) {
                            content = blog;
                            continue;
                        }
                        logger_m.error("Duplicate BlogPosts found: " + title);
                        return null;
                    }
                }
            }
            if (content != null) {
                return content;
            }
            try {
                content = ContentManager.getContentById(Long.valueOf(title));
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    public boolean updateContentProperty(Content content, String property, JSONObject newData) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.permissionManager_m.hasPermissionNoExemptions(user, Permission.EDIT, (Object)content)) {
            JsonContentProperty jcp = (JsonContentProperty)this.contentPropertyService_m.find(new Expansion[0]).withContentId(content.getId()).withPropertyKey(property).fetchOrNull();
            if (jcp != null) {
                JSONObject json = new JSONObject(jcp.getValue().getValue());
                if (!json.equals(newData)) {
                    int ver = jcp.getVersion().getNumber();
                    JsonContentProperty jproperty = JsonContentProperty.builder().content(content).key(property).value(new JsonString(newData.toString())).version(Version.builder().number(ver + 1).minorEdit(true).build()).build();
                    this.contentPropertyService_m.update(jproperty);
                }
            } else {
                JsonContentProperty jproperty = JsonContentProperty.builder().content(content).key(property).value(new JsonString(newData.toString())).build();
                this.contentPropertyService_m.create(jproperty);
            }
            return true;
        }
        return false;
    }

    public boolean removeContentProperty(ContentEntityObject ceo, String property) {
        Optional jpOpt;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.permissionManager_m.hasPermissionNoExemptions(user, Permission.EDIT, (Object)ceo) && (jpOpt = this.contentPropertyService_m.find(new Expansion[0]).withContentId(ceo.getContentId()).withPropertyKey(property).fetch()).isPresent()) {
            this.contentPropertyService_m.delete((JsonContentProperty)jpOpt.get());
            return true;
        }
        return false;
    }

    public String getContentProperty(ContentEntityObject ceo, String property) {
        Optional jpOpt = this.contentPropertyService_m.find(new Expansion[0]).withContentId(ceo.getContentId()).withPropertyKey(property).fetch();
        if (jpOpt.isPresent()) {
            JsonContentProperty jcp = (JsonContentProperty)jpOpt.get();
            return jcp.getValue().getValue();
        }
        return "{}";
    }

    public List<String> getContentPropertyKeys(ContentEntityObject ceo) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            Iterator it = this.contentPropertyService_m.find(new Expansion[0]).withContentId(ceo.getContentId()).fetchPropertyKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                results.add(key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public boolean removeContentPropertyKeys(ContentEntityObject ceo, List<String> propertyKeys) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.permissionManager_m.hasPermissionNoExemptions(user, Permission.EDIT, (Object)ceo)) {
            ContentId contentId = ceo.getContentId();
            for (String property : propertyKeys) {
                Optional jpOpt = this.contentPropertyService_m.find(new Expansion[0]).withContentId(contentId).withPropertyKey(property).fetch();
                if (!jpOpt.isPresent()) continue;
                this.contentPropertyService_m.delete((JsonContentProperty)jpOpt.get());
            }
            return true;
        }
        return false;
    }

    public String hidePageElements(boolean hideHeader, boolean hideSidebar, boolean hideFooter, boolean hideCreateButton, boolean hideBreadcrumbs, boolean hideTitle, boolean hidePageMetadata, boolean hideAllMenuButtons, boolean hideEditButton, boolean hideSaveFavourite, boolean hideWatchButton, boolean hideShareButton, boolean hideActionMenu, boolean hideLikes, boolean hideLabels, boolean hideComments) {
        StringBuilder builder = new StringBuilder();
        builder.append("<style type=\"text/css\">");
        if (hideSidebar) {
            builder.append("#main { margin-left: 0 !important; max-width: none !important; width: 100% !important} ");
            builder.append("div.ia-splitter-left, ");
        }
        if (hideAllMenuButtons) {
            builder.append("#navigation, ");
        } else {
            if (hideEditButton) {
                builder.append("#editPageLink, ");
            }
            if (hideSaveFavourite) {
                builder.append("#page-favourite, ");
            }
            if (hideWatchButton) {
                builder.append("#watch-content-button, ");
            }
            if (hideShareButton) {
                builder.append("#shareContentLink, ");
            }
            if (hideActionMenu) {
                builder.append("#action-menu-link, #action-menu, ");
            }
        }
        if (hideTitle) {
            builder.append("#title-text, ");
        }
        if (hideComments) {
            builder.append("#comments-section, ");
        }
        if (hidePageMetadata) {
            builder.append("div.page-metadata, ");
        }
        if (hideBreadcrumbs) {
            builder.append("#breadcrumb-section, #page-metadata-banner, ");
        }
        if (hideLabels) {
            builder.append("#labels-section, ");
        }
        if (hideLikes) {
            builder.append("#likes-section, ");
        }
        if (hideCreateButton) {
            builder.append("#quick-create-page-button, #create-page-button, ");
        }
        if (hideFooter) {
            builder.append("#footer, ");
        }
        if (hideHeader) {
            builder.append("#header, ");
        }
        builder.append("#page-control-hidden {display:none !important;}</style>");
        return builder.toString();
    }
}

