/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AppConfigSettings {
    private final BandanaManager bandanaManager_m;
    private BandanaContext bandanaContext_m;
    private final PluginSettingsFactory pluginSettingsFactory_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());
    private PluginSettings pluginSettings_m = null;
    private final String delimiter_m = "\u00b1";

    @Inject
    public AppConfigSettings(@ComponentImport BandanaManager bandanaManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.bandanaManager_m = bandanaManager;
        this.pluginSettingsFactory_m = pluginSettingsFactory;
    }

    public void initialise(String appStoreContext, String pluginKey) {
        this.bandanaContext_m = new ConfluenceBandanaContext(appStoreContext);
        this.pluginSettings_m = this.pluginSettingsFactory_m.createSettingsForKey(pluginKey);
    }

    public void addString(String key, String defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, (Object)defaultValue);
        String value = (String)this.bandanaManager_m.getValue(this.bandanaContext_m, key);
        if (value != null) {
            this.pluginSettings_m.put(key, (Object)value);
            this.logger_m.info("Migrating Key: {} Data: {}", (Object)key, (Object)value);
            this.bandanaManager_m.removeValue(this.bandanaContext_m, key);
        }
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)defaultValue);
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, (Object)defaultValue);
        }
    }

    public void setString(String key, String newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, (Object)newData);
        String currentData = (String)this.pluginSettings_m.get(key);
        if (currentData == null) {
            this.logger_m.error("Key not found: {} not storing new value: {}", (Object)key, (Object)newData);
        } else {
            this.pluginSettings_m.put(key, (Object)newData);
        }
    }

    @Nullable
    public String getString(String key) {
        return (String)this.pluginSettings_m.get(key);
    }

    public void addBoolean(String key, Boolean defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, (Object)defaultValue);
        Boolean value = (Boolean)this.bandanaManager_m.getValue(this.bandanaContext_m, key);
        if (value != null) {
            this.pluginSettings_m.put(key, (Object)Boolean.toString(value));
            this.logger_m.info("Migrating Key: {} Data: {}", (Object)key, (Object)value);
            this.bandanaManager_m.removeValue(this.bandanaContext_m, key);
        }
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)Boolean.toString(defaultValue));
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, (Object)defaultValue);
        }
    }

    public void setBoolean(String key, Boolean newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, (Object)newData);
        String currentData = (String)this.pluginSettings_m.get(key);
        if (currentData == null) {
            this.logger_m.error("Key not found: {} not storing new value: {}", (Object)key, (Object)newData);
        } else {
            this.pluginSettings_m.put(key, (Object)Boolean.toString(newData));
        }
    }

    public Boolean getBoolean(String key) {
        String value = (String)this.pluginSettings_m.get(key);
        if (value == null) {
            this.logger_m.error("Key not found: {}", (Object)key);
            return null;
        }
        return Boolean.valueOf(value);
    }

    public void addLong(String key, Long defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, (Object)defaultValue);
        Long value = (Long)this.bandanaManager_m.getValue(this.bandanaContext_m, key);
        if (value != null) {
            this.pluginSettings_m.put(key, (Object)Long.toString(value));
            this.logger_m.info("Migrating Key: {} Data: {}", (Object)key, (Object)value);
            this.bandanaManager_m.removeValue(this.bandanaContext_m, key);
        }
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)Long.toString(defaultValue));
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, (Object)defaultValue);
        }
    }

    public void setLong(String key, Long newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, (Object)newData);
        String currentData = (String)this.pluginSettings_m.get(key);
        if (currentData == null) {
            this.logger_m.error("Key not found: {} not storing new value: {}", (Object)key, (Object)newData);
        } else {
            this.pluginSettings_m.put(key, (Object)Long.toString(newData));
        }
    }

    @Nullable
    public Long getLong(String key) {
        String value = (String)this.pluginSettings_m.get(key);
        if (value == null) {
            this.logger_m.error("Key not found: {}", (Object)key);
            return null;
        }
        return Long.valueOf(value);
    }

    public void addInstant(String key, Instant defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, (Object)defaultValue);
        Instant value = (Instant)this.bandanaManager_m.getValue(this.bandanaContext_m, key);
        if (value != null) {
            this.pluginSettings_m.put(key, (Object)value.toString());
            this.logger_m.info("Migrating Key: {} Data: {}", (Object)key, (Object)value);
            this.bandanaManager_m.removeValue(this.bandanaContext_m, key);
        }
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)defaultValue.toString());
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, (Object)defaultValue);
        }
    }

    public void setInstant(String key, Instant newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, (Object)newData);
        String currentData = (String)this.pluginSettings_m.get(key);
        if (currentData == null) {
            this.logger_m.error("Key not found: {} not storing new value: {}", (Object)key, (Object)newData);
        } else {
            this.pluginSettings_m.put(key, (Object)newData.toString());
        }
    }

    @Nullable
    public Instant getInstant(String key) {
        String value = (String)this.pluginSettings_m.get(key);
        if (value == null) {
            this.logger_m.error("Key not found: {}", (Object)key);
            return null;
        }
        return Instant.parse(value);
    }

    public void addList(String key, List<String> defaultValue) {
        this.logger_m.info("Key: {} Default: {}", (Object)key, defaultValue);
        List value = (List)this.bandanaManager_m.getValue(this.bandanaContext_m, key);
        if (value != null) {
            this.pluginSettings_m.put(key, (Object)String.join((CharSequence)"\u00b1", value));
            this.logger_m.info("Migrating Key: {} Data: {}", (Object)key, (Object)String.join((CharSequence)"\u00b1", value));
            this.bandanaManager_m.removeValue(this.bandanaContext_m, key);
        }
        if (this.pluginSettings_m.get(key) == null) {
            this.pluginSettings_m.put(key, (Object)String.join((CharSequence)"\u00b1", defaultValue));
            this.logger_m.info("Adding Key: {} Data: {}", (Object)key, defaultValue);
        }
    }

    public void setList(String key, List<String> newData) {
        this.logger_m.info("Setting Key: {} Data: {}", (Object)key, newData);
        String currentData = (String)this.pluginSettings_m.get(key);
        if (currentData == null) {
            this.logger_m.error("Key not found: {} not storing new value: {}", (Object)key, newData);
        } else {
            this.pluginSettings_m.put(key, (Object)String.join((CharSequence)"\u00b1", newData));
        }
    }

    @Nullable
    public List<String> getList(String key) {
        String values = (String)this.pluginSettings_m.get(key);
        if (values == null) {
            this.logger_m.error("Key not found: {}", (Object)key);
            return null;
        }
        return Arrays.stream(values.split("\u00b1")).filter(value -> !value.isEmpty()).collect(Collectors.toList());
    }
}

