/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools.servlets;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.blogtools.BlogToolsConstants;
import net.kentcom.blogtools.BlogToolsMain;
import net.kentcom.blogtools.MetadataAccessor;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlogToPageServlet
extends HttpServlet {
    private final PageManager pageManager_m;
    private final TrashManager trashManager_m;
    private final BlogToolsMain blogToolsMain_m;
    private final LicenseCheck licenseCheck_m;
    private final TransactionTemplate transactionTemplate_m;
    private final MetadataAccessor metadataAccessor_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    @Inject
    public BlogToPageServlet(@ComponentImport PageManager pageManager, @ComponentImport TrashManager trashManager, @ComponentImport TransactionTemplate transactionTemplate, ConfluenceUtilities confluenceUtilities, BlogToolsMain blogToolsMain, MetadataAccessor metadataAccessor, LicenseCheck licenseCheck) {
        this.pageManager_m = pageManager;
        this.trashManager_m = trashManager;
        this.blogToolsMain_m = blogToolsMain;
        this.licenseCheck_m = licenseCheck;
        this.metadataAccessor_m = metadataAccessor;
        this.transactionTemplate_m = transactionTemplate;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    @LicensedOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger_m.info("doPost");
        if (!this.licenseCheck_m.isLicenseOK(BlogToolsConstants.pluginKey_m)) {
            response.setStatus(402);
            return;
        }
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(405);
            return;
        }
        String blogId = StringUtil.htmlEscape(request.getParameter("blogId"));
        String parentId = StringUtil.htmlEscape(request.getParameter("parentId"));
        String notifications = StringUtil.htmlEscape(request.getParameter("notifications"));
        boolean sendNotifications = notifications != null && notifications.equals("true");
        this.logger_m.info("blogId: " + blogId);
        this.logger_m.info("parentId: " + parentId);
        Boolean result = false;
        if (blogId != null) {
            Boolean finalSendNotifications = sendNotifications;
            result = (Boolean)this.transactionTemplate_m.execute(() -> {
                Page page;
                BlogPost blog = this.pageManager_m.getBlogPost(Long.parseLong(blogId));
                Page newParent = null;
                if (parentId != null && !parentId.isEmpty()) {
                    newParent = this.pageManager_m.getPage(Long.parseLong(parentId));
                }
                if (blog != null && (page = this.convertBlogToPage(blog, newParent, finalSendNotifications)) != null) {
                    this.logger_m.info("New page  " + String.valueOf(page));
                    this.pageManager_m.removeContentEntity((ContentEntityObject)blog);
                    this.trashManager_m.purge(blog.getSpaceKey(), blog.getId());
                    response.setStatus(200);
                    try {
                        response.getWriter().write(page.getUrlPath());
                        return true;
                    }
                    catch (IOException e) {
                        this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
                    }
                }
                return false;
            });
        }
        if (!result.booleanValue()) {
            this.logger_m.info("Could not find Blog - no conversion attempted");
            response.setStatus(400);
            response.getWriter().write("Invalid Blog Specified");
        }
    }

    public Page convertBlogToPage(BlogPost blog, Page newParent, Boolean sendNotifications) {
        this.logger_m.info("convertBlogToPage " + String.valueOf(blog));
        Space space = blog.getSpace();
        Page page = new Page();
        String title = blog.getTitle();
        if (newParent == null) {
            newParent = space.getHomePage();
        }
        if (this.pageManager_m.getPage(space.getKey(), title) != null) {
            page.setTitle(title + " - " + new SimpleDateFormat("dd/MM/yyyy hh:mm a").format(new Date()));
        } else {
            page.setTitle(title);
        }
        page.setSpace(space);
        page.setParentPage(newParent);
        newParent.addChild(page);
        page.setCreationDate(blog.getCreationDate());
        page.setCreator(blog.getCreator());
        page.setLastModifier(blog.getCreator());
        page.setBodyContent(blog.getBodyContent());
        this.blogToolsMain_m.copyRestrictionsByType((ContentEntityObject)blog, (ContentEntityObject)page, "View");
        this.blogToolsMain_m.copyRestrictionsByType((ContentEntityObject)blog, (ContentEntityObject)page, "Edit");
        this.blogToolsMain_m.copyWatches((ContentEntityObject)blog, (ContentEntityObject)page);
        this.blogToolsMain_m.copyLabels((Labelable)blog, (Labelable)page);
        this.blogToolsMain_m.copyComments((ContentEntityObject)blog, (ContentEntityObject)page);
        this.blogToolsMain_m.copyLikes((ContentEntityObject)blog, (ContentEntityObject)page);
        this.metadataAccessor_m.copyMetadata((ContentEntityObject)blog, (ContentEntityObject)page);
        this.blogToolsMain_m.updateIncomingLinks((ContentEntityObject)blog, (ContentEntityObject)page);
        this.blogToolsMain_m.copyAttachments((ContentEntityObject)blog, (ContentEntityObject)page);
        DefaultSaveContext.Builder builder = DefaultSaveContext.builder();
        builder.suppressEvents(true);
        builder.suppressAutowatch(true);
        builder.suppressNotifications(sendNotifications == false);
        DefaultSaveContext saveContext = builder.build();
        this.pageManager_m.saveContentEntity((ContentEntityObject)page, (SaveContext)saveContext);
        this.logger_m.info("End of convertBlogToPage");
        return page;
    }
}

