/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.inject.Inject;

public class PageToBlogPermission
implements Condition {
    private final PermissionManager permissionManager_m;

    @Inject
    public PageToBlogPermission(@ComponentImport PermissionManager permissionManager) {
        this.permissionManager_m = permissionManager;
    }

    public void init(Map<String, String> params) {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Page page = (Page)context.get("page");
        if (page.isHomePage()) {
            return false;
        }
        ConfluenceUser confluenceUser = (ConfluenceUser)context.get("user");
        boolean canEdit = this.permissionManager_m.hasPermission(confluenceUser, Permission.EDIT, (Object)page);
        boolean canRemove = this.permissionManager_m.hasPermission(confluenceUser, Permission.REMOVE, (Object)page);
        return canEdit && canRemove;
    }
}

