/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

public class MacroMigrationThread
implements Runnable {
    private String oldMacroName_m;
    private String newMacroName_m;
    private String paramExist_m;
    private NodeList macros_m;
    private List<Pair<String, String>> addParams_m;
    private List<Triplet<String, String, String>> replaceValues_m;
    private final CQLSearchService cqlSearchService_m;
    private final PageManager pageManager_m;
    private final String appName_m;
    private final ConfluenceUser user_m;
    private final TransactionTemplate transactionTemplate_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final DocumentBuilder documentBuilder_m;
    private final Transformer transformer_m;
    private final Logger logger_m = LoggerFactory.getLogger(MacroMigrationThread.class);

    public MacroMigrationThread(String oldMacroName, String newMacroName, String paramExist, List<Pair<String, String>> addParams, List<Triplet<String, String, String>> replaceValues, ConfluenceUser user, String appName, TransactionTemplate transactionTemplate, ConfluenceUtilities confluenceUtilities, PageManager pageManager, CQLSearchService cqlSearchService) {
        Transformer transformer_m1;
        DocumentBuilder documentBuilder_m1;
        this.oldMacroName_m = oldMacroName;
        this.newMacroName_m = newMacroName;
        this.paramExist_m = paramExist;
        this.addParams_m = addParams;
        this.replaceValues_m = replaceValues;
        this.user_m = user;
        this.appName_m = appName;
        this.pageManager_m = pageManager;
        this.cqlSearchService_m = cqlSearchService;
        this.transactionTemplate_m = transactionTemplate;
        this.confluenceUtilities_m = confluenceUtilities;
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            dbfactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilder_m1 = dbfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            documentBuilder_m1 = null;
        }
        this.documentBuilder_m = documentBuilder_m1;
        try {
            transformer_m1 = tfactory.newTransformer();
            transformer_m1.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerConfigurationException e) {
            transformer_m1 = null;
        }
        this.transformer_m = transformer_m1;
    }

    @Override
    public void run() {
        AuthenticatedUserThreadLocal.set((ConfluenceUser)this.user_m);
        this.logger_m.info("Renaming " + this.oldMacroName_m + " macro to " + this.newMacroName_m);
        this.logger_m.info("Running as User: " + this.user_m.getName());
        this.transactionTemplate_m.execute(new TransactionCallback(){

            public Object doInTransaction() {
                try {
                    int limit = 100;
                    int start = 0;
                    boolean finished = false;
                    while (!finished) {
                        PageResponse searchResults = MacroMigrationThread.this.cqlSearchService_m.searchContent("macro=" + MacroMigrationThread.this.oldMacroName_m, (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                        for (Content content : searchResults.getResults()) {
                            String pageName = content.getTitle();
                            ContentEntityObject ceo = MacroMigrationThread.this.pageManager_m.getById(content.getId().asLong());
                            MacroMigrationThread.this.logger_m.info("Migrating macros on page: " + pageName + " of type " + ceo.getType());
                            MacroMigrationThread.this.replaceMacroName(ceo);
                        }
                        if (searchResults.hasMore()) {
                            start += limit;
                            continue;
                        }
                        finished = true;
                    }
                }
                catch (Exception e) {
                    MacroMigrationThread.this.logger_m.error("Error renaming macro: " + e.getMessage());
                }
                return null;
            }
        });
        this.logger_m.info("Process Complete");
    }

    public boolean replaceMacroName(ContentEntityObject ceo) {
        String body = "<div>" + ceo.getBodyAsString() + "</div>";
        body = StringUtil.strtr(body, StringUtil.HTML401NamedToNumeric_m);
        try {
            InputSource is = new InputSource(new StringReader(body));
            Document doc = this.documentBuilder_m.parse(is);
            this.macros_m = doc.getElementsByTagName("ac:structured-macro");
            boolean modified = this.replaceMacros(doc);
            this.macros_m = doc.getElementsByTagName("ac:macro");
            boolean modified1 = this.replaceMacros(doc);
            if (modified || modified1) {
                StringWriter writer = new StringWriter();
                this.transformer_m.transform(new DOMSource(doc), new StreamResult(writer));
                String result = StringUtil.htmlUnescape(writer.getBuffer().toString());
                String versionComment = this.oldMacroName_m + " renamed to " + this.newMacroName_m + " by " + this.appName_m;
                this.confluenceUtilities_m.savePageVersion(ceo, this.user_m, versionComment, result, false, false);
            }
            return true;
        }
        catch (Exception e) {
            this.logger_m.error("Failed to Update macros on page: " + ceo.getDisplayTitle());
            this.logger_m.error("Due to: " + e.getMessage());
            return false;
        }
    }

    private boolean replaceMacros(Document doc) {
        boolean modified = false;
        for (int i = 0; i < this.macros_m.getLength(); ++i) {
            Node child;
            Node macro = this.macros_m.item(i);
            NamedNodeMap attribs = macro.getAttributes();
            Node name = attribs.getNamedItem("ac:name");
            if (!name.getNodeValue().equals(this.oldMacroName_m)) continue;
            this.logger_m.info("Found: " + this.oldMacroName_m);
            if (this.paramExist_m != null || this.replaceValues_m != null) {
                NodeList children = macro.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    child = children.item(j);
                    if (!child.getNodeName().equals("ac:parameter")) continue;
                    NamedNodeMap parAtts = child.getAttributes();
                    Node attr = parAtts.getNamedItem("ac:name");
                    if (this.paramExist_m == null || attr.getNodeValue().equals(this.paramExist_m)) {
                        this.logger_m.info("Renaming Macro");
                        name.setNodeValue(this.newMacroName_m);
                        modified = true;
                        if (this.replaceValues_m == null) break;
                    }
                    if (this.replaceValues_m == null) continue;
                    for (Triplet<String, String, String> entry : this.replaceValues_m) {
                        if (!attr.getNodeValue().equals(entry.getA())) continue;
                        Node node = child.getFirstChild();
                        this.logger_m.info("replacing value: " + node.getNodeValue());
                        String value = node.getNodeValue().replace((CharSequence)entry.getB(), (CharSequence)entry.getC());
                        this.logger_m.info("with: " + value);
                        node.setNodeValue(value);
                        modified = true;
                    }
                }
            } else {
                this.logger_m.info("Renaming Macro");
                name.setNodeValue(this.newMacroName_m);
                modified = true;
            }
            if (!modified || this.addParams_m == null) continue;
            for (Pair<String, String> entry : this.addParams_m) {
                this.logger_m.info("Adding Param: " + (String)entry.getA() + ", " + (String)entry.getB());
                child = doc.createElement("ac:parameter");
                child.setAttribute("ac:name", (String)entry.getA());
                Text node = doc.createTextNode((String)entry.getB());
                child.appendChild(node);
                child.setNodeValue((String)entry.getB());
                macro.appendChild(child);
            }
        }
        return modified;
    }

    public MacroMigrationThread() {
        Transformer transformer_m1;
        DocumentBuilder documentBuilder_m1;
        this.cqlSearchService_m = null;
        this.pageManager_m = null;
        this.appName_m = null;
        this.user_m = null;
        this.transactionTemplate_m = null;
        this.confluenceUtilities_m = null;
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            dbfactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilder_m1 = dbfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            documentBuilder_m1 = null;
        }
        this.documentBuilder_m = documentBuilder_m1;
        try {
            transformer_m1 = tfactory.newTransformer();
            transformer_m1.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerConfigurationException e) {
            transformer_m1 = null;
        }
        this.transformer_m = transformer_m1;
    }

    public String replaceMacroName(String content, String oldMacroName, String newMacroName, String paramExist, List<Pair<String, String>> addParams, List<Triplet<String, String, String>> replaceValues) {
        this.oldMacroName_m = oldMacroName;
        this.newMacroName_m = newMacroName;
        this.paramExist_m = paramExist;
        this.addParams_m = addParams;
        this.replaceValues_m = replaceValues;
        String result = null;
        String body = "<div>" + content + "</div>";
        body = StringUtil.strtr(body, StringUtil.HTML401NamedToNumeric_m);
        try {
            InputSource is = new InputSource(new StringReader(body));
            Document doc = this.documentBuilder_m.parse(is);
            this.macros_m = doc.getElementsByTagName("ac:structured-macro");
            boolean modified = this.replaceMacros(doc);
            this.macros_m = doc.getElementsByTagName("ac:macro");
            boolean modified1 = this.replaceMacros(doc);
            if (modified || modified1) {
                StringWriter writer = new StringWriter();
                this.transformer_m.transform(new DOMSource(doc), new StreamResult(writer));
                result = StringUtil.htmlUnescape(writer.getBuffer().toString());
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

