/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools.servlets;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.DuplicateDataRuntimeException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.blogtools.BlogToolsConstants;
import net.kentcom.blogtools.BlogToolsMain;
import net.kentcom.blogtools.MetadataAccessor;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageToBlogServlet
extends HttpServlet {
    private final PageManager pageManager_m;
    private final TrashManager trashManager_m;
    private final BlogToolsMain blogToolsMain_m;
    private final LicenseCheck licenseCheck_m;
    private final TransactionTemplate transactionTemplate_m;
    private final MetadataAccessor metadataAccessor_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private static final Logger logger_m = LoggerFactory.getLogger(PageToBlogServlet.class);

    @Inject
    public PageToBlogServlet(@ComponentImport PageManager pageManager, @ComponentImport TrashManager trashManager, @ComponentImport TransactionTemplate transactionTemplate, BlogToolsMain blogToolsMain, MetadataAccessor metadataAccessor, ConfluenceUtilities confluenceUtilities, LicenseCheck licenseCheck) {
        this.pageManager_m = pageManager;
        this.trashManager_m = trashManager;
        this.blogToolsMain_m = blogToolsMain;
        this.licenseCheck_m = licenseCheck;
        this.transactionTemplate_m = transactionTemplate;
        this.metadataAccessor_m = metadataAccessor;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    @LicensedOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger_m.info("doPost");
        if (!this.licenseCheck_m.isLicenseOK(BlogToolsConstants.pluginKey_m)) {
            response.setStatus(402);
            return;
        }
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(405);
            return;
        }
        String pageIdStr = StringUtil.htmlEscape(request.getParameter("pageId"));
        String children = StringUtil.htmlEscape(request.getParameter("children"));
        String comments = StringUtil.htmlEscape(request.getParameter("comments"));
        String restrictions = StringUtil.htmlEscape(request.getParameter("restrictions"));
        String notifications = StringUtil.htmlEscape(request.getParameter("notifications"));
        Boolean convertChildren = false;
        Boolean copyComments = true;
        Boolean keepRestrictions = true;
        Boolean sendNotifications = false;
        if (children != null && children.equals("true")) {
            convertChildren = true;
        }
        if (comments != null && comments.equals("false")) {
            copyComments = false;
        }
        if (restrictions != null && restrictions.equals("false")) {
            keepRestrictions = false;
        }
        if (notifications != null && notifications.equals("true")) {
            sendNotifications = true;
        }
        logger_m.info("pageId: " + pageIdStr + " Children: " + children + " Comments: " + comments + " Restrictions: " + restrictions);
        Boolean result = false;
        if (pageIdStr != null) {
            Long pageId = Long.parseLong(pageIdStr);
            logger_m.info("Converting Page ID: " + pageId);
            Boolean finalConvertChildren = convertChildren;
            Boolean finalCopyComments = copyComments;
            Boolean finalKeepRestrictions = keepRestrictions;
            Boolean finalSendNotifications = sendNotifications;
            result = (Boolean)this.transactionTemplate_m.execute(() -> {
                block9: {
                    Page page = (Page)this.pageManager_m.getById(pageId.longValue());
                    if (page != null) {
                        ArrayList<Page> deletePages = new ArrayList<Page>();
                        try {
                            BlogPost blog = this.convertPageToBlog(page, finalConvertChildren, finalCopyComments, finalKeepRestrictions, finalSendNotifications, deletePages);
                            if (deletePages.size() > 0) {
                                logger_m.info("Deleting total pages: " + deletePages.size());
                                for (Page pageToDelete : deletePages) {
                                    try {
                                        pageToDelete.remove(this.pageManager_m);
                                        this.trashManager_m.purge(pageToDelete.getSpaceKey(), pageToDelete.getId());
                                    }
                                    catch (Exception e) {
                                        logger_m.error(e.getMessage());
                                    }
                                }
                            }
                            if (blog == null) break block9;
                            logger_m.info("New blog  " + blog);
                            logger_m.info("Deleting Page: " + page);
                            try {
                                page.remove(this.pageManager_m);
                                this.trashManager_m.purge(page.getSpaceKey(), page.getId());
                            }
                            catch (Exception e) {
                                logger_m.error(e.getMessage());
                            }
                            response.setStatus(200);
                            response.getWriter().write(blog.getUrlPath());
                            return true;
                        }
                        catch (DuplicateDataRuntimeException | IOException e) {
                            logger_m.error(e.getMessage());
                            response.setStatus(409);
                        }
                    }
                }
                return false;
            });
        }
        if (!result.booleanValue()) {
            logger_m.info("Page not found - no conversion attempted");
            response.setStatus(400);
            response.getWriter().write("Invalid Page Specified");
        }
    }

    public BlogPost convertPageToBlog(Page page, Boolean convertChildren, Boolean copyComments, Boolean keepRestrictions, Boolean sendNotifications, List<Page> deletePages) {
        logger_m.info("convertPageToBlog");
        if (convertChildren.booleanValue()) {
            for (Page child : page.getChildren()) {
                this.convertPageToBlog(child, true, copyComments, keepRestrictions, sendNotifications, deletePages);
                deletePages.add(child);
            }
        }
        Space space = page.getSpace();
        BlogPost blog = new BlogPost();
        String title = page.getTitle();
        Date created = page.getCreationDate();
        Calendar postingDay = Calendar.getInstance();
        postingDay.setTime(created);
        if (this.pageManager_m.getBlogPost(space.getKey(), title, postingDay) != null) {
            blog.setTitle(title + " - " + new SimpleDateFormat("dd/MM/yyyy hh:mm a").format(created));
        } else {
            blog.setTitle(title);
        }
        blog.setSpace(space);
        blog.setCreationDate(created);
        blog.setCreator(page.getCreator());
        blog.setLastModifier(page.getCreator());
        String body = this.blogToolsMain_m.removeTranslateMacros(page.getBodyAsString());
        blog.setBodyAsString(body);
        this.blogToolsMain_m.copyWatches((ContentEntityObject)page, (ContentEntityObject)blog);
        if (keepRestrictions.booleanValue()) {
            this.blogToolsMain_m.copyRestrictionsByType((ContentEntityObject)page, (ContentEntityObject)blog, "View");
            this.blogToolsMain_m.copyRestrictionsByType((ContentEntityObject)page, (ContentEntityObject)blog, "Edit");
        }
        this.blogToolsMain_m.copyLabels((Labelable)page, (Labelable)blog);
        if (copyComments.booleanValue()) {
            this.blogToolsMain_m.copyComments((ContentEntityObject)page, (ContentEntityObject)blog);
        }
        this.blogToolsMain_m.copyLikes((ContentEntityObject)page, (ContentEntityObject)blog);
        this.metadataAccessor_m.copyMetadata((ContentEntityObject)page, (ContentEntityObject)blog);
        this.blogToolsMain_m.updateIncomingLinks((ContentEntityObject)page, (ContentEntityObject)blog);
        this.blogToolsMain_m.copyAttachments((ContentEntityObject)page, (ContentEntityObject)blog);
        DefaultSaveContext.Builder builder = DefaultSaveContext.builder();
        builder.suppressEvents(true);
        builder.suppressAutowatch(true);
        builder.suppressNotifications(sendNotifications == false);
        DefaultSaveContext saveContext = builder.build();
        this.pageManager_m.saveContentEntity((ContentEntityObject)blog, (SaveContext)saveContext);
        logger_m.info("End of convertPageToBlog");
        return blog;
    }

    public static String convertHexToAscii(String hex) {
        String result = "";
        logger_m.info(hex);
        try {
            int i = 0;
            while (i < hex.length()) {
                char x = hex.charAt(i);
                if (x == '%') {
                    result = result + (char)Integer.parseInt(hex.substring(i + 1, i + 3), 16);
                    i += 3;
                    continue;
                }
                result = result + x;
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
            return hex;
        }
    }
}

