/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools.servlets;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.blogtools.BlogToolsConstants;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.StringUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRestrictionsServlet
extends HttpServlet {
    private final ContentPermissionManager contentPermissionManager_m;
    private final PageManager pageManager_m;
    private final DraftManager draftManager_m;
    private final UserAccessor userAccessor_m;
    private final LicenseCheck licenseCheck_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger(PageRestrictionsServlet.class);
    private static long usageCount_m = 0L;

    @Inject
    public PageRestrictionsServlet(@ComponentImport ContentPermissionManager contentPermissionManager, @ComponentImport PageManager pageManager, @ComponentImport DraftManager draftManager, @ComponentImport UserAccessor userAccessor, ConfluenceUtilities confluenceUtilities, LicenseCheck licenseCheck) {
        this.contentPermissionManager_m = contentPermissionManager;
        this.pageManager_m = pageManager;
        this.draftManager_m = draftManager;
        this.userAccessor_m = userAccessor;
        this.licenseCheck_m = licenseCheck;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pageId = StringUtil.htmlEscape(request.getParameter("pageId"));
        String action = StringUtil.htmlEscape(request.getParameter("action"));
        boolean success = false;
        Long ceoId = Long.parseLong(pageId);
        ContentEntityObject ceo = this.pageManager_m.getById(ceoId.longValue());
        if (!this.licenseCheck_m.isLicenseOK(BlogToolsConstants.pluginKey_m)) {
            response.setStatus(402);
            return;
        }
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(405);
            return;
        }
        if (ceo == null) {
            ceo = this.draftManager_m.getDraft(ceoId.longValue());
            if (ceo == null) {
                ceo = this.pageManager_m.getBlogPost((long)Integer.parseInt(pageId));
                this.logger_m.info("Null Draft, Null Page, Blog: " + ceo);
            } else {
                this.logger_m.info("Null Page, Draft: " + ceo);
            }
        } else {
            this.logger_m.info("Page CEO: " + ceo);
        }
        if (ceo != null) {
            if (action.equalsIgnoreCase("Macro")) {
                String macro = StringUtil.htmlEscape(request.getParameter("macro"));
                this.logger_m.info("Action: " + action + " Macro: " + macro);
                success = this.ProcessMacro(ceo, macro, request.getRemoteUser());
            } else {
                String type = StringUtil.htmlEscape(request.getParameter("permissionType"));
                String restrictionType = StringUtil.htmlEscape(request.getParameter("restrictionType"));
                String restrictionName = StringUtil.htmlEscape(request.getParameter("restrictionName"));
                this.logger_m.info("Action: " + action + " Type: " + type + " PageId: " + pageId + " ResType: " + restrictionType + " resName: " + restrictionName);
                success = this.SetPermission(ceo, action, type, restrictionType, restrictionName);
            }
            DefaultSaveContext.Builder builder = DefaultSaveContext.builder();
            builder.suppressEvents(true);
            builder.suppressAutowatch(true);
            builder.suppressNotifications(true);
            this.pageManager_m.saveContentEntity(ceo, (SaveContext)builder.build());
            ++usageCount_m;
            response.setStatus(200);
            response.getWriter().write(this.DumpPermissions(ceo));
        } else {
            this.logger_m.error("Unable to find Content with ID: " + pageId);
            response.setStatus(400);
        }
    }

    public static Long getUsageCount() {
        Long temp = usageCount_m;
        usageCount_m = 0L;
        return temp;
    }

    private boolean ProcessMacro(ContentEntityObject ceo, String macro, String remoteUser) {
        boolean processViewers = false;
        if (macro == null) {
            return false;
        }
        Matcher m = BlogToolsConstants.restrictionsPattern_m.matcher(macro);
        if (m.find()) {
            if (m.group(1).equals("Viewing and editing restricted")) {
                processViewers = true;
                this.logger_m.info("Viewing and editing restricted");
            } else {
                this.logger_m.info("Editing restricted");
            }
        } else {
            return false;
        }
        this.SetPermission(ceo, "Add", "Edit", "User", remoteUser);
        m = BlogToolsConstants.userEditPattern_m.matcher(macro);
        if (m.find()) {
            this.ProcessRestrictions(ceo, "Edit", "User", m.group(1));
            if (processViewers) {
                this.ProcessRestrictions(ceo, "View", "User", m.group(1));
            }
        }
        if ((m = BlogToolsConstants.groupEditPattern_m.matcher(macro)).find()) {
            this.ProcessRestrictions(ceo, "Edit", "Group", m.group(1));
            if (processViewers) {
                this.ProcessRestrictions(ceo, "View", "Group", m.group(1));
            }
        }
        if (processViewers) {
            this.logger_m.info("processing View restrictions");
            m = BlogToolsConstants.userViewPattern_m.matcher(macro);
            if (m.find()) {
                this.ProcessRestrictions(ceo, "View", "User", m.group(1));
            }
            if ((m = BlogToolsConstants.groupViewPattern_m.matcher(macro)).find()) {
                this.ProcessRestrictions(ceo, "View", "Group", m.group(1));
            }
        }
        return true;
    }

    private boolean ProcessRestrictions(ContentEntityObject ceo, String type, String restriction, String names) {
        this.logger_m.info(names);
        String[] nameList = names.split(",");
        boolean modified = false;
        for (String name : nameList) {
            modified = this.SetPermission(ceo, "Add", type, restriction, name = name.trim()) || modified;
        }
        return modified;
    }

    private boolean SetPermission(ContentEntityObject ceo, String action, String type, String restrictionType, String restrictionName) {
        this.logger_m.info(action + " " + restrictionType + " for " + restrictionName);
        boolean modified = false;
        if (restrictionType.equalsIgnoreCase("Group")) {
            if (action.equalsIgnoreCase("Add")) {
                ContentPermission group = ContentPermission.createGroupPermission((String)type, (String)restrictionName);
                ceo.addPermission(group);
                modified = true;
                this.logger_m.info("Added group restriction " + group.toString());
            } else {
                List permissionSets = this.contentPermissionManager_m.getContentPermissionSets(ceo, type);
                block0: for (ContentPermissionSet permissionSet : permissionSets) {
                    for (ContentPermission permission : permissionSet) {
                        if (!permission.getGroupName().equalsIgnoreCase(restrictionName)) continue;
                        this.contentPermissionManager_m.removeContentPermission(permission);
                        modified = true;
                        this.logger_m.info("Removed group restriction " + permission.toString());
                        continue block0;
                    }
                }
            }
        } else if (action.equalsIgnoreCase("Add")) {
            ContentPermission user = ContentPermission.createUserPermission((String)type, (ConfluenceUser)this.userAccessor_m.getUserByName(restrictionName));
            ceo.addPermission(user);
            modified = true;
        } else {
            List permissionSets = this.contentPermissionManager_m.getContentPermissionSets(ceo, type);
            block2: for (ContentPermissionSet permissionSet : permissionSets) {
                for (ContentPermission permission : permissionSet) {
                    if (!permission.getUserSubject().getName().equalsIgnoreCase(restrictionName)) continue;
                    this.contentPermissionManager_m.removeContentPermission(permission);
                    modified = true;
                    this.logger_m.info("Removed User restriction: " + permission.toString());
                    continue block2;
                }
            }
        }
        return modified;
    }

    private String DumpPermissions(ContentEntityObject ceo) {
        String permissions = "";
        List permissionSets = this.contentPermissionManager_m.getContentPermissionSets(ceo, "View");
        for (ContentPermissionSet permissionSet : permissionSets) {
            for (ContentPermission permission : permissionSet) {
                this.logger_m.info(permission.toString());
                permissions = permissions + ", " + permission.toString();
            }
        }
        permissionSets = this.contentPermissionManager_m.getContentPermissionSets(ceo, "Edit");
        for (ContentPermissionSet permissionSet : permissionSets) {
            for (ContentPermission permission : permissionSet) {
                this.logger_m.info(permission.toString());
                permissions = permissions + ", " + permission.toString();
            }
        }
        return permissions;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String type = StringUtil.htmlEscape(request.getParameter("permissionType"));
        String pageId = StringUtil.htmlEscape(request.getParameter("pageId"));
        this.logger_m.info("Type: " + type + " PageId: " + pageId);
        Long ceoId = Long.parseLong(pageId);
        ContentEntityObject ceo = this.pageManager_m.getById(ceoId.longValue());
        if (ceo == null) {
            ceo = this.draftManager_m.getDraft(ceoId.longValue());
            if (ceo == null) {
                ceo = this.pageManager_m.getBlogPost((long)Integer.parseInt(pageId));
                this.logger_m.info("Null Draft, Null Page, Blog: " + ceo);
            } else {
                this.logger_m.info("Null Page, Draft: " + ceo);
            }
        } else {
            this.logger_m.info("Page CEO: " + ceo);
        }
        if (ceo != null) {
            List permissionSets = this.contentPermissionManager_m.getContentPermissionSets(ceo, type);
            JSONObject result = new JSONObject();
            JSONObject allRestrictions = new JSONObject();
            JSONArray userRestrictions = new JSONArray();
            JSONArray groupRestrisctions = new JSONArray();
            for (ContentPermissionSet permissionSet : permissionSets) {
                for (ContentPermission permission : permissionSet) {
                    JSONObject jsonObj = new JSONObject();
                    if (permission.isGroupPermission()) {
                        jsonObj.put("groupName", (Object)permission.getGroupName());
                        groupRestrisctions.put((Object)jsonObj);
                        continue;
                    }
                    jsonObj.put("userKey", (Object)permission.getUserSubject().getKey());
                    userRestrictions.put((Object)jsonObj);
                }
            }
            JSONObject users = new JSONObject();
            users.put("results", (Object)userRestrictions);
            users.put("size", userRestrictions.length());
            JSONObject groups = new JSONObject();
            groups.put("results", (Object)groupRestrisctions);
            groups.put("size", groupRestrisctions.length());
            allRestrictions.put("user", (Object)users);
            allRestrictions.put("group", (Object)groups);
            response.setContentType("application/json; charset=UTF-8");
            result.put("restrictions", (Object)allRestrictions);
            response.getWriter().write(result.toString());
            response.setStatus(200);
            this.logger_m.info(result.toString());
        } else {
            this.logger_m.error("Unable to find Content with ID: " + pageId);
            response.setStatus(400);
        }
    }
}

