/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebSectionModuleDescriptor;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class WebConfigSection
extends BaseConfluenceCondition {
    private final WebInterfaceManager webInterfaceManager_m;
    private final PluginAccessor pluginAccessor_m;
    private String sectionKey_m;
    private String pluginKey_m;

    @Inject
    public WebConfigSection(@ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.webInterfaceManager_m = webInterfaceManager;
        this.pluginAccessor_m = pluginAccessor;
    }

    public void init(Map<String, String> params) {
        this.sectionKey_m = params.get("section.key");
        this.pluginKey_m = params.get("plugin.key");
    }

    public boolean shouldDisplay(WebInterfaceContext context) {
        boolean result = this.addWebSection();
        return result;
    }

    private boolean addWebSection() {
        boolean result = true;
        try {
            Date thisPluginLoadDate = null;
            Plugin thisPlugin = this.pluginAccessor_m.getEnabledPlugin(this.pluginKey_m);
            if (thisPlugin != null && thisPlugin.getModuleDescriptor(this.sectionKey_m) != null) {
                thisPluginLoadDate = thisPlugin.getDateLoaded();
            }
            List webDescriptors = this.webInterfaceManager_m.getSections("system.admin");
            for (WebSectionModuleDescriptor descriptor : webDescriptors) {
                Date otherPluginLoadDate;
                if (descriptor.getPluginKey().equalsIgnoreCase(this.pluginKey_m) || !descriptor.getKey().equalsIgnoreCase(this.sectionKey_m) || !(otherPluginLoadDate = descriptor.getPlugin().getDateLoaded()).before(thisPluginLoadDate)) continue;
                result = false;
                break;
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }
}

