/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityHelper {
    private XhtmlContent xhtmlContent_m;
    private PageManager pageManager_m;
    private final Logger logger_m = LoggerFactory.getLogger(VelocityHelper.class);

    @Inject
    public VelocityHelper(@ComponentImport XhtmlContent xhtmlContent, @ComponentImport PageManager pageManager) {
        this.xhtmlContent_m = xhtmlContent;
        this.pageManager_m = pageManager;
    }

    @HtmlSafe
    public String convertStorageToView(String storage, Long pageId) {
        ContentEntityObject ceo = this.pageManager_m.getById(pageId.longValue());
        String view = "";
        try {
            this.logger_m.info(storage);
            if (ceo instanceof Page) {
                DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)((Page)ceo).toPageContext());
                view = this.xhtmlContent_m.convertStorageToView(storage, (ConversionContext)conversionContext);
            } else if (ceo instanceof BlogPost) {
                DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)((BlogPost)ceo).toPageContext());
                view = this.xhtmlContent_m.convertStorageToView(storage, (ConversionContext)conversionContext);
            }
            this.logger_m.info(view);
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
        }
        return view;
    }

    public ContentEntityObject getById(Long contentId) {
        return this.pageManager_m.getById(contentId.longValue());
    }
}

