AJS.toInit(function ()
{
    // We want to render the Dialogs from Soy templates on the page so we can show() them when needed
    // render our dialogs after the link -> should be hidden until will show() it
    AJS.$("#main").after(ConfluenceBlogTools.Templates.Soy.blog2page());
    AJS.$("#main").after(ConfluenceBlogTools.Templates.Soy.page2blog());
    AJS.$("#main").after(ConfluenceBlogTools.Templates.Soy.blogError());
    AJS.$("#main").after(ConfluenceBlogTools.Templates.Soy.duplicatePage());
    AJS.$("#main").after(ConfluenceBlogTools.Templates.Soy.confluenceReadOnly());

    function isPluginLicensed()
    {
        console.log("Checking Plugin License");
        var result;

        // check if we have a valid license
        $.ajax({
            type: "GET",
            url: AJS.params.baseUrl + "/plugins/servlet/blogTools/pluginLicense",
            success: function () {
                console.log("License OK");
                result = true;
            },
            error: function () {
                console.log("License INVALID");
                result = false;
            },
            async: false
        });
        return result;
    }

    function isReadOnlyModeEnabled()
    {
        return AJS.Meta.get('access-mode') === 'READ_ONLY';
    }

    var pluginLicensed = isPluginLicensed();

    AJS.$("#blog2page-select-page").auiSelect2(
    {
        ajax: {
            url: AJS.params.baseUrl + "/rest/api/content/search",
            dataType: "json",
            contentType: "application/json",
            type: "GET",
            quietMillis: 1000,
            data: function (params) {
                var query = "";
                if (params.length > 0) {
                    query = "type=page AND space=\"" + AJS.params.spaceKey + "\" AND title~\"" + params.trim() + "*\"";
                    console.log(AJS.params.baseUrl + "/rest/api/content/search?cql=" + query);
                }
                return {
                    cql: query
                };
            },
            results: function (data) {
                // parse the results into the format expected by Select2
                var results = [];
                if (data.size > 0) {
                    $.each(data.results, function (index, item) {
                        results.push({id: item.id, text: item.title});
                    });
                }
                return {
                    results: results
                };
            }
        },
        placeholder: AJS.I18n.getText("net.kentcom.confluence-blog-tools.space-home"),
        dropdownCssClass : "blog-tool-select-width",
        formatSearching: function ()
        {
            return AJS.I18n.getText("net.kentcom.confluence-blog-tools.start-typing");
        }
    }).on('select2-close', function () {
        setTimeout(function () {
            $(".select2-container-active").removeClass("select2-container-active");
            $(":focus").blur();
        }, 1);
    });

    // Add events to dialog trigger elements
    AJS.$("#page-to-blog-action").click(function (e)
    {
        // check if we have a valid license
        if (pluginLicensed)
        {
            if(isReadOnlyModeEnabled())
            {
                AJS.dialog2("#blog-tools-read-only").show();
            } else {
                AJS.dialog2("#page-to-blog-dialog").show();
            }
        } else {
            // show license error
            AJS.dialog2("#blog-tools-error").show();
        }
        e.preventDefault();
    });

    // Add events to dialog trigger elements
    AJS.$("#blog-to-page-action").click(function (e)
    {
        // check if we have a valid license
        if (pluginLicensed)
        {
            if(isReadOnlyModeEnabled())
            {
                AJS.dialog2("#blog-tools-read-only").show();
            } else {
                // show our dialog box
                $("#blog2page-select-page").select2("val", "");
                AJS.dialog2("#blog-to-page-dialog").show();
                $(".select2-container-active").removeClass("select2-container-active");
                $(":focus").blur();
            }
        } else {
            // show license error
            AJS.dialog2("#blog-tools-error").show();
        }
        e.preventDefault();
    });

    var reload = false;
    // Close the Error dialog
    AJS.$("#blog-error-ok").click(function (e)
    {
        AJS.dialog2("#blog-tools-error").hide();
        e.preventDefault();
        if (reload)
        {
            reload = false;
            location.href = AJS.params.baseUrl + "/collector/pages.action?key=" + AJS.params.spaceKey;
        }
    });

    // Close the Read-Only dialog
    AJS.$("#blog-tools-readonly-ok").click(function (e)
    {
        AJS.dialog2("#blog-tools-read-only").hide();
        e.preventDefault();
    });

    // Execute the Blog to Page function
    AJS.$('#blog-to-page-move').click(function (e)
    {
        // Move the page, get the parent page
        var parentPageId = $("#blog2page-select-page").select2("val");
        var notifications = $("#b2p-notifications").is(":checked");
        console.log("ParentId: " + parentPageId);

        e.preventDefault();
        AJS.$(".aui-dialog2-content").spin();

        $.post(AJS.params.baseUrl + "/plugins/servlet/blogTools/blogToPage",
        {
            blogId: AJS.params.pageId,
            parentId: parentPageId,
            notifications: notifications,
            atl_token  : AJS.Meta.get("atl-token")
        }).success(function (data, statusText, xhr) {
            AJS.$(".aui-dialog2-content").spinStop();
            AJS.dialog2("#blog-to-page-dialog").hide();

            if (xhr.status === 200) {
                location.href = AJS.params.baseUrl + data;
            }
        }).error(function (xhr, statusText) {
            AJS.$(".aui-dialog2-content").spinStop();
            AJS.dialog2("#blog-to-page-dialog").hide();

            if (xhr.status === 405) {
                AJS.dialog2("#blog-tools-read-only").show();
            }
        });
    });

    // Hides the dialog
    AJS.$("#blog-to-page-cancel").click(function (e)
    {
        e.preventDefault();
        AJS.dialog2("#blog-to-page-dialog").hide();
    });

    // Execute the Page to Blog function

    // get value of children checkbox
    AJS.$("#p2b-children").click(function (e)
    {
        console.log("checkbox changed: item:" + $(this).attr("value") + " val:" + $(this).is(":checked"));
        if ($(this).is(":checked")) {
            AJS.$("#p2b-children-text").text(AJS.I18n.getText("net.kentcom.confluence-blog-tools.children-blogged"));
        } else {
            AJS.$("#p2b-children-text").text(AJS.I18n.getText("net.kentcom.confluence-blog-tools.orphaned"));
        }
    });

    function convertPageToBlog(pageId, children, comments, restrictions, notifications)
    {
        $.post(AJS.params.baseUrl + "/plugins/servlet/blogTools/pageToBlog",
        {
            pageId:     pageId,
            children:   children,
            comments:   comments,
            restrictions: restrictions,
            notifications: notifications,
            atl_token  : AJS.Meta.get("atl-token")
        }).success(function (data, statusText, xhr) {
            AJS.$(".aui-dialog2-content").spinStop();
            AJS.dialog2("#page-to-blog-dialog").hide();

            if (xhr.status === 200) {
                location.href = AJS.params.baseUrl + data;
            }
        }).error(function (xhr, statusText) {
            AJS.$(".aui-dialog2-content").spinStop();
            AJS.dialog2("#page-to-blog-dialog").hide();

            if (xhr.status === 409) {
              AJS.dialog2("#blog-tools-duplicate").show();
            } else if (xhr.status === 405) {
                AJS.dialog2("#blog-tools-read-only").show();
            }
        });
    }

    AJS.$("#blog-duplicate-ok").click(function (e)
    {
        AJS.dialog2("#blog-tools-duplicate").hide();
        e.preventDefault();
    });

    AJS.$("#page-to-blog-yes").click(function (e)
    {
        e.preventDefault();
        AJS.$(".aui-dialog2-content").spin();
        var convertChildren = $("#p2b-children").is(":checked");
        var copyComments = $("#p2b-comments").is(":checked");
        var keepRestrictions = $("#p2b-restrictions").is(":checked");
        var notifications = $("#p2b-notifications").is(":checked");
        convertPageToBlog(AJS.params.pageId, convertChildren, copyComments, keepRestrictions, notifications);
    });

    // Hides the dialog
    AJS.$("#page-to-blog-cancel").click(function (e)
    {
        e.preventDefault();
        AJS.dialog2("#page-to-blog-dialog").hide();
    });

    //
    // Code to replace the CreatePageFromTemplate listener
    //
    // check if this page (on load) has my page-to-blog macro. This is as good as detecting page created from template with my macro :)

    function isPageDraft()
    {
        var draftId = AJS.Meta.get("draft-id");
        var type = AJS.Meta.get("content-type");
        //console.log("draftId: " + draftId + " type: " + type);
        return draftId > 0 && type == "page";
    }

    function createBlog()
    {
        if(!saveDraft())
        {
            console.log("Save failed - aborting");
            return false;
        }

        var draftId   = AJS.Meta.get("draft-id");
        var spaceKey  = AJS.Meta.get("space-key");
        var pageTitle = document.getElementById("content-title").value;

        $.post(AJS.params.baseUrl + "/plugins/servlet/blogTools/createBlog",
        {
            draftId:    draftId,
            spaceKey:   spaceKey,
            pageTitle:  pageTitle,
            atl_token  : AJS.Meta.get("atl-token")
        }).success(function (data) {
            console.log("createBlog result - SUCCESS");
            stopHeartbeat();
            deleteDraft();
            $(window).unbind();
            location.href = AJS.params.baseUrl + data;
        }).error(function (xhr) {
            console.log("createBlog result - ERROR");
            console.log(xhr);
            var message = "";
            if(xhr.status === 402) {
                // should not get this, as we check calling
                console.log("License Error");
                message = AJS.I18n.getText("net.kentcom.confluence-blog-tools.invalid.license");
            } else if (xhr.status === 420) {
                console.log("Missing Title");
                message = AJS.I18n.getText("net.kentcom.confluence-blog-tools.missing-title");
            } else if (xhr.status === 421) {
                console.log("Duplicate Title");
                message = AJS.I18n.getText("net.kentcom.confluence-blog-tools.duplicate-title");
            } else if (xhr.status === 405) {
                 AJS.dialog2("#blog-tools-read-only").show();
                 return;
            } else {
                console.log("Something went wrong (" + xhr.status + ")");
                message = AJS.I18n.getText("net.kentcom.confluence-blog-tools.internal-error", xhr.status);
            }
            AJS.messages.error('#blog-flag-container',
            {
                title: AJS.I18n.getText("net.kentcom.confluence-blog-tools.plugin-name"),
                body: message,
                closeable: true,
                fadeout: true,
                delay  : 5000
            });
        });
    }

    //
    // This prevents the pop to resume editing draft
    //
    function stopHeartbeat()
    {
        var data = {
            dataType: "json",
            contentId: AJS.Meta.get("content-id"),
            draftType: AJS.Meta.get("draft-type")
        };

        AJS.safe.post(AJS.params.baseUrl + "/json/stopheartbeatactivity.action", data, function ()
        {
            AJS.log("Stop heartbeat activity on", data.draftType, "id", data.contentId);
        }).always(function () {
        });
    }

    function deleteDraft()
    {
        var draftId   = AJS.Meta.get("draft-id");
        var spaceKey  = AJS.Meta.get("space-key");

        console.log("Deleting Draft: " + draftId);

        var result;
        $.ajax({
           url: AJS.params.baseUrl + "/rest/tinymce/1/drafts/discard",
           type: 'DELETE',
           contentType: "application/json",
           async : false,
           dataType: "json",
           data:  JSON.stringify(
           {
    	        draftId:    draftId,
	            pageId:     "0",
	            type:       "page",
	            spaceKey:   spaceKey,
           }),
           success: function(response)
           {
               console.log("Discard Draft - Success");
               console.log(response);
               result = true;
           },
           error: function()
           {
                console.log("Discard Draft - Error");
                result = false;
           }
        });
        return result;
    }

    function saveDraft()
    {
        var draftId   = AJS.Meta.get("draft-id");
        var spaceKey  = AJS.Meta.get("space-key");
        var pageTitle = document.getElementById("content-title").value;

        console.log("Saving Draft: " + draftId);

        var result;
        $.ajax({
           url: AJS.params.baseUrl + "/rest/tinymce/1/drafts",
           type: 'POST',
           contentType: "application/json",
           async : false,
           dataType: "json",
           data:  JSON.stringify(
           {
    	        draftId:    draftId,
	            pageId:     "0",
	            type:       "page",
	            title:      pageTitle,
	            spaceKey:   spaceKey,
	            content:    tinyMCE.get('wysiwygTextarea').getContent(),
           }),
           success: function(response)
           {
               console.log("Save Draft - Success");
               console.log(response);
               result = true;
           },
           error: function()
           {
                console.log("Save Draft - Error");
                result = false;
           }
        });
        return result;
    }

    function handlePublishButton(event)
    {
        console.log("Now converting to Blog, checking License");
        // check if we have a valid license
        if (pluginLicensed)
        {
            if(isReadOnlyModeEnabled())
            {
                AJS.dialog2("#blog-tools-read-only").show();
            } else {
                console.log("License OK, now converting");
                createBlog();
            }
        } else {
            // show license error
            AJS.dialog2("#blog-tools-error").show();
            reload = true;
        }
        event.preventDefault();
        return false;
    }

    function handleKeyDown(e)
    {
        if(e.ctrlKey && e.keyCode == 'S'.charCodeAt(0))
        {
            // CTRL-S was pressed outside the editor
            e.preventDefault();
            handlePublishButton(e);
            return false;
        }
        return true;
    }

    function handlePageToBlogMacro()
    {
        console.log("Converting this Page to BLOGPOST");

        // this handle Ctrl+S press when focus is outside the editor
        document.onkeydown = function(e)
        {
            return handleKeyDown(e);
        };

        // remove the confluence Save button and replace with Publish Blog button
        $("#rte-button-publish").after("<button id=\"rte-button-publish\" class=\"aui-button aui-button-primary\" tabindex=\"101\" >Publish Blog</button>");
        var publish = document.getElementById("rte-button-publish");
        publish.parentNode.removeChild(publish);
        $("#rte-button-publish").on("click", handlePublishButton);
    }

    function handlePageRestrictionsMacro()
    {
        console.log("Handle Page Restrictions Macro");

        $(tinymce.activeEditor.dom.select('.editor-inline-macro')).each(function(index)
        {
            console.log(index);
            //console.log($(this));
            if($(this).attr("data-macro-name") == "page-restrictions")
            {
                console.log("This is mine");
                var params = $(this).attr("data-macro-parameters");
                var macro  = $(this);

                console.log(params);
                var draftId   = AJS.Meta.get("draft-id");

                // send off permissions request
                $.post(AJS.params.baseUrl + "/plugins/servlet/blogTools/pageRestrictions",
                {
                    pageId:   draftId,
                    action:   "Macro",
                    macro:    params,
                    atl_token  : AJS.Meta.get("atl-token")
                }).success(function (data) {
                    console.log("Page Restrictions - SUCCESS");
                    // on success delete macro
                    macro.remove();
                }).error(function (xhr) {
                    console.log("Page Restrictions - ERROR");

                    if (xhr.status === 405)
                    {
                        AJS.dialog2("#blog-tools-read-only").show();
                    }
                    // leave macro on page, when it renders it can show errors
                });
            }
        });
    }

    function handleRestrictedTemplateMacro()
    {
        console.log("Restricted Template Macro");

        $(tinymce.activeEditor.dom.select('.editor-inline-macro')).each(function(index)
        {
            if($(this).attr("data-macro-name") == "restricted-template")
            {
                var params = $(this).attr("data-macro-parameters");
                var macro  = $(this);

                // check if this user has permissions to create this page
                $.post(AJS.params.baseUrl + "/plugins/servlet/blogTools/restrictedTemplate",
                {
                    restrictions: params,
                    atl_token  : AJS.Meta.get("atl-token")
                }).success(function (data) {
                    console.log("Restricted Template - ALLOWED");
                    // on success remove the macro
                    macro.remove();
                    saveDraft();
                }).error(function (xhr) {
                    console.log("Restricted Template - DENIED");
                    // Shut down the editor
                    AJS.messages.error('#blog-flag-container',
                    {
                        title: AJS.I18n.getText("net.kentcom.confluence-blog-tools.plugin-name"),
                        message: AJS.I18n.getText("net.kentcom.confluence-blog-tools.template.restricted"),
                        closeable: true,
                        fadeout: true,
                        delay  : 5000
                    });

                    // clear the editor
                    tinymce.activeEditor.setContent("");
                    saveDraft();
                    // close the editor
                    $("#rte-button-cancel").click();
                });
            }
        });
    }

    if (typeof document.forms["createpageform"] !== "undefined")
    {
        console.log("Create Form");

        // check if this is a page template
        if (document.getElementById("sourceTemplateId") || isPageDraft())
        {
            console.log("Page Template or Page Draft");

            AJS.$("#page").after("<div id=\"blog-flag-container\"/>");

            // OK someone has used the "Create Page from Template" page button. Check if my macro is on the page...
            var text = $('textarea#wysiwygTextarea').val();
            var pageRestrictions = text.search("data-macro-name=\"page-restrictions\"");
            var blogMacro = text.search("data-macro-name=\"page-to-blog-macro\"");
            var restrictedTemplate = text.search("data-macro-name=\"restricted-template\"");

            // bind to some of the tinymce events
            //tinymce.on('init setcontent postprocess nodechange dirty', function(){
            //    console.log("TINYMCE Event");
            //});

            if(restrictedTemplate > 0)
            {
                setTimeout(handleRestrictedTemplateMacro, 2000);
                return;
            }
            if(pageRestrictions > 0)
            {
                // have to set time, cause waiting for tinymce to load just doesn't work
                // the inner dom is never loaded. Use timer does work
               setTimeout(handlePageRestrictionsMacro, 2000);
            }
            if(blogMacro > 0)
            {
                // need a timer as the tinymce editor changes the Publish button
                // so I have to wait until it is finished, then I replace it with mine
                setTimeout(handlePageToBlogMacro, 2000);
            }
        }
    }
});
