/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools;

import com.atlassian.confluence.core.ContentEntityObject;
import com.communardo.confluence.metadata.DataObject;
import com.communardo.confluence.metadata.MetadataField;
import com.communardo.confluence.metadata.MetadataSet;
import com.communardo.confluence.metadata.service.MetadataManager;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.osgi.context.BundleContextAware;

@Named
public class MetadataAccessor
implements BundleContextAware,
DisposableBean {
    private ServiceTracker serviceTracker_m = null;
    private final String serviceName_m = "com.communardo.confluence.metadata.service.MetadataManager";
    private final Logger logger_m = LoggerFactory.getLogger(MetadataAccessor.class);
    private static long usageCount_m = 0L;

    @Inject
    public MetadataAccessor() {
    }

    public void copyMetadata(ContentEntityObject source, ContentEntityObject destination) {
        block7: {
            try {
                MetadataManager metadataManager = (MetadataManager)this.serviceTracker_m.getService();
                if (metadataManager != null) {
                    try {
                        this.logger_m.info("Manager loaded OK");
                        ++usageCount_m;
                        List sets = metadataManager.loadContentMetadataSets(source);
                        for (MetadataSet metadataset : sets) {
                            metadataManager.saveContentMetadataSet(destination, metadataset);
                            List metadataFields = metadataset.getMetadataFields();
                            for (MetadataField metadataField : metadataFields) {
                                DataObject dataObject = metadataManager.loadContentMetadataValue(source, metadataField);
                                metadataManager.saveContentMetadataValue(destination, metadataField, dataObject);
                            }
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        this.logger_m.error(e.getMessage());
                        break block7;
                    }
                }
                this.logger_m.info("Could not get a valid MetadataManager.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Long getUsageCount() {
        Long temp = usageCount_m;
        usageCount_m = 0L;
        return temp;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.serviceTracker_m = new ServiceTracker(bundleContext, "com.communardo.confluence.metadata.service.MetadataManager", null);
        this.serviceTracker_m.open();
    }

    public void destroy() throws Exception {
        this.serviceTracker_m.close();
    }
}

