/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.Modification;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.blogtools.BlogToPageServlet;
import net.kentcom.blogtools.BlogToolsConstants;
import net.kentcom.blogtools.CreateBlogServlet;
import net.kentcom.blogtools.MetadataAccessor;
import net.kentcom.blogtools.PageRestrictionsServlet;
import net.kentcom.blogtools.PageToBlogServlet;
import net.kentcom.blogtools.RestrictedTemplateServlet;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.UsageAnalytics;
import net.kentcom.common.scheduler.SchedulerJobManager;
import net.kentcom.common.scheduler.SchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class BlogToolsMain
implements InitializingBean,
DisposableBean,
SchedulerJobManager {
    private final AttachmentManager attachmentManager_m;
    private final LabelManager labelManager_m;
    private final LikeManager likeManager_m;
    private final PageManager pageManager_m;
    private final UserManager userManager_m;
    private final ContentPermissionManager contentPermissionManager_m;
    private final UserAccessor userAccessor_m;
    private final LinkManager linkManager_m;
    private final NotificationManager notificationManager_m;
    private final I18nResolver i18nResolver_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final SchedulerManager schedulerManager_m;
    private final UsageAnalytics usageAnalytics_m;
    private final Logger logger_m = LoggerFactory.getLogger(BlogToolsMain.class);

    @Inject
    public BlogToolsMain(@ComponentImport AttachmentManager attachmentManager, @ComponentImport LabelManager labelManager, @ComponentImport PageManager pageManager, @ComponentImport LikeManager likeManager, @ComponentImport UserManager userManager, @ComponentImport ContentPermissionManager contentPermissionManager, @ComponentImport LinkManager linkManager, @ComponentImport UserAccessor userAccessor, @ComponentImport I18nResolver i18nResolver, @ComponentImport NotificationManager notificationManager, SchedulerManager schedulerManager, UsageAnalytics usageAnalytics, ConfluenceUtilities confluenceUtilities) {
        this.attachmentManager_m = attachmentManager;
        this.labelManager_m = labelManager;
        this.pageManager_m = pageManager;
        this.likeManager_m = likeManager;
        this.userManager_m = userManager;
        this.contentPermissionManager_m = contentPermissionManager;
        this.userAccessor_m = userAccessor;
        this.linkManager_m = linkManager;
        this.notificationManager_m = notificationManager;
        this.i18nResolver_m = i18nResolver;
        this.schedulerManager_m = schedulerManager;
        this.confluenceUtilities_m = confluenceUtilities;
        this.usageAnalytics_m = usageAnalytics;
    }

    public void afterPropertiesSet() throws Exception {
        ConfluenceUtilities.enableLogging();
        this.schedulerManager_m.initialise(this, "net.kentcom.confluence-blog-tools");
        this.sendAnalytics();
    }

    public void destroy() throws Exception {
        this.schedulerManager_m.destroy();
    }

    public void copyLabels(Labelable source, Labelable destination) {
        this.logger_m.info("entered");
        for (Label label : source.getLabels()) {
            this.labelManager_m.addLabel(destination, label);
        }
    }

    public void copyLikes(ContentEntityObject source, ContentEntityObject destination) {
        this.logger_m.info("entered, number of likes: " + this.likeManager_m.countLikes((Searchable)source));
        List likes = this.likeManager_m.getLikes(source);
        for (Like like : likes) {
            try {
                User user = this.userManager_m.getUser(like.getUsername());
                this.logger_m.info("adding like: " + like.toString() + " user: " + user.getName());
                this.likeManager_m.addLike(destination, user);
            }
            catch (EntityException e) {
                this.logger_m.error(e.getMessage());
            }
        }
    }

    public void copyComments(ContentEntityObject source, ContentEntityObject destination) {
        this.logger_m.info("entered");
        List comments = source.getComments();
        Iterator it = comments.iterator();
        while (it.hasNext()) {
            Comment comment;
            Comment copy = comment = (Comment)it.next();
            copy.setContainer(destination);
            this.copyLikes((ContentEntityObject)comment, (ContentEntityObject)copy);
            it.remove();
        }
    }

    public void copyAttachments(ContentEntityObject source, ContentEntityObject destination) {
        this.logger_m.info("entered");
        List attachments = this.attachmentManager_m.getLatestVersionsOfAttachments(source);
        for (Attachment attachment : attachments) {
            this.logger_m.info("found attachment:" + attachment.getDisplayTitle());
            this.attachmentManager_m.moveAttachment(attachment, attachment.getFileName(), destination);
        }
    }

    public void copyRestrictionsByType(ContentEntityObject source, ContentEntityObject destination, String type) {
        this.logger_m.info("entered");
        List permissionSets = this.contentPermissionManager_m.getContentPermissionSets(source, type);
        for (ContentPermissionSet permissionSet : permissionSets) {
            for (String groupName : permissionSet.getGroupNames()) {
                ContentPermission group = ContentPermission.createGroupPermission((String)type, (String)groupName);
                destination.addPermission(group);
            }
            for (UserKey userKey : permissionSet.getUserKeys()) {
                ContentPermission user = ContentPermission.createUserPermission((String)type, (ConfluenceUser)this.userAccessor_m.getUserByKey(userKey));
                destination.addPermission(user);
            }
        }
    }

    public void copyWatches(ContentEntityObject source, ContentEntityObject destination) {
        this.logger_m.info("entered");
        List notifications = this.notificationManager_m.getNotificationsByContent(source);
        for (Notification notification : notifications) {
            this.notificationManager_m.addContentNotification((User)notification.getReceiver(), destination);
        }
    }

    public void updateIncomingLinks(ContentEntityObject from, ContentEntityObject to) {
        this.logger_m.info("entered");
        if (from.isDraft()) {
            return;
        }
        final ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        List incomingLinks = this.linkManager_m.getIncomingLinksToContent(from);
        ArrayList<ContentEntityObject> updatees = new ArrayList<ContentEntityObject>();
        for (OutgoingLink outgoingLink : incomingLinks) {
            ContentEntityObject ceo = outgoingLink.getSourceContent();
            if (ceo.isDraft() || updatees.contains(ceo) || ceo.getLatestVersionId() == from.getLatestVersionId()) continue;
            updatees.add(outgoingLink.getSourceContent());
        }
        for (ContentEntityObject ceo : updatees) {
            final String body = this.confluenceUtilities_m.updateOutgoingLinks(ceo, from, to);
            final String blogToolComment = this.i18nResolver_m.getText("net.kentcom.confluence-blog-tools.updated-links") + BlogToolsConstants.pluginName_m;
            if (ceo instanceof BlogPost) {
                this.logger_m.info("Saving Blog version: " + ceo.getTitle());
                this.pageManager_m.saveNewVersion((ContentEntityObject)((BlogPost)ceo), (Modification)new Modification<BlogPost>(){

                    public void modify(BlogPost blog) {
                        blog.setVersionComment(blogToolComment);
                        blog.setLastModifier(user);
                        blog.setBodyAsString(body);
                    }
                });
                continue;
            }
            if (ceo instanceof Page) {
                this.logger_m.info("Saving Page version: " + ceo.getTitle());
                this.pageManager_m.saveNewVersion((ContentEntityObject)((Page)ceo), (Modification)new Modification<Page>(){

                    public void modify(Page page) {
                        page.setVersionComment(blogToolComment);
                        page.setLastModifier(user);
                        page.setBodyAsString(body);
                    }
                });
                continue;
            }
            if (!(ceo instanceof Comment)) continue;
            this.logger_m.info("Saving Comment version: " + ceo.getTitle());
            this.pageManager_m.saveNewVersion((ContentEntityObject)((Comment)ceo), (Modification)new Modification<Comment>(){

                public void modify(Comment comment) {
                    comment.setVersionComment(blogToolComment);
                    comment.setLastModifier(user);
                    comment.setBodyAsString(body);
                }
            });
        }
    }

    private void sendAnalytics() {
        this.usageAnalytics_m.sendPluginInfo();
        this.usageAnalytics_m.sendMacroUsage("page-to-blog-macro", null);
        this.usageAnalytics_m.sendMacroUsage("page-restrictions", null);
        this.usageAnalytics_m.sendMacroUsage("restricted-template", null);
        this.usageAnalytics_m.sendEventMetrics("BlogToPage-Tool", BlogToPageServlet.getUsageCount());
        this.usageAnalytics_m.sendEventMetrics("PageToBlog-Tool", PageToBlogServlet.getUsageCount());
        this.usageAnalytics_m.sendEventMetrics("PageRestrictionsTemplate-Usage", PageRestrictionsServlet.getUsageCount());
        this.usageAnalytics_m.sendEventMetrics("RestrictedTemplate-Usage", RestrictedTemplateServlet.getUsageCount());
        this.usageAnalytics_m.sendEventMetrics("PageToBlogTemplate-Usage", CreateBlogServlet.getUsageCount());
        this.usageAnalytics_m.sendEventMetrics("Metadata-Usage", MetadataAccessor.getUsageCount());
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(10, 24);
        this.schedulerManager_m.schedule(Schedule.runOnce((Date)tomorrow.getTime()), null);
    }

    @Override
    public void processSchedulerJob(JobRunnerRequest request) {
        this.sendAnalytics();
    }
}

