/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.config.Schedule;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.kentcom.common.scheduler.SchedulerJobManager;
import net.kentcom.common.scheduler.SchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentCache
implements SchedulerJobManager {
    private final BandanaManager bandanaManager_m;
    private final SchedulerManager schedulerManager_m;
    private Cache<String, Object> cache_m = null;
    private Integer expireAfterAccess_m = 1;
    private Object defaultValue_m = null;
    private BandanaContext bandanaContext_m = null;
    private final Logger logger_m = LoggerFactory.getLogger(PersistentCache.class);

    public PersistentCache(CacheManager cacheManager, BandanaManager bandanaManager, SchedulerManager schedulerManager, String cacheName, Integer expireAfterAccess, Object defaultValue, boolean isDataCenter) {
        this.bandanaManager_m = bandanaManager;
        this.schedulerManager_m = schedulerManager;
        this.expireAfterAccess_m = expireAfterAccess;
        this.defaultValue_m = defaultValue;
        this.bandanaContext_m = new ConfluenceBandanaContext(cacheName);
        this.cache_m = isDataCenter ? cacheManager.getCache(cacheName, (CacheLoader)new thisCacheLoader(), new CacheSettingsBuilder().flushable().remote().replicateViaCopy().expireAfterAccess(1L, TimeUnit.DAYS).expireAfterWrite(1L, TimeUnit.DAYS).build()) : cacheManager.getCache(cacheName, (CacheLoader)new thisCacheLoader(), new CacheSettingsBuilder().flushable().local().expireAfterAccess(1L, TimeUnit.DAYS).expireAfterWrite(1L, TimeUnit.DAYS).build());
        this.schedulerManager_m.initialise(this, cacheName);
        this.scheduleNextJob();
    }

    private void scheduleNextJob() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        this.schedulerManager_m.schedule(Schedule.runOnce((Date)calendar.getTime()), null);
    }

    @Override
    public void processSchedulerJob(JobRunnerRequest request) {
        this.cleanOutCache();
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
                this.scheduleNextJob();
            }
            catch (Exception e) {
                this.logger_m.error(e.getMessage());
            }
        }).start();
    }

    private void cleanOutCache() {
        Calendar now = Calendar.getInstance();
        long minCacheAgeMs = now.getTimeInMillis() - 86400000L * (long)this.expireAfterAccess_m.intValue();
        for (String key : this.bandanaManager_m.getKeys(this.bandanaContext_m)) {
            String value = (String)this.bandanaManager_m.getValue(this.bandanaContext_m, key);
            if (value == null) continue;
            this.logger_m.info("Found Key: " + key + " Value: " + value);
            JSONObject json = new JSONObject(value);
            if (json.getLong("timestamp") >= minCacheAgeMs) continue;
            this.logger_m.info("Removing: " + value);
            this.bandanaManager_m.removeValue(this.bandanaContext_m, key);
        }
    }

    public void put(String key, Object value) {
        this.cache_m.put((Object)key, value);
        JSONObject json = new JSONObject();
        json.put("timestamp", Calendar.getInstance().getTimeInMillis());
        json.put("data", value);
        this.bandanaManager_m.setValue(this.bandanaContext_m, key, (Object)json.toString());
    }

    public Object get(String key) {
        this.logger_m.info("Cache Key: " + key);
        this.logger_m.info("Exists in cache: " + this.containsKey(key));
        this.logger_m.info("Exists in bandana: " + this.containsPersistentKey(key));
        return this.cache_m.get((Object)key);
    }

    public void remove(String key) {
        this.cache_m.remove((Object)key);
        this.bandanaManager_m.removeValue(this.bandanaContext_m, key);
    }

    public Iterable<String> getKeys() {
        return this.cache_m.getKeys();
    }

    public Iterable<String> getPersistentKeys() {
        return this.bandanaManager_m.getKeys(this.bandanaContext_m);
    }

    public boolean containsKey(String key) {
        return this.cache_m.containsKey((Object)key);
    }

    public boolean containsPersistentKey(String key) {
        return this.bandanaManager_m.getValue(this.bandanaContext_m, key) != null;
    }

    private class thisCacheLoader
    implements CacheLoader<String, Object> {
        private thisCacheLoader() {
        }

        @Nonnull
        public Object load(@Nonnull String key) {
            String value = (String)PersistentCache.this.bandanaManager_m.getValue(PersistentCache.this.bandanaContext_m, key);
            PersistentCache.this.logger_m.info("Bandana value: " + value);
            if (value != null) {
                JSONObject json = new JSONObject(value);
                json.put("timestamp", Calendar.getInstance().getTimeInMillis());
                PersistentCache.this.bandanaManager_m.setValue(PersistentCache.this.bandanaContext_m, key, (Object)json.toString());
                PersistentCache.this.logger_m.info("Found data: " + json.get("data"));
                return json.get("data");
            }
            PersistentCache.this.logger_m.info("Not found, returning: " + PersistentCache.this.defaultValue_m);
            return PersistentCache.this.defaultValue_m;
        }
    }
}

