/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionReplacer;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.blogtools.BlogConstants;
import net.kentcom.blogtools.MetadataAccessor;
import net.kentcom.blogtools.PageToBlogListener;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBlogServlet
extends HttpServlet {
    private final PageManager pageManager_m;
    private final DraftManager draftManager_m;
    private final TrashManager trashManager_m;
    private final SpaceManager spaceManager_m;
    private final XhtmlContent xhtmlContent_m;
    private final TransactionTemplate transactionTemplate_m;
    private final PageToBlogListener pageToBlogListener_m;
    private final LicenseCheck licenseCheck_m;
    private final MetadataAccessor metadataAccessor_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger(CreateBlogServlet.class);

    @Inject
    public CreateBlogServlet(@ComponentImport PageManager pageManager, @ComponentImport DraftManager draftManager, @ComponentImport TrashManager trashManager, @ComponentImport SpaceManager spaceManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport TransactionTemplate transactionTemplate, ConfluenceUtilities confluenceUtilities, PageToBlogListener pageToBlogListener, MetadataAccessor metadataAccessor, LicenseCheck licenseCheck) {
        this.pageManager_m = pageManager;
        this.draftManager_m = draftManager;
        this.trashManager_m = trashManager;
        this.spaceManager_m = spaceManager;
        this.xhtmlContent_m = xhtmlContent;
        this.pageToBlogListener_m = pageToBlogListener;
        this.licenseCheck_m = licenseCheck;
        this.metadataAccessor_m = metadataAccessor;
        this.transactionTemplate_m = transactionTemplate;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger_m.info("doPost");
        if (!this.licenseCheck_m.isLicenseOK(BlogConstants.pluginKey_m)) {
            response.setStatus(403);
            return;
        }
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(405);
            return;
        }
        String pageTitle = request.getParameter("pageTitle");
        String draftIdStr = StringUtil.htmlEscape(request.getParameter("draftId"));
        String spaceKey = StringUtil.htmlEscape(request.getParameter("spaceKey"));
        GregorianCalendar today = new GregorianCalendar();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        this.logger_m.info("pageTitle: " + pageTitle + " SpaceKey: " + spaceKey + " DraftId: " + draftIdStr);
        if (pageTitle == null || pageTitle.isEmpty()) {
            this.logger_m.info("Missing Page Title");
            response.setStatus(420);
            return;
        }
        if (this.pageManager_m.getBlogPost(spaceKey, pageTitle, (Calendar)today) != null) {
            this.logger_m.info("Duplicate Page Title");
            response.setStatus(421);
            return;
        }
        Space space = this.spaceManager_m.getSpace(spaceKey);
        if (space == null) {
            this.logger_m.info("Invalid Space");
            response.setStatus(422);
            return;
        }
        try {
            long draftId = Long.parseLong(draftIdStr);
            boolean sourceIsPage = true;
            Page source = this.pageManager_m.getPage(draftId);
            if (source != null) {
                this.logger_m.info("From Page");
                this.logger_m.info(source.getBodyAsString());
            }
            if (source == null) {
                source = this.draftManager_m.getDraft(draftId);
                if (source == null) {
                    for (Draft draft : this.draftManager_m.findDraftsForUser((User)user)) {
                        this.logger_m.info("Draft ID:     " + draft.getIdAsString());
                        this.logger_m.info("============");
                        if (!draft.getIdAsString().equals(draftIdStr)) continue;
                        source = draft;
                        break;
                    }
                }
                if (source != null) {
                    sourceIsPage = false;
                    this.logger_m.info("From Draft");
                    this.logger_m.info(source.getBodyAsString());
                }
            }
            Boolean result = false;
            if (source != null) {
                Page finalSource = source;
                boolean finalSourceIsPage = sourceIsPage;
                this.transactionTemplate_m.execute(() -> this.lambda$doPost$0(space, pageTitle, user, (ContentEntityObject)finalSource, response, finalSourceIsPage));
            } else {
                this.logger_m.info("Unable to find source");
                response.setStatus(426);
            }
        }
        catch (NumberFormatException e) {
            this.logger_m.info("Invalid Draft ID");
            response.setStatus(423);
        }
        catch (IllegalStateException e) {
            this.logger_m.info("Unable to purge Draft");
            response.setStatus(424);
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
            this.logger_m.info("Another error");
            response.setStatus(400);
        }
    }

    private BlogPost createBlog(Space space, String pageTitle, ConfluenceUser user, ContentEntityObject draft) {
        this.logger_m.info("createBlog");
        BlogPost blog = new BlogPost();
        blog.setSpace(space);
        blog.setTitle(pageTitle);
        blog.setCreationDate(draft.getCreationDate());
        blog.setCreator(user);
        blog.setBodyContent(draft.getBodyContent());
        blog.setLastModifier(user);
        this.removeMacroFromPage((ContentEntityObject)blog);
        this.pageToBlogListener_m.copyRestrictionsByType(draft, (ContentEntityObject)blog, "View");
        this.pageToBlogListener_m.copyRestrictionsByType(draft, (ContentEntityObject)blog, "Edit");
        this.pageToBlogListener_m.copyLabels((Labelable)draft, (Labelable)blog);
        this.metadataAccessor_m.copyMetadata(draft, (ContentEntityObject)blog);
        this.pageToBlogListener_m.copyAttachments(draft, (ContentEntityObject)blog);
        DefaultSaveContext.Builder builder = DefaultSaveContext.builder();
        builder.suppressEvents(false);
        builder.suppressAutowatch(false);
        builder.suppressNotifications(false);
        DefaultSaveContext saveContext = builder.build();
        this.pageManager_m.saveContentEntity((ContentEntityObject)blog, (SaveContext)saveContext);
        this.logger_m.info("End of createBlog");
        return blog;
    }

    private void removeMacroFromPage(ContentEntityObject ceo) {
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)ceo.toPageContext());
        try {
            ceo.setBodyAsString(this.xhtmlContent_m.replaceMacroDefinitionsWithString(ceo.getBodyAsString(), (ConversionContext)context, new MacroDefinitionReplacer((ConversionContext)context){
                final /* synthetic */ ConversionContext val$context;
                {
                    this.val$context = conversionContext;
                }

                public String replace(MacroDefinition macroDefinition) throws XhtmlException {
                    if ("page-to-blog-macro".equals(macroDefinition.getName())) {
                        return "";
                    }
                    return CreateBlogServlet.this.xhtmlContent_m.convertMacroDefinitionToStorage(macroDefinition, this.val$context);
                }
            }));
        }
        catch (XhtmlException e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ Object lambda$doPost$0(Space space, String pageTitle, ConfluenceUser user, ContentEntityObject finalSource, HttpServletResponse response, boolean finalSourceIsPage) {
        BlogPost blog = this.createBlog(space, pageTitle, user, finalSource);
        if (blog == null) {
            this.logger_m.info("Unable to create Blog");
            response.setStatus(425);
            return null;
        }
        if (finalSourceIsPage) {
            this.logger_m.info("Deleting Original page");
            Page page = (Page)finalSource;
            page.remove(this.pageManager_m);
            this.trashManager_m.purge(page.getSpaceKey(), page.getId());
            this.logger_m.info("Original page removed");
        }
        response.setStatus(200);
        try {
            response.getWriter().write(blog.getUrlPath());
        }
        catch (IOException e) {
            this.logger_m.error(e.getMessage());
        }
        return null;
    }
}

