/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.tuple.Pair;

public class CalendarUtil {
    public static Calendar timeNow() {
        return Calendar.getInstance();
    }

    public static Calendar setTimeToStartOfDay(Calendar time, String timezone) {
        time.set(11, 0);
        time.set(12, 0);
        time.set(13, 0);
        time.set(14, 0);
        if (timezone != null) {
            time.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        return time;
    }

    public static Calendar setTimeToEndOfDay(Calendar time, String timezone) {
        time.set(11, 23);
        time.set(12, 59);
        time.set(13, 59);
        time.set(14, 999);
        if (timezone != null) {
            time.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        return time;
    }

    public static Calendar setTimeToStartOfMonth(Calendar time, String timezone) {
        time.set(5, time.getActualMinimum(5));
        CalendarUtil.setTimeToStartOfDay(time, timezone);
        return time;
    }

    public static Calendar setTimeToEndOfMonth(Calendar time, String timezone) {
        time.set(5, time.getActualMaximum(5));
        CalendarUtil.setTimeToEndOfDay(time, timezone);
        return time;
    }

    public static Pair<Date, Date> getDateRange(int startMonth, int startYear, int endMonth, int endYear, String timezone) {
        Calendar beginning = Calendar.getInstance();
        beginning.set(1, startYear);
        beginning.set(2, startMonth);
        beginning = CalendarUtil.setTimeToStartOfMonth(beginning, timezone);
        Calendar end = Calendar.getInstance();
        end.set(1, endYear);
        end.set(2, endMonth);
        end = CalendarUtil.setTimeToEndOfMonth(end, timezone);
        return Pair.of((Object)beginning.getTime(), (Object)end.getTime());
    }
}

