/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common.scheduler;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.kentcom.common.scheduler.SchedulerJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SchedulerManager
implements JobRunner {
    private final Logger logger_m = LoggerFactory.getLogger(SchedulerManager.class);
    private final SchedulerService schedulerService_m;
    private SchedulerJobManager jobManager_m = null;
    private JobRunnerKey jobRunnerKey_m;

    @Inject
    public SchedulerManager(@ComponentImport I18nResolver i18nResolver, @ComponentImport SchedulerService scheduler) {
        this.schedulerService_m = scheduler;
    }

    public void initialise(SchedulerJobManager jobManager, String pluginKey) {
        this.jobRunnerKey_m = JobRunnerKey.of((String)pluginKey);
        this.logger_m.info("Creating JobRunnerKey: " + this.jobRunnerKey_m);
        this.schedulerService_m.registerJobRunner(this.jobRunnerKey_m, (JobRunner)this);
        this.jobManager_m = jobManager;
    }

    public Optional<JobId> schedule(Schedule schedule, @Nullable String jobName) {
        return this.schedule(schedule, jobName, Collections.emptyMap());
    }

    public Optional<JobId> schedule(Schedule schedule, @Nullable String jobName, @Nonnull Map<String, Serializable> parameters) {
        this.logger_m.info("Scheduling job: " + jobName + " schedule: " + schedule);
        try {
            return Optional.of(this.internalSchedule(schedule, jobName, parameters));
        }
        catch (Exception e) {
            this.logger_m.error("Exception when scheduling the new job");
            this.logger_m.error(e.toString());
            return Optional.empty();
        }
    }

    private JobId internalSchedule(Schedule schedule, @Nullable String jobName, @Nonnull Map<String, Serializable> parameters) throws SchedulerServiceException {
        JobId jobId = JobId.of((String)(this.jobRunnerKey_m + ":" + (jobName == null ? UUID.randomUUID() : jobName)));
        this.schedulerService_m.scheduleJob(jobId, JobConfig.forJobRunnerKey((JobRunnerKey)this.jobRunnerKey_m).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(schedule).withParameters(parameters));
        this.logger_m.info("Job scheduled: " + jobId + " for interval: " + schedule.toString());
        return jobId;
    }

    public boolean isJobScheduled(JobId jobId) {
        JobDetails jobDetails = this.schedulerService_m.getJobDetails(jobId);
        return jobDetails != null;
    }

    public boolean cancel(JobId jobId) {
        this.logger_m.info("Cancel job: " + jobId);
        JobDetails details = this.schedulerService_m.getJobDetails(jobId);
        if (details != null) {
            this.schedulerService_m.unscheduleJob(jobId);
            return true;
        }
        this.logger_m.info("Job not found, nothing to cancel: " + jobId);
        return false;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        this.logger_m.info("Job executing: " + request.getJobId());
        try {
            this.jobManager_m.processSchedulerJob(request);
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            this.logger_m.error("Job execution failed, due to:");
            this.logger_m.error(e.toString());
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    public void dump() {
        List allJobs = this.schedulerService_m.getJobsByJobRunnerKey(this.jobRunnerKey_m).stream().map(JobDetails::getJobId).collect(Collectors.toList());
        this.logger_m.info("Dumping all known scheduled jobs:");
        for (JobId jobId : allJobs) {
            JobDetails details = this.schedulerService_m.getJobDetails(jobId);
            this.logger_m.info(details.getSchedule().toString());
        }
    }

    public void cancelAllScheduledJobs() {
        try {
            List allJobs = this.schedulerService_m.getJobsByJobRunnerKey(this.jobRunnerKey_m).stream().map(JobDetails::getJobId).collect(Collectors.toList());
            for (JobId jobId : allJobs) {
                this.schedulerService_m.unscheduleJob(jobId);
            }
        }
        catch (Exception e) {
            this.logger_m.error("Exception while unregistering jobs", (Throwable)e);
        }
    }

    public void destroy() {
        this.logger_m.info("Plugin Shutdown");
        try {
            if (this.jobManager_m != null) {
                this.cancelAllScheduledJobs();
                this.schedulerService_m.unregisterJobRunner(this.jobRunnerKey_m);
            }
        }
        catch (RuntimeException e) {
            this.logger_m.error("Exception when shutting down ");
            this.logger_m.error(e.toString());
        }
    }
}

