/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger_m = LoggerFactory.getLogger(FileUtils.class);

    public static String zipFiles(String outputFile, String ... inputFiles) {
        String string;
        List<String> srcFiles = Arrays.asList(inputFiles);
        String zipFileName = outputFile;
        FileOutputStream fos = new FileOutputStream(zipFileName);
        try {
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            for (String srcFile : srcFiles) {
                File fileToZip = new File(srcFile);
                try (FileInputStream fis = new FileInputStream(fileToZip);){
                    int length;
                    ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                    zipOut.putNextEntry(zipEntry);
                    byte[] bytes = new byte[1024];
                    while ((length = fis.read(bytes)) >= 0) {
                        zipOut.write(bytes, 0, length);
                    }
                }
                catch (Exception e) {
                    logger_m.error(e.toString());
                }
            }
            zipOut.close();
            string = zipFileName;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger_m.error(e.toString());
                return null;
            }
        }
        fos.close();
        return string;
    }
}

