/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.ConfluenceUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class LicenseCheck {
    public final PluginLicenseManager pluginLicenseManager_m;
    public final PluginAccessor pluginAccessor_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger(LicenseCheck.class);
    private Long jarFileTime_m = 0L;
    private LocalDate lastLogTime_m = null;
    private int gracePeriodDays_m = 2;

    @Inject
    public LicenseCheck(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginAccessor pluginAccessor, ConfluenceUtilities confluenceUtilities) {
        this.pluginLicenseManager_m = pluginLicenseManager;
        this.pluginAccessor_m = pluginAccessor;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    public String getPluginVersion() {
        return LicenseCheck.class.getPackage().getImplementationVersion();
    }

    public String getPluginVersion(String pluginKey) {
        return this.pluginAccessor_m.getPlugin(pluginKey).getPluginInformation().getVersion();
    }

    public Plugin getPlugin(String pluginKey) {
        return this.pluginAccessor_m.getPlugin(pluginKey);
    }

    private void logLicenseError(String message) {
        LocalDate now = LocalDate.now();
        if (this.lastLogTime_m == null || this.lastLogTime_m.isBefore(now.minusDays(1L))) {
            this.lastLogTime_m = now;
            this.logger_m.error(message);
        }
    }

    public boolean isLicenseOK(String pluginKey) {
        boolean licenseValid = false;
        boolean trialValid = false;
        Plugin plugin = this.getPlugin(pluginKey);
        String pluginName = plugin.getName();
        String pluginVersion = plugin.getPluginInformation().getVersion();
        this.logger_m.info("Confluence Version: {} Plugin Version: {}", (Object)GeneralUtil.getVersionNumber(), (Object)pluginVersion);
        Map params = plugin.getPluginInformation().getParameters();
        boolean paidApp = ((String)params.get("atlassian-licensing-enabled")).equalsIgnoreCase("true");
        if (!paidApp) {
            return true;
        }
        try {
            if (this.pluginLicenseManager_m.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.pluginLicenseManager_m.getLicense().get();
                if (license.getError().isDefined()) {
                    LicenseError error = (LicenseError)license.getError().get();
                    this.logger_m.error(error.toString());
                    switch (error.name()) {
                        case "EXPIRED": {
                            this.logLicenseError("Invalid license: Your license of \"" + pluginName + "\" has expired. Please use the 'Buy' button to purchase or renew this license.");
                            break;
                        }
                        case "USER_MISMATCH": {
                            this.logLicenseError("Invalid license: Your \"" + pluginName + "\" plugin license User Limit is lower than your Confluence license User Limit. Please upgrade your \"" + pluginName + "\" license.");
                            break;
                        }
                        case "VERSION_MISMATCH": {
                            this.logLicenseError("Invalid license: Your license for maintenance of \"" + pluginName + "\" is not valid for this Confluence version. Please use the 'Renew' button to renew your license.");
                            break;
                        }
                        case "TYPE_MISMATCH": {
                            this.logLicenseError("Invalid license: Your \"" + pluginName + "\" license does not match the license type on this Confluence installation. Please purchase the correct license.");
                            break;
                        }
                        default: {
                            this.logLicenseError("Invalid license: \"" + pluginName + "\" Unknown license error.");
                            break;
                        }
                    }
                } else {
                    licenseValid = true;
                }
            } else {
                this.logLicenseError(pluginName + ": Plugin is unlicensed, there is no license installed for this plugin");
            }
            if (!licenseValid) {
                Calendar timeNow = Calendar.getInstance();
                Calendar gracePeriod = Calendar.getInstance();
                gracePeriod.setTimeInMillis(this.getJarFileTime(LicenseCheck.class));
                gracePeriod.add(5, this.gracePeriodDays_m);
                boolean bl = trialValid = timeNow.compareTo(gracePeriod) < 0;
                if (trialValid) {
                    this.logger_m.info(pluginName + ": Trial License is Active");
                }
            }
        }
        catch (Exception e) {
            this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
            return false;
        }
        return licenseValid || trialValid;
    }

    private Long getJarFileTime(Class<?> cl) {
        if (this.jarFileTime_m == 0L) {
            try {
                String url = cl.getProtectionDomain().getCodeSource().getLocation().getPath();
                url = URLDecoder.decode(url, "UTF-8");
                String path = url.replace("file:", "");
                JarFile jf = new JarFile(path);
                ZipEntry manifest = jf.getEntry("META-INF/MANIFEST.MF");
                this.jarFileTime_m = manifest.getTime();
                jf.close();
            }
            catch (Exception e) {
                this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
            }
        }
        return this.jarFileTime_m;
    }
}

