/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import net.kentcom.blogtools.BlogConstants;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.StringUtil;

public class RestrictedTemplateMacro
implements Macro {
    private final UserAccessor userAccessor_m;
    private final I18nResolver i18nResolver_m;
    private final LicenseCheck licenseCheck_m;
    private final ConfluenceUtilities confluenceUtilities_m;

    @Inject
    RestrictedTemplateMacro(@ComponentImport UserAccessor userAccessor, @ComponentImport I18nResolver i18nResolver, LicenseCheck licenseCheck, ConfluenceUtilities confluenceUtilities) {
        this.userAccessor_m = userAccessor;
        this.i18nResolver_m = i18nResolver;
        this.licenseCheck_m = licenseCheck;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.licenseCheck_m.isLicenseOK(BlogConstants.pluginName_m)) {
            return this.confluenceUtilities_m.warningMessage(BlogConstants.pluginName_m, this.i18nResolver_m.getText("net.kentcom.confluence-blog-tools.invalid.license"), conversionContext);
        }
        PageContext pc = conversionContext.getPageContext();
        if (pc.getOutputType().equalsIgnoreCase("preview")) {
            String userEdit = StringUtil.htmlEscape(parameters.get("UserEdit"));
            String groupEdit = StringUtil.htmlEscape(parameters.get("GroupEdit"));
            return this.TestRestrictions(userEdit, groupEdit);
        }
        return "";
    }

    private String TestRestrictions(String userEdit, String groupEdit) {
        String[] names;
        StringBuilder result = new StringBuilder();
        boolean isEmpty = true;
        ArrayList<String> usersWhoCanEdit = new ArrayList<String>();
        ArrayList<String> groupsWhoCanEdit = new ArrayList<String>();
        if (userEdit != null && !userEdit.isEmpty()) {
            isEmpty = false;
            for (String name : names = userEdit.split(",")) {
                if (this.isValidUserName(name = name.trim())) {
                    usersWhoCanEdit.add(name);
                    continue;
                }
                result.append("<p>");
                result.append(this.i18nResolver_m.getText("net.kentcom.confluence-blog-tools.invalid.username", new Serializable[]{name}));
                result.append("</p>");
            }
        }
        if (groupEdit != null && !groupEdit.isEmpty()) {
            isEmpty = false;
            for (String name : names = groupEdit.split(",")) {
                if (this.isValidGroupName(name = name.trim())) {
                    groupsWhoCanEdit.add(name);
                    continue;
                }
                result.append("<p>");
                result.append(this.i18nResolver_m.getText("net.kentcom.confluence-blog-tools.invalid.groupname", new Serializable[]{name}));
                result.append("</p>");
            }
        }
        if (isEmpty) {
            return this.i18nResolver_m.getText("net.kentcom.confluence-blog-tools.no-restrictions");
        }
        if (result.length() == 0) {
            if (!usersWhoCanEdit.isEmpty()) {
                result.append("<p>");
                result.append(this.i18nResolver_m.getText("net.kentcom.confluence-blog-tools.users-can-create"));
                result.append("</p><p>");
                result.append(usersWhoCanEdit.toString());
                result.append("</p>");
            }
            if (!groupsWhoCanEdit.isEmpty()) {
                result.append("<p>");
                result.append(this.i18nResolver_m.getText("net.kentcom.confluence-blog-tools.groups-can-create"));
                result.append("</p><p>");
                result.append(groupsWhoCanEdit.toString());
                result.append("</p>");
            }
        }
        return result.toString();
    }

    private boolean isValidUserName(String userName) {
        return this.userAccessor_m.getUserByName(userName) != null;
    }

    private boolean isValidGroupName(String groupName) {
        return this.userAccessor_m.getGroup(groupName) != null;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

