/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.blogtools;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.blogtools.BlogConstants;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedTemplateServlet
extends HttpServlet {
    private final UserAccessor userAccessor_m;
    private final LicenseCheck licenseCheck_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger(RestrictedTemplateServlet.class);

    @Inject
    public RestrictedTemplateServlet(@ComponentImport UserAccessor userAccessor, ConfluenceUtilities confluenceUtilities, LicenseCheck licenseCheck) {
        this.userAccessor_m = userAccessor;
        this.licenseCheck_m = licenseCheck;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String restrictions = StringUtil.htmlEscape(request.getParameter("restrictions"));
        String remoteUser = request.getRemoteUser();
        if (!this.licenseCheck_m.isLicenseOK(BlogConstants.pluginName_m)) {
            response.setStatus(403);
            return;
        }
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(405);
            return;
        }
        if (remoteUser == null || remoteUser.isEmpty()) {
            response.setStatus(401);
            this.logger_m.info("Anonymous user - Unauthorised");
            return;
        }
        if (restrictions != null && !restrictions.isEmpty()) {
            this.logger_m.info(restrictions);
            Matcher m = BlogConstants.userEditPattern_m.matcher(restrictions);
            if (m.find()) {
                this.logger_m.info("matched User regex");
                if (this.ProcessUserRestrictions(remoteUser, m.group(1))) {
                    response.setStatus(200);
                    this.logger_m.info("User in UserEdit - Authorised");
                    return;
                }
            }
            if ((m = BlogConstants.groupEditPattern_m.matcher(restrictions)).find()) {
                this.logger_m.info("matched Group regex");
                if (this.ProcessGroupRestrictions(remoteUser, m.group(1))) {
                    response.setStatus(200);
                    this.logger_m.info("User in GroupEdit - Authorised");
                    return;
                }
            }
            response.setStatus(401);
            this.logger_m.info("User did not match - Unauthorised");
        } else {
            response.setStatus(200);
            this.logger_m.info("No restrictions - Authorised");
        }
    }

    private boolean ProcessUserRestrictions(String user, String names) {
        String[] nameList;
        this.logger_m.info(names);
        for (String name : nameList = names.split(",")) {
            if (!(name = name.trim()).equals(user)) continue;
            return true;
        }
        return false;
    }

    private boolean ProcessGroupRestrictions(String user, String names) {
        this.logger_m.info(names);
        String[] nameList = names.split(",");
        List groups = this.userAccessor_m.getGroupNamesForUserName(user);
        for (String name : nameList) {
            if (!groups.contains(name = name.trim())) continue;
            return true;
        }
        return false;
    }
}

