/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.sonarsource.scanner.maven.bootstrap.JavaVersionResolver;
import org.sonarsource.scanner.maven.bootstrap.MavenUtils;

public class MavenProjectConverter {
    private final Log log;
    private static final char SEPARATOR = ',';
    private static final String UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE = "Unable to determine structure of project. Probably you use Maven Advanced Reactor Options with a broken tree of modules.";
    private static final String MODULE_KEY = "sonar.moduleKey";
    private static final String PROPERTY_PROJECT_BUILDDIR = "sonar.projectBuildDir";
    private static final String JAVA_SOURCE_PROPERTY = "sonar.java.source";
    private static final String JAVA_TARGET_PROPERTY = "sonar.java.target";
    private static final String LINKS_HOME_PAGE = "sonar.links.homepage";
    private static final String LINKS_CI = "sonar.links.ci";
    private static final String LINKS_ISSUE_TRACKER = "sonar.links.issue";
    private static final String LINKS_SOURCES = "sonar.links.scm";
    private static final String LINKS_SOURCES_DEV = "sonar.links.scm_dev";
    private static final String MAVEN_PACKAGING_POM = "pom";
    private static final String MAVEN_PACKAGING_WAR = "war";
    public static final String ARTIFACTID_MAVEN_WAR_PLUGIN = "maven-war-plugin";
    public static final String ARTIFACTID_MAVEN_SUREFIRE_PLUGIN = "maven-surefire-plugin";
    public static final String ARTIFACTID_FINDBUGS_MAVEN_PLUGIN = "findbugs-maven-plugin";
    public static final String FINDBUGS_EXCLUDE_FILTERS = "sonar.findbugs.excludeFilters";
    private static final String JAVA_PROJECT_MAIN_BINARY_DIRS = "sonar.java.binaries";
    private static final String JAVA_PROJECT_MAIN_LIBRARIES = "sonar.java.libraries";
    private static final String GROOVY_PROJECT_MAIN_BINARY_DIRS = "sonar.groovy.binaries";
    private static final String JAVA_PROJECT_TEST_BINARY_DIRS = "sonar.java.test.binaries";
    private static final String JAVA_PROJECT_TEST_LIBRARIES = "sonar.java.test.libraries";
    private static final String SUREFIRE_REPORTS_PATH_DEPRECATED_PROPERTY = "sonar.junit.reportsPath";
    private static final String SUREFIRE_REPORTS_PATH_PROPERTY = "sonar.junit.reportPaths";
    private static final String PROJECT_BINARY_DIRS = "sonar.binaries";
    private static final String PROJECT_LIBRARIES = "sonar.libraries";
    private Properties userProperties;
    private final Properties envProperties;
    private final JavaVersionResolver javaVersionResolver;

    public MavenProjectConverter(Log log, JavaVersionResolver javaVersionResolver, Properties envProperties) {
        this.log = log;
        this.javaVersionResolver = javaVersionResolver;
        this.envProperties = envProperties;
    }

    public Map<String, String> configure(List<MavenProject> mavenProjects, MavenProject root, Properties userProperties) throws MojoExecutionException {
        this.userProperties = userProperties;
        LinkedHashMap<MavenProject, Map<String, String>> propsByModule = new LinkedHashMap<MavenProject, Map<String, String>>();
        try {
            this.configureModules(mavenProjects, propsByModule);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sonar.projectKey", MavenProjectConverter.getSonarKey(root));
            Path topLevelDir = MavenProjectConverter.rebuildModuleHierarchy(props, propsByModule, root, "");
            props.put("sonar.projectBaseDir", topLevelDir.toString());
            if (!propsByModule.isEmpty()) {
                throw new IllegalStateException("Unable to determine structure of project. Probably you use Maven Advanced Reactor Options with a broken tree of modules. \"" + ((MavenProject)propsByModule.keySet().iterator().next()).getName() + "\" is orphan");
            }
            return props;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot configure project", e);
        }
    }

    private static Path rebuildModuleHierarchy(Map<String, String> properties, Map<MavenProject, Map<String, String>> propsByModule, MavenProject current, String prefix) throws IOException {
        Map<String, String> currentProps = propsByModule.get(current);
        if (currentProps == null) {
            throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
        }
        for (Map.Entry<String, String> prop : currentProps.entrySet()) {
            properties.put(prefix + prop.getKey(), prop.getValue());
        }
        propsByModule.remove(current);
        Path topLevelDir = current.getBasedir().toPath().toAbsolutePath();
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (String modulePathStr : current.getModules()) {
            File modulePath = new File(current.getBasedir(), modulePathStr);
            MavenProject module = MavenProjectConverter.findMavenProject(modulePath, propsByModule.keySet());
            if (module == null) continue;
            String moduleId = module.getGroupId() + ":" + module.getArtifactId();
            Path topLevelModuleDir = MavenProjectConverter.rebuildModuleHierarchy(properties, propsByModule, module, prefix + moduleId + ".");
            moduleIds.add(moduleId);
            if (topLevelModuleDir.startsWith(topLevelDir)) continue;
            topLevelDir = MavenProjectConverter.findCommonParentDir(topLevelDir, topLevelModuleDir);
        }
        if (!moduleIds.isEmpty()) {
            properties.put(prefix + "sonar.modules", StringUtils.join(moduleIds, ','));
        }
        return topLevelDir;
    }

    static Path findCommonParentDir(Path dir1, Path dir2) {
        if (dir1.startsWith(dir2)) {
            return dir2;
        }
        if (dir2.startsWith(dir1)) {
            return dir1;
        }
        for (Path candidate = dir1.getParent(); candidate != null; candidate = candidate.getParent()) {
            if (!dir2.startsWith(candidate)) continue;
            return candidate;
        }
        throw new IllegalStateException("Unable to find a common parent between two modules baseDir: '" + dir1 + "' and '" + dir2 + "'");
    }

    private void configureModules(List<MavenProject> mavenProjects, Map<MavenProject, Map<String, String>> propsByModule) throws MojoExecutionException {
        for (MavenProject pom : mavenProjects) {
            boolean skipped = "true".equals(pom.getModel().getProperties().getProperty("sonar.skip"));
            if (skipped) {
                this.log.info((CharSequence)("Module " + pom + " skipped by property 'sonar.skip'"));
                continue;
            }
            propsByModule.put(pom, this.computeSonarQubeProperties(pom));
        }
    }

    private static MavenProject findMavenProject(File modulePath, Collection<MavenProject> modules) throws IOException {
        File canonical = modulePath.getCanonicalFile();
        if (canonical.isDirectory()) {
            File pom = new File(canonical, "pom.xml");
            for (MavenProject module : modules) {
                if (!module.getFile().getCanonicalFile().equals(pom)) continue;
                return module;
            }
            for (MavenProject module : modules) {
                if (!module.getBasedir().equals(canonical)) continue;
                return module;
            }
        } else {
            for (MavenProject module : modules) {
                if (!module.getFile().getCanonicalFile().equals(canonical)) continue;
                return module;
            }
        }
        return null;
    }

    Map<String, String> computeSonarQubeProperties(MavenProject pom) throws MojoExecutionException {
        HashMap<String, String> props = new HashMap<String, String>();
        MavenProjectConverter.defineProjectKey(pom, props);
        props.put("sonar.projectVersion", pom.getVersion());
        props.put("sonar.projectName", pom.getName());
        String description = pom.getDescription();
        if (description != null) {
            props.put("sonar.projectDescription", description);
        }
        this.guessJavaVersion(pom, props);
        MavenProjectConverter.guessEncoding(pom, props);
        MavenProjectConverter.convertMavenLinksToProperties(props, pom);
        this.synchronizeFileSystemAndOtherProps(pom, props);
        MavenProjectConverter.findBugsExcludeFileMaven(pom, props);
        return props;
    }

    private static void defineProjectKey(MavenProject pom, Map<String, String> props) {
        String key = pom.getModel().getProperties().containsKey("sonar.projectKey") ? pom.getModel().getProperties().getProperty("sonar.projectKey") : MavenProjectConverter.getSonarKey(pom);
        props.put(MODULE_KEY, key);
    }

    private static String getSonarKey(MavenProject pom) {
        return pom.getGroupId() + ":" + pom.getArtifactId();
    }

    private static void guessEncoding(MavenProject pom, Map<String, String> props) {
        String encoding = MavenUtils.getSourceEncoding(pom);
        if (encoding != null) {
            props.put("sonar.sourceEncoding", encoding);
        }
    }

    private void guessJavaVersion(MavenProject pom, Map<String, String> props) {
        String version = this.javaVersionResolver.getSource(pom);
        if (version != null) {
            props.put(JAVA_SOURCE_PROPERTY, version);
        }
        if ((version = this.javaVersionResolver.getTarget(pom)) != null) {
            props.put(JAVA_TARGET_PROPERTY, version);
        }
    }

    private static void findBugsExcludeFileMaven(MavenProject pom, Map<String, String> props) {
        String excludeFilterFile = MavenUtils.getPluginSetting(pom, "org.codehaus.mojo", ARTIFACTID_FINDBUGS_MAVEN_PLUGIN, "excludeFilterFile", null);
        File path = MavenProjectConverter.resolvePath(excludeFilterFile, pom.getBasedir());
        if (path != null && path.exists()) {
            props.put(FINDBUGS_EXCLUDE_FILTERS, path.getAbsolutePath());
        }
    }

    private static void convertMavenLinksToProperties(Map<String, String> props, MavenProject pom) {
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_HOME_PAGE, pom.getUrl());
        Scm scm = pom.getScm();
        if (scm == null) {
            scm = new Scm();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_SOURCES, scm.getUrl());
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_SOURCES_DEV, scm.getDeveloperConnection());
        CiManagement ci = pom.getCiManagement();
        if (ci == null) {
            ci = new CiManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_CI, ci.getUrl());
        IssueManagement issues = pom.getIssueManagement();
        if (issues == null) {
            issues = new IssueManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_ISSUE_TRACKER, issues.getUrl());
    }

    private static void setPropertyIfNotAlreadyExists(Map<String, String> props, String propertyKey, String propertyValue) {
        if (StringUtils.isBlank(props.get(propertyKey))) {
            props.put(propertyKey, StringUtils.defaultString(propertyValue));
        }
    }

    private void synchronizeFileSystemAndOtherProps(MavenProject pom, Map<String, String> props) throws MojoExecutionException {
        props.put("sonar.projectBaseDir", pom.getBasedir().getAbsolutePath());
        File buildDir = MavenProjectConverter.getBuildDir(pom);
        if (buildDir != null) {
            props.put(PROPERTY_PROJECT_BUILDDIR, buildDir.getAbsolutePath());
            props.put("sonar.working.directory", MavenProjectConverter.getSonarWorkDir(pom).getAbsolutePath());
        }
        MavenProjectConverter.populateBinaries(pom, props);
        MavenProjectConverter.populateLibraries(pom, props, false);
        MavenProjectConverter.populateLibraries(pom, props, true);
        MavenProjectConverter.populateSurefireReportsPath(pom, props);
        for (String k : pom.getModel().getProperties().stringPropertyNames()) {
            props.put(k, pom.getModel().getProperties().getProperty(k));
        }
        MavenUtils.putAll(this.envProperties, props);
        MavenUtils.putAll(this.userProperties, props);
        List<File> mainDirs = this.mainSources(pom);
        props.put("sonar.sources", StringUtils.join((Object[])MavenProjectConverter.toPaths(mainDirs), ','));
        List<File> testDirs = this.testSources(pom);
        if (!testDirs.isEmpty()) {
            props.put("sonar.tests", StringUtils.join((Object[])MavenProjectConverter.toPaths(testDirs), ','));
        } else {
            props.remove("sonar.tests");
        }
    }

    private static void populateSurefireReportsPath(MavenProject pom, Map<String, String> props) {
        String surefireReportsPath = MavenUtils.getPluginSetting(pom, "org.apache.maven.plugins", ARTIFACTID_MAVEN_SUREFIRE_PLUGIN, "reportsDirectory", pom.getBuild().getDirectory() + File.separator + "surefire-reports");
        File path = MavenProjectConverter.resolvePath(surefireReportsPath, pom.getBasedir());
        if (path != null && path.exists()) {
            props.put(SUREFIRE_REPORTS_PATH_DEPRECATED_PROPERTY, path.getAbsolutePath());
            props.put(SUREFIRE_REPORTS_PATH_PROPERTY, path.getAbsolutePath());
        }
    }

    private static void populateLibraries(MavenProject pom, Map<String, String> props, boolean test) throws MojoExecutionException {
        List classpathElements;
        try {
            classpathElements = test ? pom.getTestClasspathElements() : pom.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to populate" + (test ? " test" : "") + " libraries", (Exception)((Object)e));
        }
        ArrayList<File> libraries = new ArrayList<File>();
        if (classpathElements != null) {
            String outputDirectory = test ? pom.getBuild().getTestOutputDirectory() : pom.getBuild().getOutputDirectory();
            File basedir = pom.getBasedir();
            classpathElements.stream().filter(cp -> !cp.equals(outputDirectory)).map(cp -> Optional.ofNullable(MavenProjectConverter.resolvePath(cp, basedir))).filter(Optional::isPresent).map(Optional::get).filter(File::exists).forEach(libraries::add);
        }
        if (!libraries.isEmpty()) {
            String librariesValue = StringUtils.join((Object[])MavenProjectConverter.toPaths(libraries), ',');
            if (test) {
                props.put(JAVA_PROJECT_TEST_LIBRARIES, librariesValue);
            } else {
                props.put(PROJECT_LIBRARIES, librariesValue);
                props.put(JAVA_PROJECT_MAIN_LIBRARIES, librariesValue);
            }
        }
    }

    private static void populateBinaries(MavenProject pom, Map<String, String> props) {
        File testBinaryDir;
        File mainBinaryDir = MavenProjectConverter.resolvePath(pom.getBuild().getOutputDirectory(), pom.getBasedir());
        if (mainBinaryDir != null && mainBinaryDir.exists()) {
            String binPath = mainBinaryDir.getAbsolutePath();
            props.put(PROJECT_BINARY_DIRS, binPath);
            props.put(JAVA_PROJECT_MAIN_BINARY_DIRS, binPath);
            props.put(GROOVY_PROJECT_MAIN_BINARY_DIRS, binPath);
        }
        if ((testBinaryDir = MavenProjectConverter.resolvePath(pom.getBuild().getTestOutputDirectory(), pom.getBasedir())) != null && testBinaryDir.exists()) {
            String binPath = testBinaryDir.getAbsolutePath();
            props.put(JAVA_PROJECT_TEST_BINARY_DIRS, binPath);
        }
    }

    private static File getSonarWorkDir(MavenProject pom) {
        return new File(MavenProjectConverter.getBuildDir(pom), "sonar");
    }

    private static File getBuildDir(MavenProject pom) {
        return MavenProjectConverter.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir());
    }

    static File resolvePath(@Nullable String path, File basedir) {
        if (path != null) {
            File file = new File(StringUtils.trim(path));
            if (!file.isAbsolute()) {
                file = new File(basedir, path).getAbsoluteFile();
            }
            return file;
        }
        return null;
    }

    static List<File> resolvePaths(Collection<String> paths, File basedir) {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            File fileOrDir = MavenProjectConverter.resolvePath(path, basedir);
            if (fileOrDir == null) continue;
            result.add(fileOrDir);
        }
        return result;
    }

    private static void removeTarget(MavenProject pom, Collection<String> relativeOrAbsolutePaths) {
        Path baseDir = pom.getBasedir().toPath().toAbsolutePath().normalize();
        Path target = Paths.get(pom.getBuild().getDirectory(), new String[0]).toAbsolutePath().normalize();
        Path targetRelativePath = baseDir.relativize(target);
        relativeOrAbsolutePaths.removeIf(pathStr -> {
            Path path = Paths.get(pathStr, new String[0]).toAbsolutePath().normalize();
            Path relativePath = baseDir.relativize(path);
            return relativePath.startsWith(targetRelativePath);
        });
    }

    private List<File> mainSources(MavenProject pom) throws MojoExecutionException {
        LinkedHashSet<String> sources = new LinkedHashSet<String>();
        if (MAVEN_PACKAGING_WAR.equals(pom.getModel().getPackaging())) {
            sources.add(MavenUtils.getPluginSetting(pom, "org.apache.maven.plugins", ARTIFACTID_MAVEN_WAR_PLUGIN, "warSourceDirectory", "src/main/webapp"));
        }
        sources.add(pom.getFile().getPath());
        if (!MAVEN_PACKAGING_POM.equals(pom.getModel().getPackaging())) {
            sources.addAll(pom.getCompileSourceRoots());
        }
        return this.sourcePaths(pom, "sonar.sources", sources);
    }

    private List<File> testSources(MavenProject pom) throws MojoExecutionException {
        return this.sourcePaths(pom, "sonar.tests", pom.getTestCompileSourceRoots());
    }

    private List<File> sourcePaths(MavenProject pom, String propertyKey, Collection<String> mavenPaths) throws MojoExecutionException {
        List<File> filesOrDirs;
        boolean userDefined = false;
        String prop = StringUtils.defaultIfEmpty(this.userProperties.getProperty(propertyKey), this.envProperties.getProperty(propertyKey));
        if ((prop = StringUtils.defaultIfEmpty(prop, pom.getProperties().getProperty(propertyKey))) != null) {
            List<String> paths = Arrays.asList(StringUtils.split(prop, ","));
            filesOrDirs = MavenProjectConverter.resolvePaths(paths, pom.getBasedir());
            userDefined = true;
        } else {
            MavenProjectConverter.removeTarget(pom, mavenPaths);
            filesOrDirs = MavenProjectConverter.resolvePaths(mavenPaths, pom.getBasedir());
        }
        if (userDefined && !MAVEN_PACKAGING_POM.equals(pom.getModel().getPackaging())) {
            return MavenProjectConverter.existingPathsOrFail(filesOrDirs, pom, propertyKey);
        }
        return MavenProjectConverter.removeNested(MavenProjectConverter.keepExistingPaths(filesOrDirs));
    }

    private static List<File> existingPathsOrFail(List<File> dirs, MavenProject pom, String propertyKey) throws MojoExecutionException {
        for (File dir : dirs) {
            if (dir.exists()) continue;
            throw new MojoExecutionException(String.format("The directory '%s' does not exist for Maven module %s. Please check the property %s", dir.getAbsolutePath(), pom.getId(), propertyKey));
        }
        return dirs;
    }

    private static List<File> keepExistingPaths(List<File> files) {
        return files.stream().filter(f -> f != null && f.exists()).collect(Collectors.toList());
    }

    private static List<File> removeNested(List<File> originalPaths) {
        ArrayList<File> result = new ArrayList<File>();
        for (File maybeChild : originalPaths) {
            boolean hasParent = false;
            for (File possibleParent : originalPaths) {
                if (!MavenProjectConverter.isStrictChild(maybeChild, possibleParent)) continue;
                hasParent = true;
            }
            if (hasParent) continue;
            result.add(maybeChild);
        }
        return result;
    }

    static boolean isStrictChild(File maybeChild, File possibleParent) {
        return !maybeChild.equals(possibleParent) && maybeChild.toPath().startsWith(possibleParent.toPath());
    }

    private static String[] toPaths(Collection<File> dirs) {
        Collection paths = dirs.stream().map(File::getAbsolutePath).collect(Collectors.toList());
        return paths.toArray(new String[paths.size()]);
    }
}

