/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.Collection;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenPlugin {
    private Xpp3Dom configuration;

    private MavenPlugin(Object configuration) {
        this.configuration = (Xpp3Dom)configuration;
    }

    public String getParameter(String key) {
        Xpp3Dom node = this.findNodeWith(key);
        return node == null ? null : node.getValue();
    }

    private static int getIndex(String key) {
        if (key.matches(".*?\\[\\d+\\]")) {
            return Integer.parseInt(StringUtils.substringBetween(key, "[", "]"));
        }
        return 0;
    }

    private static String removeIndexSnippet(String key) {
        return StringUtils.substringBefore(key, "[");
    }

    @CheckForNull
    private Xpp3Dom findNodeWith(String key) {
        String[] keyParts = key.split("/");
        Xpp3Dom node = this.configuration;
        for (String keyPart : keyParts) {
            if (node.getChildren(MavenPlugin.removeIndexSnippet(keyPart)).length <= MavenPlugin.getIndex(keyPart)) {
                return null;
            }
            if ((node = node.getChildren(MavenPlugin.removeIndexSnippet(keyPart))[MavenPlugin.getIndex(keyPart)]) != null) continue;
            return null;
        }
        return node;
    }

    @CheckForNull
    public static MavenPlugin getPlugin(MavenProject pom, String groupId, String artifactId) {
        Plugin pluginFromManagement;
        Object pluginConfiguration = null;
        Plugin plugin = MavenPlugin.getPlugin(pom.getBuildPlugins(), groupId, artifactId);
        if (plugin != null) {
            pluginConfiguration = plugin.getConfiguration();
        } else {
            ReportPlugin reportPlugin;
            Reporting reporting = pom.getModel().getReporting();
            if (reporting != null && (reportPlugin = MavenPlugin.getReportPlugin(reporting.getPlugins(), groupId, artifactId)) != null) {
                pluginConfiguration = reportPlugin.getConfiguration();
            }
        }
        PluginManagement pluginManagement = pom.getPluginManagement();
        if (pluginManagement != null && (pluginFromManagement = MavenPlugin.getPlugin(pluginManagement.getPlugins(), groupId, artifactId)) != null) {
            Object pluginConfigFromManagement = pluginFromManagement.getConfiguration();
            if (pluginConfiguration == null) {
                pluginConfiguration = pluginConfigFromManagement;
            } else if (pluginConfigFromManagement != null) {
                Xpp3Dom.mergeXpp3Dom((Xpp3Dom)pluginConfiguration, (Xpp3Dom)pluginConfigFromManagement);
            }
        }
        if (pluginConfiguration != null) {
            return new MavenPlugin(pluginConfiguration);
        }
        return null;
    }

    @CheckForNull
    private static Plugin getPlugin(Collection<Plugin> plugins, String groupId, String artifactId) {
        for (Plugin plugin : plugins) {
            if (!MavenPlugin.isEqual(plugin, groupId, artifactId)) continue;
            return plugin;
        }
        return null;
    }

    private static boolean isEqual(Plugin plugin, String groupId, String artifactId) {
        return plugin.getArtifactId().equals(artifactId) && plugin.getGroupId().equals(groupId);
    }

    @CheckForNull
    private static ReportPlugin getReportPlugin(Collection<ReportPlugin> plugins, String groupId, String artifactId) {
        for (ReportPlugin plugin : plugins) {
            if (!MavenPlugin.isEqual(plugin, groupId, artifactId)) continue;
            return plugin;
        }
        return null;
    }

    private static boolean isEqual(ReportPlugin plugin, String groupId, String artifactId) {
        return plugin.getArtifactId().equals(artifactId) && plugin.getGroupId().equals(groupId);
    }
}

