var CONTEXT_PATH = AJS.contextPath();
var config;
var rootReportData;
var canUseUsers;
var noMatchMessage = AJS.I18n.getText("-common.text.no-matches").toString();
var enabledMessage = AJS.I18n.getText("-common.text.enabled").toString();
var disabledMessage = AJS.I18n.getText("-common.text.disabled").toString();
var assignedMessage = AJS.I18n.getText("-common.text.assigned").toString();
var unassignedMessage = AJS.I18n.getText("-common.text.unassigned").toString();

function getLicenseConfig() {
  var allowForceRemove = function() {
    var els = {
      warningEl: AJS.$('.js-flx-message-panel--force'),
      reduceInput: AJS.$('#reduce-value'),
      btn: AJS.$('#reduce-run')
    };

    els.warningEl.addClass('hidden');
    els.reduceInput.attr('disabled', false);
    els.btn.attr('disabled', false);
  };

  var url = CONTEXT_PATH + '/rest/custom/1.0/license';
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function (msg) {
      config = msg;

      AJS.$('#input-user-count').val(msg.userLimit);
      //AJS.$('#input-noti').val(msg.notiLimit);
      AJS.$('#input-last-login').val(msg.lastLogin);
      AJS.$('#select-schedule-time').val(msg.deactiveScheduleHour);
      AJS.$('#select-schedule-day').val(msg.deactiveScheduleInterval);
      AJS.$('#checkbox-user-inactive').attr('checked', msg.isInactive);
      AJS.$('#checkbox-user-reactive').attr('checked', msg.isReactive);
      AJS.$('#checkbox-user-nologin').attr('checked', msg.isNotLogin);
      AJS.$('#info-not-supported-sso').addClass('hidden');
      AJS.$('#info-not-supported-sso-inactive').addClass('hidden');

      // 스케줄 설정
      fnSetRemoveSchedule(msg);

      fnSetUserGroup(msg.sourceGroup, msg.targetGroup);
      fnSetUserGroupList(msg.sourceGroup);
      fnOnOffSetting(msg);
      warningOnOffSetting();
     // setForceRemove(msg.targetGroup);
      getUserGroupList();
      notificationSetting();
      getNotiSetupInuse();

      // 자동 로그인 페이지 데이터 setting
      fnAutoLoginDataSetting(msg);
      // 자동 로그인 on/off setting
      fnAutoLoginOnOffSetting(msg);
      // 라이선스 수 유지 on/off setting
      fnLicenseKeepingOnOffSetting(msg);
      // 라이선스 수 유지 데이터 setting
      fnLicenseKeepingDataSetting(msg);
      checkLicenseKeepingScheduleJob(msg);

      msg.targetGroup !== 'N' && allowForceRemove();
    },
    fail: function() {
      console.info('get license config fail.');
    }
  });
}


function getNextExecutionTime(interval, week, day, hour) {
  var now = new Date();
  var next = new Date(now);

  // 매일 실행
  if (interval === 1) {
    next.setHours(hour, 0, 0, 0);
    if (next <= now) {
      next.setDate(next.getDate() + 1);
    }
  }
  else if (interval === 7) {
    var currentDay = now.getDay() + 1;
    var daysToAdd = (week - currentDay + 7) % 7;
    if (daysToAdd === 0 && now.getHours() >= hour) {
      daysToAdd = 7; // 이미 오늘 실행 시간이 지났으면 다음 주
    }
    next.setDate(now.getDate() + daysToAdd);
    next.setHours(hour, 0, 0, 0);
  }
  // 매월 실행
  else if (interval === 30) {
    next.setDate(day);
    next.setHours(hour, 0, 0, 0);
    if (next <= now) {
      next.setMonth(next.getMonth() + 1);
    }
  }

  return next;
}

function getNextRunTimeLicenseKeeping(interval, timeUnit) {
  var now = new Date();
  var next = new Date(now);

  if (timeUnit == 1) {
    // 분 단위 실행
    var minute = now.getMinutes();
    var remainder = minute % interval;
    var add = remainder === 0 ? interval : interval - remainder; // 다음 실행까지 남은 분
    next.setMinutes(minute + add, 0, 0);

  } else if (timeUnit == 60) {
    // 시간 단위 실행
    var hour = now.getHours();
    var remainder = hour % interval;
    var add = remainder === 0 ? interval : interval - remainder; // 다음 실행까지 남은 시간
    next.setHours(hour + add, 0, 0, 0);
  }

  return next;
}

function getUserGroupList() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/source';
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function(groups) {
      if (groups.length === 0) {
        AJS.$('#check-user-group-td').removeClass('hidden');

        AJS.$('#tbody_check_user_group tr').each(function (idx) {
          if (idx > 0) {
            AJS.$(this).remove();
          }
        })
      } else {
        AJS.$('#check-user-group-td').addClass('hidden')

        AJS.$('#tbody_check_user_group tr').each(function (idx){
          if (idx > 0) {
            AJS.$(this).remove();
          }
        })

        var tags = [];

        AJS.$.each(groups, function (idx, el) {
          tags.push('<tr> <td>' + el.group_name + '</td>'
              + '<td>' + el.user_count + '</td> </tr>');
        });

        AJS.$('#tbody_check_user_group').append(tags);
      }
    },
    fail: function() {
      console.info('get User Group List fail.');
    }
  });
}


function getGroupStat(target) {

  if (target == '') {
    return;
  }

  var stat;

  if (target == 'source') {
    stat = CONTEXT_PATH + '/rest/custom/1.0/groups/stat/source';
  } else {
    stat = CONTEXT_PATH + '/rest/custom/1.0/groups/stat/canuse';
  }

  var result = JSON;
  AJS.$.ajax({
    url: stat,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'GET',
    dataType: 'json',
    success: function (data) {
      if (target === 'source') {
        //AJS.$('#ori-group-cnt-row').removeClass('hidden');
        AJS.$('#ori-group-cnt').text(toNumber(data.count));
        AJS.$('#ori-group-cnt-time').text(data.day);
        AJS.$('#fetching-source-msg').css('display', 'none');
      } else {
        //AJS.$('#canuse-group-cnt-row').removeClass('hidden');
        AJS.$('#target-group-title').text(data.name);
        AJS.$('#canuse-group-cnt').text(toNumber(data.count));
        AJS.$('#canuse-group-cnt-time').text(data.day);
        AJS.$('#fetching-canuse-msg').css('display', 'none');
        canUseUsers = toNumber(data.count);
      }
      getLicenseConfig();
      console.log("getGroupStat");
    },
    fail: function () {
      AJS.$('#fetching-canuse-msg').css('display', 'none');
    }
  });
}


function toNumber(txt) {
  return Number(txt).toLocaleString();
}


// 20200218 flexible user License
// getGroupList, getNotiGroup, validateUser
function getGroupList(pTag) {
  var name;
  var target;
  var tag = AJS.$('#' + pTag);
  var divTag = "<div class='group-items' onclick='setGroupValue(\"";
  if (pTag === 'ori-group-list') {
    target = 'source';
    name = AJS.$('#ori-group-input').val();
  } else if (pTag === 'canuse-group-list'){
    target = 'target';
    name = AJS.$('#canuse-group-input').val();
  } else if (pTag === 'source-group-list'){
    target = 'move-source';
    name = AJS.$('#source-group-input').val();
  } else if (pTag === 'destination-group-list'){
    target = 'move-destination';
    name = AJS.$('#destination-group-input').val();
  }

  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/search?search=' + name;

  url = encodeURI(url);

  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    timeout: 15000,
    success: function (msg) {
      tag.html('');

      if (msg[0] === 'No Matches') {
        var noMathEl =
            divTag +
            target +
            '", "' +
            msg[0] +
            '")\'><em>' +
            //(v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            noMatchMessage +
            '</em></div>';
        tag.append(noMathEl);
      } else {
        for (arr in msg) {
          if (arr < 6) {
            var txt =
                divTag +
                target +
                '", "' +
                msg[arr] +
                '")\'>' +
                msg[arr] +
                '</div>';
            tag.append(txt);
          }
        }
      } // else
    }
  });
}


// license.vm 에서 구현하여 사용 안함
function setGroupValue(pTag, value) {
  if (pTag == 'source') {
    if (value === 'No Matches') {
      AJS.$('#ori-group-input').val('');
    } else {
      AJS.$('#ori-group-input').val(value);
    }
    AJS.$('#ori-group-list').html('');
  } else if (pTag == 'target') {
    if (value === 'No Matches') {
      AJS.$('#canuse-group-input').val('');
    } else {
      AJS.$('#canuse-group-input').val(value);
    }
    AJS.$('#canuse-group-list').html('');
  } else if (pTag == 'move-source') {
    if (value === 'No Matches') {
      AJS.$('#source-group-input').val('');
    } else {
      AJS.$('#source-group-input').val(value);
    }
    AJS.$('#source-group-list').html('');
  } else if (pTag == 'move-destination') {
    if (value === 'No Matches') {
      AJS.$('#destination-group-input').val('');
    } else {
      AJS.$('#destination-group-input').val(value);
    }
    AJS.$('#destination-group-list').html('');
  }
}


/**Warning & Notification 관련 설정 시작**/
/**최초 notification Table 설정 가져오기**/
function initNotificationList(type) {
  var searchType = type.split("_");
  var setTbody;
  searchType.map(function (t) {
    var url = CONTEXT_PATH + '/rest/custom/1.0/notification/get/list?searchType=' + t;
    url = encodeURI(url);
    AJS.$.ajax({
      url: url,
      type: 'GET',
      dataType: 'json',
      success: function (notiList) {
        if(notiList.length > 0){
          if (t === "1") {
            AJS.$('#no-group-table-data').addClass('hidden');

            setTbody = notiList.map(function (list) {
              return '<tr><td style="border-top: none;">' + list.notificationTarget + '</td></tr>';
            });
            AJS.$('#tbody-noti-group').append(setTbody);
          } else if (t === "2") {
            AJS.$('#no-user-table-data').addClass('hidden');

            setTbody = notiList.map(function (list) {
              return '<tr><td style="border-top: none;">' + list.notificationTarget + '</td></tr>';
            });
            AJS.$('#tbody-noti-user').append(setTbody);
          } else if (t === "3") {
            AJS.$('#no-other-table-data').addClass('hidden');
            setTbody = notiList.map(function (list) {
              return '<tr><td style="border-top: none;">' + list.notificationTarget + '</td></tr>';
            });
            AJS.$('#tbody-noti-other').append(setTbody);
          }
        }
      }, fail: function () {
        console.info('get Notification List fail.');
      }
    });
  });
}


/**notification Table 추가 시 동적 수정**/
function getNotificationList(type) {
  var t = type.split("_")
  var url = CONTEXT_PATH + '/rest/custom/1.0/notification/get/list?searchType=' + t[1]
  url = encodeURI(url);
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function(notiList) {
      var tags = [];

      if (notiList.length === 0) {
        AJS.$('#no-' + t[0] + '-table-data').removeClass('hidden');
        AJS.$('#tbody-noti-' + t[0] +' tr').each(function (idx){
          if (idx > 0) {
            AJS.$(this).remove();
          }
        });

      } else {
        AJS.$('#no-' + t[0] + '-table-data').addClass('hidden');

        AJS.$('#tbody-noti-' + t[0] +' tr').each(function (idx){
          if (idx > 0) {
            AJS.$(this).remove();
          }
        });

        AJS.$.each(notiList, function (idx, el) {
          tags.push('<tr><td style="border-top: none;">'  + el.notificationTarget + '</td></tr>');
        });

        AJS.$('#tbody-noti-' + t[0]).append(tags);
      }
    },fail: function(){
      console.info('get Notification List fail.');
    }
  });
}

/*
function notiIsEmpty() {
  AJS.$.ajax({
    url: CONTEXT_PATH + '/get/notification',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'GET',
    dataType: 'json',
    success: function(notiCheck) {
      if(notiCheck){
        AJS.flag(alertMsg.failedNotificationSetupSave);
        return ;
      }else {
        exceuteSave("noti");
      }
    },
    error: function(data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}
 */

function saveNotiSetupEntity() {
  const notiSetupData = {
    inUse : true,
    scheduleHour : AJS.$('#select-warning-schedule-time').val(),
    scheduleInterval : AJS.$('#select-warning-schedule-day').val(),
    scheduleWeek : AJS.$('#select-warning-schedule-week').val(),
    scheduleDay : AJS.$('#select-warning-schedule-date').val(),
    notiLimit : AJS.$('#input-noti').val()
  };
  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/notification/save/notiSetup',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'POST',
    dataType: 'json',
    data: JSON.stringify(notiSetupData),
    success: function() {
      getLicenseConfig();
      AJS.flag(alertMsg.notificationSettingSuccess);
    },
    error: function() {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}

/**이메일 알림 입력 validation 후 저장 혹은 삭제 수행**/
function validateAndSaveOrRemoveNoti(btnValue) {
  var type = btnValue.split("_");
  var target;
  var url = "";
  switch (type[1]){
    case "1" : target = AJS.$('#input-noti-group').val();
      url = CONTEXT_PATH + '/rest/custom/1.0/groups/checkGroupMatch?search=' + target;
      url = encodeURI(url);
      AJS.$('#input-noti-group').val(null);
      break;
    case "2" : target = AJS.$('#input-noti-user').val();
      url = CONTEXT_PATH + '/rest/custom/1.0/notification/UserCheck?userName=' + target;
      url = encodeURI(url);
      AJS.$('#input-noti-user').val(null);
      break;
    case "3" : target = AJS.$('#input-noti-other').val();

      var emailRegex = new RegExp('[a-z0-9]+@[a-z]+\.[a-z]{2,3}');
      if(emailRegex.test(target)){
        url = CONTEXT_PATH + '/rest/custom/1.0/notification/search/email?email=' + target;
        url = encodeURI(url);
      }else{
        setEmailNotificationCaution('No Matches', type[1]);
        return;
      }

      AJS.$('#input-noti-other').val(null);
      break;
    default : target = "";
  }
  const notiData = {
    notificationType : type[1],
    notificationTarget : target
  };
  /**실제 존재하는 그룹 및 사용자인지 Validation 체크 후 저장**/
  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'GET',
    dataType: 'json',
    success: function(data) {
      if(type[2] === "add"){
        if (data[0] !== 'No Matches' || (type[1] === "3" && data[0] !== 'Empty')) {
          setEmailNotificationCaution("hidden", type[1]);
          saveNotiEntity(notiData, btnValue);
        } else{
          setEmailNotificationCaution('No Matches', type[1]);
          return ;
        }

      }else if(type[2] === "remove"){
        if(data[0] === 'No Matches' || data[0] === 'Empty'){
          setEmailNotificationCaution('No Matches', type[1]);
          return;
        }else{
          setEmailNotificationCaution("hidden", type[1]);
          removeNotiEntity(btnValue, target);
        }
      }
    },
    error : function() {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}

/**최초 Exclude Target Table 설정 가져오기**/
function initExcludeTargetList(type) {
  var searchType = type.split("_");
  var setTbody;
  searchType.map(function (t) {
    var url = CONTEXT_PATH + '/rest/custom/1.0/license/get/excludeTarget/list?searchType=' + t;
    url = encodeURI(url);
    AJS.$.ajax({
      url: url,
      type: 'GET',
      dataType: 'json',
      success: function (excludeTargetList) {
        if(excludeTargetList.length > 0){
          if (t === "1") {
            AJS.$('#no-group-table-data').addClass('hidden');

            setTbody = excludeTargetList.map(function (list) {
              return '<tr><td style="border-top: none;">' + list.excludeTarget + '</td></tr>';
            });
            AJS.$('#tbody-exclude-group').append(setTbody);
          } else if (t === "2") {
            AJS.$('#no-user-table-data').addClass('hidden');

            setTbody = excludeTargetList.map(function (list) {
              return '<tr><td style="border-top: none;">' + list.excludeTarget + '</td></tr>';
            });
            AJS.$('#tbody-exclude-user').append(setTbody);
          } else if (t === "3") {
            AJS.$('#no-other-table-data').addClass('hidden');
            setTbody = excludeTargetList.map(function (list) {
              return '<tr><td style="border-top: none;">' + list.excludeTarget + '</td></tr>';
            });
            AJS.$('#tbody-exclude-other').append(setTbody);
          }
        }
      }, fail: function () {
        console.error('get Exclude Target List fail.');
      }
    });
  });
}

/** Remove Exclude Table 추가 시 동적 수정**/
function getExcludeTargetList(type) {
  var t = type.split("_")
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/get/excludeTarget/list?searchType=' + t[1]
  url = encodeURI(url);
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function(excludeTargetList) {
      var tags = [];

      if (excludeTargetList.length === 0) {
        AJS.$('#no-' + t[0] + '-table-data').removeClass('hidden');
        AJS.$('#tbody-exclude-' + t[0] +' tr').each(function (idx){
          if (idx > 0) {
            AJS.$(this).remove();
          }
        });

      } else {
        AJS.$('#no-' + t[0] + '-table-data').addClass('hidden');

        AJS.$('#tbody-exclude-' + t[0] +' tr').each(function (idx){
          if (idx > 0) {
            AJS.$(this).remove();
          }
        });

        AJS.$.each(excludeTargetList, function (idx, el) {
          tags.push('<tr><td style="border-top: none;">'  + el.excludeTarget + '</td></tr>');
        });

        AJS.$('#tbody-exclude-' + t[0]).append(tags);
      }
    },fail: function(){
      console.error('get Exclude Target List fail.');
    }
  });
}

/**이메일 알림 입력 validation 후 저장 혹은 삭제 수행**/
function validateAndSaveOrRemoveExcludeSetting(btnValue) {
  var type = btnValue.split("_");
  var target;
  var url = "";

  switch (type[1]) {
    case "1" : target = AJS.$('#input-exclude-table-group').val();
      url = CONTEXT_PATH + '/rest/custom/1.0/groups/checkGroupMatch?search=' + target;
      url = encodeURI(url);
      AJS.$('#input-exclude-table-group').val(null);
      break;

    case "2" : target = AJS.$('#input-exclude-table-user').val();
      url = CONTEXT_PATH + '/rest/custom/1.0/notification/UserCheck?userName=' + target;
      url = encodeURI(url);
      AJS.$('#input-exclude-table-user').val(null);
      break;

    default:
      target = "";

  }

  const excludeData = {
    excludeTargetType : type[1],
    excludeTarget : target
  };

  /**실제 존재하는 그룹 및 사용자인지 Validation 체크 후 저장**/
  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'GET',
    dataType: 'json',
    success: function(data) {
      if(type[2] === "add"){
        if (data[0] !== 'No Matches' || (type[1] === "3" && data[0] !== 'Empty')) {
          setExcludeTargetInputCaution("hidden", type[1]);
          saveExcludeTargetEntity(excludeData, btnValue);

        } else{
          setExcludeTargetInputCaution('No Matches', type[1]);
          return ;
        }

      }

      else if(type[2] === "remove"){
        if(data[0] === 'No Matches' || data[0] === 'Empty'){
          setExcludeTargetInputCaution('No Matches', type[1]);
          return;
        }else{
          setExcludeTargetInputCaution("hidden", type[1]);
          removeExcludeEntity(btnValue, target);
        }
      }

    },
    error : function() {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}

function saveNotiEntity(notiData, btnValue) {
  /**NotiEntity 저장**/
  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/notification/save/noti',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'POST',
    dataType: 'json',
    data: JSON.stringify(notiData),
    success: function(data) {
      if(data[0] === 'existed'){
        setEmailNotificationCaution(data[0], notiData.notificationType);
        return;
      }else{
        setEmailNotificationCaution('hidden', notiData.notificationType);
        getNotificationList(btnValue);
        AJS.flag(alertMsg.addNotification);
      }
    },
    error: function(data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}

function saveExcludeTargetEntity(excludeData, btnValue) {
  /**ExcludeEntity 저장**/
  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/license/save/excludeTarget',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'POST',
    dataType: 'json',
    data: JSON.stringify(excludeData),
    success: function(data) {
      if(data[0] === 'existed'){
        setExcludeTargetInputCaution(data[0], excludeData.excludeTargetType);
        return;
      } else{
        setExcludeTargetInputCaution('hidden', excludeData.excludeTargetType);;
        getExcludeTargetList(btnValue);
        AJS.flag(alertMsg.addExcludeTarget);
      }
    },
    error: function(data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}

/** ExcludeEntity 삭제**/
function removeExcludeEntity(btnValue, target) {
  var type = btnValue.split("_");
  const removeTarget = {
    excludeTargetType: type[1],
    excludeTarget : target
  };
  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/license/remove/excludeTarget',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'POST',
    dataType: 'json',
    data: JSON.stringify(removeTarget),
    success: function(msg) {
      if(msg[0] === "success"){
        getExcludeTargetList(btnValue);
        AJS.flag(alertMsg.removeExcludeTarget);
      }else{
        AJS.flag(alertMsg.failedMandatory);
      }

    },
    error: function(data) {
    }
  });
}

/**NotiEntity 삭제**/
function removeNotiEntity(btnValue, target) {
  var type = btnValue.split("_");
  const removeTarget = {
    notificationType: type[1],
    notificationTarget : target
  };
  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/notification/remove/noti',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'POST',
    dataType: 'json',
    data: JSON.stringify(removeTarget),
    success: function(msg) {
      if(msg[0] === "success"){
        getNotificationList(btnValue);
        AJS.flag(alertMsg.removeNotification);
      }else{
        AJS.flag(alertMsg.failedMandatory);
      }

    },
    error: function(data) {
    }
  });
}


function setEmailNotificationCaution(cautionType, setType) {
  if(cautionType === "existed"){ //이미 저장된 알림 타겟
    if(setType === "1"){
      AJS.$('#notiExistedGroup_msg').removeClass('hidden');
      AJS.$('#notiValidGroup_msg').addClass('hidden');
    }else if(setType === "2"){
      AJS.$('#notiExistedUser_msg').removeClass('hidden');
      AJS.$('#notiValidUser_msg').addClass('hidden');
    }else if(setType === "3"){
      AJS.$('#notiExistedOther_msg').removeClass('hidden');
      AJS.$('#notiValidOther_msg').addClass('hidden');
    }
  }else if(cautionType === "hidden"){ //존재하지 않는 그룹 혹은 사용자
    if(setType === "1"){
      AJS.$('#notiExistedGroup_msg').addClass('hidden');
      AJS.$('#notiValidGroup_msg').addClass('hidden');
    }else if(setType === "2"){
      AJS.$('#notiExistedUser_msg').addClass('hidden');
      AJS.$('#notiValidUser_msg').addClass('hidden');
    }else if(setType === "3"){
      AJS.$('#notiExistedOther_msg').addClass('hidden');
      AJS.$('#notiValidOther_msg').addClass('hidden');
    }
  }else if(cautionType === "No Matches"){
    if(setType === "1"){
      AJS.$('#notiValidGroup_msg').removeClass('hidden');
      AJS.$('#notiExistedGroup_msg').addClass('hidden');
    }else if(setType === "2"){
      AJS.$('#notiValidUser_msg').removeClass('hidden');
      AJS.$('#notiExistedUser_msg').addClass('hidden');
    }else if(setType === "3"){
      AJS.$('#notiValidOther_msg').removeClass('hidden');
      AJS.$('#notiExistedOther_msg').addClass('hidden');
    }
  }
}

function setExcludeTargetInputCaution(cautionType, setType) {
  if(cautionType === "existed"){ //이미 저장된 알림 타겟
    if(setType === "1"){
      AJS.$('#exclude_existedGroup_msg').removeClass('hidden');
      AJS.$('#exclude_validGroup_msg').addClass('hidden');
    } else if(setType === "2"){
      AJS.$('#exclude_existedUser_msg').removeClass('hidden');
      AJS.$('#exclude_validUser_msg').addClass('hidden');
    }

  } else if(cautionType === "hidden"){ //존재하지 않는 그룹 혹은 사용자
    if(setType === "1"){
      AJS.$('#exclude_existedGroup_msg').addClass('hidden');
      AJS.$('#exclude_validGroup_msg').addClass('hidden');
    } else if(setType === "2"){
      AJS.$('#exclude_existedUser_msg').addClass('hidden');
      AJS.$('#exclude_validUser_msg').addClass('hidden');
    }

  } else if(cautionType === "No Matches"){
    if(setType === "1"){
      AJS.$('#exclude_validGroup_msg').removeClass('hidden');
      AJS.$('#exclude_existedGroup_msg').addClass('hidden');
    } else if(setType === "2"){
      AJS.$('#exclude_validUser_msg').removeClass('hidden');
      AJS.$('#exclude_existedUser_msg').addClass('hidden');
    }
  }
}

function saveConfig() {
  const host = location.protocol + "//" + location.host + location.pathname;
  var configData = JSON;
  //configData.userLimit = AJS.$('#input-user-count').val();
  //configData.notiLimit = AJS.$('#input-noti').val();
  configData.lastLogin = AJS.$('#input-last-login').val();
  configData.deactiveScheduleHour = AJS.$('#select-schedule-time').val();
  configData.deactiveScheduleInterval = AJS.$('#select-schedule-day').val();
  configData.deactiveScheduleWeek = AJS.$('#select-schedule-week').val();
  configData.deactiveScheduleDay = AJS.$('#select-schedule-date').val();
  configData.isInactive = AJS.$('#checkbox-user-inactive').is(':checked');
  configData.isReactive = AJS.$('#checkbox-user-reactive').is(':checked');
  configData.isNotLogin = AJS.$('#checkbox-user-nologin').is(':checked');
  configData.deactiveEnabled = config.deactiveEnabled;
  configData.countCanuseDate = config.countCanuseDate;
  configData.countCanuseGroup = config.countCanuseGroup;
  configData.countSourceDate = config.countSourceDate;
  configData.countSourceGroup = config.countSourceGroup;
  //configData.notiGroup = AJS.$('#input-noti-group').val();
  configData.flexurl = host;
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/control';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'PUT',
    dataType: 'json',
    data: JSON.stringify(configData),
    success: function (data) {
      AJS.$('#noti-groups').html('');
      AJS.$('#msg-last-login-test').hide();
      getLicenseConfig();
      AJS.flag(alertMsg.autoSettingSuccess);
    },
    error: function (data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}


function getConfigLastTest() {
  document.getElementById('btn_schedule_test').disabled = true;
  // AJS.$("#").disable();
  AJS.$('#test-config-progress').addClass('icon-rotate');
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/test/days';
  var value = AJS.$('#input-last-login').val();
  var checked = AJS.$('#checkbox-user-nologin').is(':checked');

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'GET',
    dataType: 'json',
    data: {
      days: value,
      withuser: true,
      excludeNoLoginUsers: checked
    },
    success: function (data) {
      document.getElementById('btn_schedule_test').disabled = false;
      AJS.$('#test-config-progress').removeClass('icon-rotate');
      var calc = config.countCanuseGroup - data.count;
      AJS.$('#msg-last-login-test').show();
      AJS.$('#config-test-result').text(data.count);
      AJS.$('#config-test-calc').text(Math.sign(calc) === -1 ? 0 : toNumber(calc));
    },
    error: function (data) {
      document.getElementById('btn_schedule_test').disabled = false;
      AJS.$('#test-config-progress').removeClass('icon-rotate');
    }
  });
}


function getImmediateDayTest() {
  document.getElementById('test-day').disabled = true;
  AJS.$('#test-day-sync-progress').css('display', 'inline-block');

  var value = AJS.$('#immediate-day-input').val();
  var url =
      CONTEXT_PATH +
      '/rest/custom/1.0/license/test/days?days=' +
      value +
      '&withuser=true';
  AJS.$.get(url, function (data) {
    // AJS.$("#test-day").enable();
    document.getElementById('test-day').disabled = false;
    AJS.$('#test-day-sync-progress').css('display', 'none');
    AJS.$('#immediate-last-day-test-user').text(data.count);
    AJS.$('#immediate-day-desc').show();
  }).fail(function () {
    document.getElementById('test-day').disabled = false;
    AJS.$('#test-day-sync-progress').css('display', 'none');
  });
}

function getCountRemove() {
  var value = AJS.$('#remove-value').val();
  document.getElementById('remove-test').disabled = true;
  // AJS.$("#remove-test").disable();
  AJS.$('#remove-test-sync-progress').css('display', 'inline-block');
  var url =
      CONTEXT_PATH +
      '/rest/custom/1.0/license/test/remove?count=' +
      value +
      '&withuser=true';
  AJS.$.get(url, function (data) {
    document.getElementById('remove-test').disabled = false;
    // AJS.$("#remove-test").enable();
    AJS.$('#remove-test-sync-progress').css('display', 'none');
    AJS.$('#remove-msg-span').text(data.latest);
    AJS.$('#remove-msg').show();
    console.info(data);
  }).fail(function () {
    document.getElementById('remove-test').disabled = false;
    AJS.$('#remove-msg-span').text(data.latest);
  });
}


function getCountReduce() {
  var value = AJS.$('#reduce-value').val();
  getGroupStat('canuse');

  if (value < canUseUsers) {
    showMsg('Invalid Value', 'Must be less than the number of can use users.');
  }

  document.getElementById('reduce-test').disabled = true;
  AJS.$('#reduce-test-sync-progress').css('display', 'inline-block');
  var url =
      CONTEXT_PATH +
      '/rest/custom/1.0/license/test/reduce?count=' +
      value +
      '&withuser=true';

  AJS.$.get(url, function (data) {
    document.getElementById('reduce-test').disabled = false;
    AJS.$('#reduce-test-sync-progress').css('display', 'none');
    AJS.$('#reduce-msg-span').text(data.latest);
    AJS.$('#reduce-msg').show();
    console.info(data);
  }).fail(function (data) {
    document.getElementById('reduce-test').disabled = false;
    AJS.$('#reduce-test-sync-progress').css('display', 'none');
  });
}


function runImmediateDay() {
  var value = AJS.$('#immediate-day-input').val();
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/remove/days?days=' + value;

  document.getElementById('run-day').disabled = true;
  AJS.$('#run-day-sync-progress').css('display', 'inline-block');

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'DELETE',
    success: function (data) {
      document.getElementById('run-day').disabled = false;
      AJS.$('#run-day').enable();
      AJS.$('#run-day-sync-progress').css('display', 'none');
      showMsg('Success', 'Remove ' + data.count + ' User');
      // getGroupStat("canuse");
    },
    error: function (data) {
      document.getElementById('run-day').disabled = false;
      AJS.$('#run-day-sync-progress').css('display', 'none');
    }
  });
}

function runCountRemove() {
  var value = AJS.$('#remove-value').val();
  var url =
      CONTEXT_PATH + '/rest/custom/1.0/license/remove/count?count=' + value;
  document.getElementById('remove-run').disabled = true;
  AJS.$('#remove-run-sync-progress').css('display', 'inline-block');

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'DELETE',
    success: function (data) {
      document.getElementById('remove-run').disabled = false;
      AJS.$('#remove-run-sync-progress').css('display', 'none');
      // getGroupStat("canuse");
      showMsg('Success', 'Remove ' + value + ' User');
    },
    error: function (data) {
      document.getElementById('remove-run').disabled = false;
    }
  });
}

function runCountReduce() {
  var value = AJS.$('#reduce-value').val();
  var url =
      CONTEXT_PATH +
      '/rest/custom/1.0/license/reduce/count?count=' +
      Number(value);

  document.getElementById('reduce-run').disabled = true;
  AJS.$('#reduce-run-sync-progress').css('display', 'inline-block');
  var excludeNotLogin = AJS.$('#checkbox-user-nologin-in-force-remove').is(':checked');
  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'DELETE',
    success: function (data) {
      if (data.resultMsg === 'exceed') {
        document.getElementById('reduce-run').disabled = false;
        AJS.$('#setUser_exceedMsg').removeClass('hidden');
        AJS.$('#setUser_NumberMsg').addClass('hidden');
        AJS.$('#reduce-run-sync-progress').css('display', 'none');
      } else {
        document.getElementById('reduce-run').disabled = false;
       // config.countCanuseGroup -= data.count;
        AJS.$('#reduce-run-sync-progress').css('display', 'none');
        AJS.$('#setUser_exceedMsg').addClass('hidden');
       // AJS.flag(alertMsg.removelicencseGroup);
        reduceUsers(value, excludeNotLogin, data.ID);
        getReduceProgressDetail(data.ID);
      }
    },
    error: function (data) {
      document.getElementById('reduce-run').disabled = false;
      AJS.$('#reduce-run-sync-progress').css('display', 'none');
    }
  });

}


function initLastLoginData() {
  if (config.targetGroup == undefined) {
    alert('Canuse Group setup is required');
    return;
  }

  AJS.$('#sync-progress').css('display', 'inline-block');
  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/sync';
  document.getElementById('last-login-init-button').disabled = true;
  initProgress();
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (data) {
      document.getElementById('last-login-init-button').disabled = false;
    },
    error: function (data) {
      document.getElementById('last-login-init-button').disabled = false;
    }
  });
}

function initProgress() {
  var state = CONTEXT_PATH + '/rest/custom/1.0/groups/sync/status';
  var setLastLoginDataInterval = setInterval(function () {
    AJS.$.ajax({
      url: state,
      headers: {
        Accept: 'application/json',
        'Content-Type': 'application/json'
      },
      type: 'GET',
      success: function (data) {
        AJS.$('#synced-info').html(data);
        if (data.indexOf('done') > 0) {
          AJS.$('#sync-progress').css('display', 'none');
          clearInterval(setLastLoginDataInterval);
        }
      },
      error: function (data) {
        AJS.$('#sync-progress').css('display', 'none');
        clearInterval(setLastLoginDataInterval);
      }
    });
  }, 1000);
}

function getSysDate() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/sys/date';

  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (data) {
      AJS.$('.sys-date-info').html(formatISODate(data));
     // AJS.$('#sys-date-info2').html(formatISODate(data));
    },
    error: function (data) { }
  });
}

function formatISODate(timeStamp) {
  const parts = timeStamp.split(' ');
  if (parts.length !== 6) {
    return 'Invalid input format';
  }

  const month = monthToNumber(parts[1]);
  const day = parts[2];
  const year = parts[5].substring(0,4);
  const time = parts[3];
  const timezone = parts[4];
  let [hour, minute, second] = time.split(':');

  const formattedDate = year + '-' + month + '-' + day + ' ' + hour + ':' + minute + ':' + second + " (" + timezone + ")";
  return formattedDate;
}

function formatTimeStampDate(timeStamp) {
  const parts = timeStamp.split(' ');
  if (parts.length !== 5) {
    return 'Invalid input format';
  }
  // Extract date components
  const month = monthToNumber(parts[0]);
  const day = parseInt(parts[1].replace(',', '')) < 10 ? '0' + parts[1].replace(',', '') : parts[1].replace(',', '');
  const year = parts[2].substring(0,4);
  const time = parts[3];
  const meridiem = parts[4];
  // Extract hour and minute from the time
  let [hour, minute] = time.split(':');
  hour = meridiem == "AM" ? (hour < 10 ? '0' + hour : hour) : 12 + parseInt(hour);
  if(meridiem == "AM" && hour == "12") hour = 24;
  // Format the date in the desired format
  var formattedDate = year + '-' + month + '-' + day + ' ' + hour + ':' + minute;
  return formattedDate;
}

function monthToNumber(month) {
  const months = {
    'Jan': '01',
    'Feb': '02',
    'Mar': '03',
    'Apr': '04',
    'May': '05',
    'Jun': '06',
    'Jul': '07',
    'Aug': '08',
    'Sep': '09',
    'Oct': '10',
    'Nov': '11',
    'Dec': '12'
  };
  return months[month];
}

function getLocalDate() {
  var date = new Date();
  AJS.$('#local-date-info').html(date.toString());
}

function showMsg(title, body) {
  AJS.messages.success('#msg-bar', {
    title: title,
    body: '<p>' + body + '</p>',
    fadeout: true,
    delay: 1000
  });
}

function jobRunNow() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/run/job';
  AJS.$.get(url, function (data) {
    console.info(data);
    if (data.result) {
      showMsg(data.message, 'Success');
    } else {
      showMsg(data.message, 'Fail');
    }
  });
}


function debugMode() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/run/debug';
  AJS.$.get(url, function (data) {
    console.info(data);
  });
}

// onAutoComplete 함수로 대체 하여 사용 안함
function getNotiGroups(pTag) {
  var name = AJS.$('#input-noti-group').val();
  var tag = AJS.$('#' + pTag);
  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/search?search=' + name;
  var divTag = "<div class='group-items' padding-bottom:5px;' onclick='setNotiGroup(\"";
      //"<div class='group-items' id='div_noti_group' onclick='setGroupNotiList(\"";
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function (msg) {
      // console.info(msg);
      tag.html('');

      if (msg[0] === 'No Matches') {
        var noMatchEl =
            divTag +
            msg[0] +
            '")\'><em>' +
            //(v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            noMatchMessage +
            '</em></div>';
        tag.append(noMatchEl);
      } else {
        for (arr in msg) {
          if (arr < 6) {
            var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
            tag.append(txt);
          }
        }
      } // else
    }
  });
}

function getExcludeSettingGroups(pTag) {
  var name = AJS.$('#input-exclude-table-group').val();
  var tag = AJS.$('#' + pTag);
  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/search?search=' + name;
  var divTag = "<div class='group-items' padding-bottom:5px;' onclick='setExcludeGroup(\"";

  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function (msg) {
      // console.info(msg);
      tag.html('');

      if (msg[0] === 'No Matches') {
        var noMatchEl =
            divTag +
            msg[0] +
            '")\'><em>' +
            //(v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            noMatchMessage +
            '</em></div>';
        tag.append(noMatchEl);
      } else {
        for (arr in msg) {
          if (arr < 6) {
            var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
            tag.append(txt);
          }
        }
      } // else
    }
  });
}

function setNotiGroup(group) {
  if (group === 'No Matches') {
    AJS.$('#input-noti-group').val('');
  } else {
    AJS.$('#input-noti-group').val(group);
  }
  AJS.$('#noti-groups').html('');
}

function setExcludeGroup(group) {
  if (group === 'No Matches') {
    AJS.$('#input-exclude-table-group').val('');
  } else {
    AJS.$('#input-exclude-table-group').val(group);
  }
  AJS.$('#exclude-setting-groups').html('');
}

function getUserGroup() {
  var userName = AJS.$('#test-user-name')
      .val()
      .trim();
  var errorTxtEl = AJS.$('#username_warnText');
  var loadingEl = AJS.$('.js-user-name-loading');

  errorTxtEl.addClass('hidden');
  if (userName == '') {
    errorTxtEl.removeClass('hidden');
    return;
  }

  var url =
      CONTEXT_PATH + '/rest/custom/1.0/license/user/group?username=' + userName;

  // 이름 검색시 loading bar 보이기
  loadingEl.removeClass('hidden');
  AJS.$('#checkGroup-nouser').addClass('hidden');

  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    timeout: 15000,
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (msg) {
      // source, canuse
      loadingEl.addClass('hidden');
      fnCheckState(msg);
    },
    error: function (request, status, error) {
    },
    fail: function () {
      console.log('message', 'ajax call fail');

    }
  });
}

// 사용자 이름 검색 테이블
var fnCheckState = function (msg) {
  var isResultView = function (hasResult) {
    var noUserEl = AJS.$('#checkGroup-nouser');
    var hasUserEl = AJS.$('#checkGroup-have-user');

    if (hasResult) {
      noUserEl.addClass('hidden');
      hasUserEl.removeClass('hidden');
    } else {
      noUserEl.removeClass('hidden');
      hasUserEl.addClass('hidden');
    }
  };

  var insertUserState = function (data) {
    var tr = AJS.$('#checkGroup-have-user');
    var userEl = tr.find('#check_User');
    var userNameEl = tr.find('#check_UserName');
    var userGroupEl = tr.find('#data_catagory_user');
    var licenceGroupEl = tr.find('#data_catagory_licence');

    var className = {
      icoDefault: 'aui-icon aui-icon-small js-aui-icon',
      icoUnAssigned: ' aui-iconfont-cross-circle flx-ico-fail',
      icoAssigned: ' aui-iconfont-check-circle-filled flx-ico-success'
    };

    var setGroupState = function (state) {
      if (state) {
        //return v_language === 'ko' ? '할당됨' : 'Assigned';
        return assignedMessage;
      } else {
        //return v_language === 'ko' ? '할당되지 않음' : 'Unassigned';
        return unassignedMessage;
      }
    };

    var groupStateView = function (wrap, state) {
      var spans = wrap.find('span');
      spans[0].className =
          className.icoDefault +
          (state ? className.icoAssigned : className.icoUnAssigned);
      spans[1].textContent = setGroupState(state);
    };

    // 사용자, 사용자 이름에 검색값 넣기
    userEl.text(data.displayName);
    userNameEl.text(data.userName);

    groupStateView(userGroupEl, data.userGroup);
    groupStateView(licenceGroupEl, data.licenseGroup);

    //console.log("insertUserState")
    //console.log(data.licenseGroup)

    if (data.licenseGroup) {
      AJS.$('#remove_action').show();
      AJS.$('#add_action').hide();
    } else {
      AJS.$('#remove_action').hide();
      AJS.$('#add_action').show();
    }
  };

  var init = function () {
    var data = {};

    // 없는 사용자일 경우 '사용자를 찾을 수 없음'표시
    if (msg.length <= 1) {
      isResultView(false);
      return;
    }

    // 사용자 이름이 있으면 테이블 데이터 보이기
    isResultView(true);

    data.userName = AJS.$('#test-user-name')
        .val()
        .trim();
    data.userGroup = msg[0];
    data.licenseGroup = msg[1];
    data.displayName = msg[2];

    // 사용자 데이터 나타내기
    insertUserState(data);
  };

  init();
};


function testUserLogin(actionType) {
  var userName = AJS.$('#check_UserName').text();

  var url =
      CONTEXT_PATH +
      '/rest/custom/1.0/license/user/login/test?username=' +
      userName +
      '&actionType=' +
      actionType;
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (msg) {
      // console.log('msg',msg);
      if (actionType === 'add') {
        AJS.flag(alertMsg.addUserSave);
      } else {
        AJS.flag(alertMsg.removeUserSave);
      }
      getUserGroup();
    }
  });
}


function getAllUserHistory(callback) {
  const url = CONTEXT_PATH + '/rest/custom/1.0/history/userhistory';

  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (msg) {
      callback(JSON.parse(msg));
    }
  });
}

function getAllSystemHistory(callback) {
  const url = CONTEXT_PATH + '/rest/custom/1.0/systemHistory';
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (msg) {
      callback(JSON.parse(msg));
    }
  });
}

function getNtfTrgLog(id, callback) {
  const url = CONTEXT_PATH + '/rest/custom/1.0/systemHistory/notification/target?id=' + id;
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (msg) {
      callback(JSON.parse(msg));
    }
  });
}

function getLogBySearch(keyword, actionTypes, beforeDate, afterDate, callback) {
  var urlPath = CONTEXT_PATH;
  urlPath = urlPath + '/rest/custom/1.0/history/userhistory/search?keyword=' + keyword + '&beforeDate=' + beforeDate + '&afterDate=' + afterDate;

  if(actionTypes !== null) {
    for(var i = 0; i < actionTypes.length; i++) {
      var typeQuery = '&actionTypes=' + actionTypes[i];
      urlPath += typeQuery;
    }
  }

  AJS.$.ajax({
    url: urlPath,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (msg) {
      // 성공적으로 받은 메시지를 JSON으로 파싱하고 해결합니다.
      callback(JSON.parse(msg));
    }
  });

}

function getSystemLogBySearch(actionTypes, beforeDate, afterDate, callback) {
  var urlPath = CONTEXT_PATH;
  urlPath = urlPath + '/rest/custom/1.0/systemHistory/search?beforeDate=' + beforeDate + '&afterDate=' + afterDate;
  if(actionTypes !== null) {
    for(var i = 0; i < actionTypes.length; i++) {
      var typeQuery = '&actionTypes=' + actionTypes[i];
      urlPath += typeQuery;
    }
  }
  AJS.$.ajax({
    url: urlPath,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (msg) {
      // 성공적으로 받은 메시지를 JSON으로 파싱하고 해결합니다.
      callback(JSON.parse(msg));
    }
  });
}

function exportUserHistoryToCsv(keyword, actionTypes, beforeDate, afterDate, callback) {
  var urlPath = CONTEXT_PATH;
  urlPath = urlPath + '/rest/custom/1.0/history/userhistory/export/csv?keyword=' + keyword + '&beforeDate=' + beforeDate + '&afterDate=' + afterDate;
  if(actionTypes !== null) {
    for(var i = 0; i < actionTypes.length; i++) {
      var typeQuery = '&actionTypes=' + actionTypes[i];
      urlPath += typeQuery;
    }
  }
  AJS.$.ajax({
    url: urlPath,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (response) {
      callback(response);
    }
  });
}

function exportSystemHistoryToCsv(actionTypes, beforeDate, afterDate, callback) {
  var urlPath = CONTEXT_PATH;
  urlPath = urlPath + '/rest/custom/1.0/systemHistory/export/csv?beforeDate=' + beforeDate + '&afterDate=' + afterDate;
  if(actionTypes !== null) {
    for(var i = 0; i < actionTypes.length; i++) {
      var typeQuery = '&actionTypes=' + actionTypes[i];
      urlPath += typeQuery;
    }
  }
  AJS.$.ajax({
    url: urlPath,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (response) {
      callback(response);
    }
  });
}

Date.prototype.getWeek = function () {
  var onejan = new Date(this.getFullYear(), 0, 1);
  return Math.ceil(((this - onejan) / 86400000 + onejan.getDay() + 1) / 7);
};


function getConfig() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license';
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function (msg) {
      AJS.$('#select-logging-time').auiSelect2(
          'val',
          msg.reportingScheduleHour
      );
    }
  });
}

function hideTopDefaultTitle() {
  AJS
      .$('.admin-heading')
      .addClass('hidden');
}

function getWeekReport() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/report';

  var year, weekStart, weekEnd;
  year = AJS.$('#input-year').val();
  weekStart = AJS.$('#input-week-start').val();
  weekEnd = AJS.$('#input-week-end').val();

  AJS.$.get(
      url,
      {
        year: year,
        startWeek: weekStart,
        endWeek: weekEnd
      },
      function (data) {
        rootReportData = data;
        AJS.$('#report-week').html('');
        for (i in data) {
          var html = "<tr class='week-line'";
          html += " onclick='getDayReport(" + i + ")'>";
          html += "<td style='text-align:center;'>";
          html += i;
          html += "</td><td style='text-align:center;'>";
          html += data[i].Average;
          html += '</td></tr>';
          AJS.$('#report-week').append(html);
        }
      }
  );
}

function getDayReport(index) {
  AJS.$('#report-day').html('');
  for (i in Object.keys(rootReportData[index])) {
    var key = Object.keys(rootReportData[index])[i];
    var html = "<tr class='day-line'>";
    html += "<td style='text-align:center;'>";
    html += key;
    html += "</td><td style='text-align:center;'>";
    html += rootReportData[index][key];
    html += '</td></tr>';
    AJS.$('#report-day').append(html);
  }
}

function saveReportime() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/report';
  var time = Number(AJS.$('#select-logging-time').val());
  var config = JSON;
  config.reportingScheduleHour = time;
  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'PUT',
    data: JSON.stringify(config),
    dataType: 'json',
    success: function (msg) {
      getConfig();
      showMsg('Addon Message', 'Save Success');
    }
  });
}


function getUserCount() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license';
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function (msg) {
      AJS.$('.last-login').html(msg.lastLogin);
    }
  });
}

// function toggle() {
//   document
//       .getElementById('auto-toggle')
//       .addEventListener('change', function(e) {
//         //saveAutoConfig()
//       });
// }


function saveAutoConfig() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/save/active-term';
  var data = JSON;
  var active_user_cnt = AJS.$('#active_user_cnt').val();
  var active_user_term = AJS.$('#active_user_term').val();
  data.activeUserCnt = active_user_cnt;
  data.activeUserTerm = active_user_term;
  data.activeTerm = document.getElementById('auto-toggle').checked;

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'POST',
    data: JSON.stringify(data),
    dataType: 'json',
    success: function (msg) {
      console.info(msg);
    }
  });
}


function getAutoConfig() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/get/active-term';
  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'GET',
    dataType: 'json',
    success: function (msg) {
      document.getElementById('auto-toggle').checked = msg.activeTerm;
      AJS.$('#active_user_cnt').val(msg.activeUserCnt);
      AJS.$('#active_user_term').val(msg.activeUserTerm);
    }
  });
}

/**
 * getLocaleLanguage
 */
var getLocaleLanguage = function () {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/get/getLanguage';

  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'text',
    headers: {
      'Content-Type': 'application/json'
    },
    success: function (data) {
      parent.ctrlLocale(data);
    },
    error: function (data) {
      console.log('error getLocaleLanguage', data);
      parent.ctrlLocale(data.error.responseText);
    }
  });
};


var hasGroup = function(searchData) {
  var result;

  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/groups/search',
    type: 'GET',
    dataType: 'json',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    async: false,
    data: { search: searchData },
    success: function(datas) {
      result = datas.resultMsg !== 'No Matches';
    },
    error: function(req) {
      console.log('req: ', req.responsText);
    }
  });
  return result;
};


var setUserGroup = function(groupName) {
  var dataUserGroup = {
    "userGroupName" : groupName
  }

  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/save';

  var isValidGroup = function(data) {
    for (var prop in data) {
      if (data[prop] === '99') return false;
    }
    return true;
  };

  var displayError = function(data) {
    AJS.$('.auto-complete__list').empty();
    for (var prop in data) {
      AJS.$('#' + prop.trim() + '-invalid').removeClass('hidden');
    }
  };

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'POST',
    dataType: 'json',
    data: JSON.stringify(dataUserGroup),
    success: function(data) {
      if (!isValidGroup(data)) {
        displayError(data);
        return;
      }
      //displayCtrl();
      AJS.flag(alertMsg.successGroupSave);
      getUserGroupList();
    },
    error: function(msg) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
};


var delUserGroup = function(groupName) {
  var dataUserGroup = {
    "userGroupName" : groupName
  }

  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/del';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'POST',
    dataType: 'json',
    data: JSON.stringify(dataUserGroup),
    success: function(data) {
      //displayCtrl();

      AJS.flag(alertMsg.deleteGroup);
      getUserGroupList();
    },
    error: function(data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
};


var addSourceGroupTable = function (groupName) {

  const url = CONTEXT_PATH + '/rest/custom/1.0/groups/group/member/count?groupName=' + encodeURIComponent(groupName);
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function(groups) {
      if (groups.length === 0) {
        AJS.$('#check-source-group-td').removeClass('hidden');

        AJS.$('#tbody_check_source_group tr').each(function (idx) {
          if (idx > 0) {
            AJS.$(this).remove();
          }
        })
      } else {
        AJS.$('#check-source-group-td').addClass('hidden')

        /*        AJS.$('#tbody_check_source_group tr').each(function (idx){
                  if (idx > 0) {
                    AJS.$(this).remove();
                  }
                })*/

        var tags = [];

        AJS.$.each(groups, function (idx, el) {
          tags.push('<tr> <td>' + el.group + '</td>'
              + '<td>' + el.size + '</td> </tr>');
        });

        AJS.$('#tbody_check_source_group').append(tags);
        AJS.$('#source-group-input').val('');
      }
    },
    fail: function() {
      console.info('get User Group List fail.');
    }
  });
}


var delSourceGroupTable = function(groupName) {
  AJS.$('#tbody_check_source_group tr').each(function (){
    var tdText = $(this).find("td:first").text(); // 첫 번째 <td>의 텍스트 가져오기
    if (tdText === groupName) {
      $(this).remove(); // 해당 <tr> 요소를 삭제
    }
  })

  const rowCount = $("#tbody_check_source_group tr").length;
  if(rowCount === 1) {
    AJS.$('#check-source-group-td').removeClass('hidden');
  }
  AJS.$('#source-group-input').val('');
}


var addDestinationGroupTable = function (groupName) {

  const url = CONTEXT_PATH + '/rest/custom/1.0/groups/group/member/count?groupName=' + encodeURIComponent(groupName);
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function(groups) {
      if (groups.length === 0) {
        AJS.$('#check-destination-group-td').removeClass('hidden');

        AJS.$('#tbody_check_destination_group tr').each(function (idx) {
          if (idx > 0) {
            AJS.$(this).remove();
          }
        });

      } else {
        AJS.$('#check-destination-group-td').addClass('hidden')

        AJS.$('#tbody_check_destination_group tr').each(function (idx){
          if (idx > 0) {
            AJS.$(this).remove();
          }
        });

        var tags = [];

        AJS.$.each(groups, function (idx, el) {
          tags.push('<tr> <td>' + el.group + '</td>'
              + '<td>' + el.size + '</td> </tr>');
        });

        AJS.$('#tbody_check_destination_group').append(tags);
        AJS.$('#destination-group-input').val('');
      }
    },
    fail: function() {
      console.info('get Destination Group List fail.');
    }
  });
}

var delDestinationGroupTable = function(groupName) {
  AJS.$('#tbody_check_destination_group tr').each(function (){
    var tdText = $(this).find("td:first").text(); // 첫 번째 <td>의 텍스트 가져오기
    if (tdText === groupName) {
      $(this).remove(); // 해당 <tr> 요소를 삭제
    }
  });

  const rowCount = $("#tbody_check_destination_group tr").length;
  if(rowCount === 1) {
    AJS.$('#check-destination-group-td').removeClass('hidden');
  }
  AJS.$('#destination-group-input').val('');
}


function getMemeberCntByGroupName(groupName) {
  const url = CONTEXT_PATH + '/rest/custom/1.0/groups/group/member/count?groupName=' + encodeURIComponent(groupName);

  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function(results) {

      AJS.$('#check-destination-group-td').addClass('hidden');
      AJS.$('#check-source-group-td').removeClass('hidden');

      AJS.$('#tbody_check_destination_group tr').each(function (idx){
        if (idx > 0) {
          AJS.$(this).remove();
        }
      });

      var tags = [];

      AJS.$.each(results, function (idx, el) {
        tags.push('<tr> <td>' + el.group + '</td>'
            + '<td>' + el.size + '</td> </tr>');
      });

      AJS.$('#tbody_check_destination_group').append(tags);
      AJS.flag(alertMsg.moveGroupSuccess);
    },
    fail: function() {
      AJS.flag(alertMsg.failedMoveGroup);
    }
  });

}


var moveSourceGroupToDestiGroup = function (sourceGroup, destinationGroup) {
  const url = CONTEXT_PATH + '/rest/custom/1.0/groups/move/group';
  var data = {};
  data.sourceGroup = sourceGroup;
  data.destiGroup = destinationGroup;

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'POST',
    data: JSON.stringify(data),
    dataType: 'json',
    success: function(groups) {
      setMoveGroupTableSuccess(groups, destinationGroup);

    },
    fail: function(e) {
      AJS.flag(alertMsg.failedMoveGroup);
      AJS.$('#move-group-sync-progress').css('display', 'none');
      document.getElementById('btn_move_group').disabled = false;
      console.info('get Destination Group List fail.');
    }
  });
}

function setMoveGroupTableSuccess(groups, destinationGroup) {
  if(groups) {
    // source group table 비우기
    AJS.$('#tbody_check_source_group tr').each(function (idx){
      if (idx > 0) {
        $(this).remove();
      }
    });

    getMemeberCntByGroupName(destinationGroup);

  }

  AJS.$('#move-group-sync-progress').css('display', 'none');
  document.getElementById('btn_move_group').disabled = false;
}


var setGroupMappingValue = function (sourceGroup, targetGroup) {
  var data = JSON.stringify({
    sourceGroup: sourceGroup,
    targetGroup: targetGroup
  });

  var isValidGroup = function(data) {
    for (var prop in data) {
      if (data[prop] === '99') return false;
    }
    return true;
  };

  var displayError = function(data) {
    AJS.$('.auto-complete__list').empty();
    for (var prop in data) {
      AJS.$('#' + prop.trim() + '-invalid').removeClass('hidden');
    }
  };

  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/setGroupMapping';
  var result = xhr(data, 'PUT', null, url);

  result.done(function (data) {

    if (!isValidGroup(data)) {
      // console.log(data);
      displayError(data);
      return;
    }

    getGroupStat('source');
    getGroupStat('canuse');
    displayCtrl();
    AJS.flag(alertMsg.successGroupSave);
  });

  result.fail(function () {
    AJS.flag(alertMsg.failedMandatory);
  });

  // AJS.$.ajax({
  //     url : url,
  //     headers : {
  //         'Accept' : 'application/json',
  //         'Content-Type' : 'application/json'
  //     },
  //     type : 'PUT',
  //     dataType : "json",
  //     data : JSON.stringify(data),
  //     success : function(data) {
  //
  //         if (!isValidGroup(data)) {
  //             displayError(data);
  //             return;
  //         }
  //
  //         getGroupStat('source');
  //         getGroupStat('canuse');
  //         displayCtrl();
  //         AJS.flag(alertMsg.successGroupSave);
  //     },
  //     error : function(data) {
  //         AJS.flag(alertMsg.failedMandatory);
  //     }
  // });
};

var displayCtrl = function () {
  AJS.$('.js-group-submit').addClass('hidden');

  AJS.$('#ori-group-row').addClass('hidden');
  AJS.$('#canus-group-row').addClass('hidden');
  AJS.$('#ori-group-cnt-row').addClass('hidden');
  AJS.$('#canuse-group-cnt-row').addClass('hidden');
  AJS.$('#userGroupWarnText').addClass('hidden');
  AJS.$('#licencedGroupWarnText').addClass('hidden');
  AJS.$('#btn_GroupEdit').show();

  // 그룹 설정 - cancel 클릭시 '구성원 확인' 버튼 보이기
  AJS.$('#group-setting-fieldset')
      .find('.lang-check-user-cnt')
      .removeClass('hidden');
  AJS
      .$('.js-check-group-assignment')
      .removeClass('hidden');
  AJS
      .$('#group-setting-fieldset')
      .find('.flx-error')
      .each(function (idx, el) {
        AJS
            .$(el)
            .addClass('hidden');
      });
};


/**
 * @param sourceGroup
 * @param targetGroup
 */
var fnSetUserGroup = function (sourceGroup, targetGroup) {
  if (sourceGroup != null && sourceGroup == 'N') {
    AJS.$('#groupInitStatus').show();
    AJS.$('#groupInitStatusActive').hide();
  } else {
    AJS.$('#groupInitStatus').hide();
    AJS.$('#groupInitStatusActive').show();
    AJS.$('#ori-group-title').text(sourceGroup);
  }
  //  사용자 그룹이 비었을때 그룹할당 확인 사용자 이름 검색시 500 err 로인해 추가
  AJS.$('#test-user-name').attr('disabled', sourceGroup === 'N' ? true : false);
  AJS.$('#btn_user_group').attr('disabled', sourceGroup === 'N' ? true : false);

  if (targetGroup != null && targetGroup == 'N') {
    AJS.$('#groupCanuseStatus').show();
    AJS.$('#groupCanuseStatusActive').hide();
  } else {
    AJS.$('#groupCanuseStatus').hide();
    AJS.$('#groupCanuseStatusActive').show();
    AJS.$('#target-group-title').text(targetGroup);
  }
};


/**
 * @param sourceGroup
 */
var fnSetUserGroupList = function(sourceGroup) {
  if (sourceGroup != null && sourceGroup == 'N') {
    AJS.$('#groupListInitStatus').removeClass('hidden');
    AJS.$('#groupListInitStatusActive').hide();
  } else {
    AJS.$('#groupListInitStatus').addClass('hidden');
    AJS.$('#groupListInitStatusActive').show();
    AJS.$('#ori-group-list-title').text(sourceGroup);
  }

  //  사용자 그룹이 비었을때 그룹할당 확인 사용자 이름 검색시 500 err 로인해 추가
  AJS.$('#test-user-name').attr('disabled', sourceGroup === 'N' ? true : false);
  AJS.$('#btn_user_group').attr('disabled', sourceGroup === 'N' ? true : false);
};


/**
 *
 * @param deactiveEnabled
 */
var fnOnOffSetting = function (msg) {
  var btnOn = AJS.$('#btn_schedule_on');
  var btnOff = AJS.$('#btn_schedule_off');
  var panel = AJS.$('.js-flx-schedule__panel');

  // 그룹 설정이 안되어 있으면 활성화 안되도록 수정
  if (msg.sourceGroup === 'N') {
    btnOn.attr('disabled', true);
    AJS.$('.flx-desc-auto-remove').addClass('hidden');
    AJS.$('.js-flx-message-panel--auto-remove').removeClass('hidden');
    return;
  } else {
    btnOn.attr('disabled', false);
    AJS.$('.flx-desc-auto-remove').removeClass('hidden');
    AJS.$('.js-flx-message-panel--auto-remove').addClass('hidden');
  }

  if (msg.deactiveEnabled == true) {
    btnOn
        .attr('aria-pressed', true)
        .siblings()
        .attr('aria-pressed', '');

    checkAutoRemoveScheduleJob(msg);

    if (btnOn.index() === 0) {
      panel.removeClass('hidden');
    } else {
      panel.addClass('hidden');
    }
    //AJS.$('#schedule_desc').text(v_language === 'ko' ? '활성화 ' : 'enabled');
    AJS.$('#schedule_desc').text(enabledMessage);
    if (msg.notiGroup && msg.notiGroup.length !== 0)
      AJS.$('#noti-group-info')
          .removeClass('lang-no-group-applied')
          .text(msg.notiGroup);
  } else {
    btnOff
        .attr('aria-pressed', true)
        .siblings()
        .attr('aria-pressed', '');

    if (btnOff.index() === 0) {
      panel.removeClass('hidden');
    } else {
      panel.addClass('hidden');
    }

    AJS.$('.js-auto-remove-submit').addClass('hidden');
   // AJS.$('#schedule_desc').text(v_language === 'ko' ? '비활성화 ' : 'disabled');
    AJS.$('#schedule_desc').text(disabledMessage);
  }

  // if (msg.notiGroup && msg.notiGroup.length !== 0) {
  //
  //   AJS.$('#noti-group-info')
  //       .removeClass('lang-no-group-applied')
  //       .text(msg.notiGroup);
  // }
  //
  // if (msg.deactiveEnabled === true) {
  //   btnOn
  //       .attr('aria-pressed', true)
  //       .siblings()
  //       .attr('aria-pressed', '');
  //
  //   checkAutoRemoveScheduleJob(msg);
  //   AJS.$('#schedule_desc').text(v_language === 'ko' ? '활성화' : 'enabled');
  //   panel.removeClass('hidden');
  //   AJS.$('.js-is-active').addClass('hidden');
  //
  // } else {
  //   btnOff
  //       .attr('aria-pressed', true)
  //       .siblings()
  //       .attr('aria-pressed', '');
  //
  //   AJS.$('#btn_schedule_save').hide();
  //   AJS.$('#btn_cancel').hide();
  //   AJS.$('#schedule_desc').text(v_language === 'ko' ? '비활성화' : 'disabled');
  //   panel.addClass('hidden');
  //   AJS.$('.js-is-active').removeClass('hidden');
  // }

};

function checkAutoRemoveScheduleJob(msg) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/scheduler/check';
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function (result) {
      if(!result[0].autoRemoveJob.registed) {
        AJS.$("#auto-remove-no-regist-text").removeClass('hidden');
        AJS.$("#auto-remove-registed-cronjob-text").addClass('hidden');
        AJS.$("#auto-remove-registed-next-runtime-text").addClass('hidden');
      } else {
        AJS.$("#auto-remove-no-regist-text").addClass('hidden');
        //AJS.$("#auto-remove-registed-cronjob-text").removeClass('hidden');
        AJS.$("#auto-remove-registed-next-runtime-text").removeClass('hidden');
        // var crontime = result[0].autoRemoveJob.details.schedule.cronScheduleInfo.cronExpression;
        //var nextRunTime = result[0].autoRemoveJob.details.nextRunTime;
        var nextRunTime = result[0].autoRemoveJob.nextRunTime;
        if(!nextRunTime) {
          nextRunTime = result[0].autoRemoveJob.detailsNextRunTime;
        }
         AJS.$("#registed_auto_remove_job_next_runtime").text(nextRunTime);
      }
    },
    error: function() {
      var calcNextRunTime= getNextExecutionTime(msg.deactiveScheduleInterval, 
          msg.deactiveScheduleWeek, 
          msg.deactiveScheduleDay, 
          msg.deactiveScheduleHour);
      AJS.$("#registed_auto_remove_job_next_runtime").text(calcNextRunTime);
      AJS.$("#auto-remove-registed-next-runtime-text").removeClass('hidden');
    }
  });
}

function checkNotiScheduleJob(msg) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/scheduler/check';
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function (result) {
      if (!result[0].notiRegisteredJob.registed) {
        AJS.$("#noti-job-no-regist-text").removeClass('hidden');
        AJS.$("#noti-job-registed-cronjob-text").addClass('hidden');
        AJS.$("#noti-job-registed-next-runtime-text").addClass('hidden');
      } else {
        AJS.$("#noti-job-no-regist-text").addClass('hidden');
        AJS.$("#noti-job-registed-next-runtime-text").removeClass('hidden');
        //var nextRunTime = result[0].notiRegisteredJob.details.nextRunTime;
        var nextRunTime = result[0].notiRegisteredJob.nextRunTime;
        if(!nextRunTime) {
          nextRunTime = result[0].notiRegisteredJob.detailsNextRunTime;
        }
        AJS.$("#registed_noti_job_next_runtime").text(nextRunTime);
      }
    }, 
    error: function() {
      var calcNextRunTime= getNextExecutionTime(msg.scheduleInterval, 
          msg.scheduleWeek, 
          msg.scheduleDay, 
          msg.scheduleHour);
      AJS.$("#registed_noti_job_next_runtime").text(calcNextRunTime);
      AJS.$("#noti-job-registed-next-runtime-text").removeClass('hidden');
    }
  });
}

// function getCronTime(crontime) {
//   return crontime.split(" ")[2] + ( v_language === 'ko' ? "시" : " hour" );
// }

// function getCronInterval(crontime) {
//   var interval = crontime.split(" ")[3];
//   if(interval === "1/30") {
//     return v_language === 'ko' ? "월간" : "monthly";
//   } else if(interval === "1/7") {
//     return v_language === 'ko' ? "주간" : "weekly";
//   } else if(interval === "1/1") {
//     return v_language === 'ko' ? "일간" : "daily";
//   }
// }

/**알림 메뉴 확설화 조건**/
var notificationSetting = function() {
  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/notification/get/notificationSettings',
    type: 'GET',
    dataType: 'json',
    success: function(msg) {
      // 설정이 안되어 있으면 활성화 안되도록 수정
      if (!msg[0] && !msg[1]) {
        AJS.$('#input-noti').val(0);
        AJS.$('.js-flx-message-panel--notification').removeClass('hidden');
        AJS.$('#input-noti-group').attr('disabled', true);
        AJS.$('#input-noti-user').attr('disabled', true);
        AJS.$('#input-noti-other').attr('disabled', true);

        return;
      } else{
        AJS.$('.js-flx-message-panel--notification').addClass('hidden');
        AJS.$('#input-noti-group').attr('disabled', false);
        AJS.$('#input-noti-user').attr('disabled', false);
        AJS.$('#input-noti-other').attr('disabled', false);
      }
    },
    fail: function() {
      console.info('get license config fail.');
    }
  });
};

/**노티 셋업 설정**/
var getNotiSetup = function() {
  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/notification/get/notificationSettings',
    type: 'GET',
    dataType: 'json',
    success: function(msg) {
      // 설정이 안되어 있으면 활성화 안되도록 수정
      if (msg[0]=== 0 && msg[1] === 0) {
        AJS.$('#input-noti').val(0);
        AJS.$('.js-flx-message-panel--notification').removeClass('hidden');
        AJS.$('#input-noti-group').attr('disabled', true);
        AJS.$('#input-noti-user').attr('disabled', true);
        AJS.$('#input-noti-other').attr('disabled', true);

        return;
      } else{
        AJS.$('.js-flx-message-panel--notification').addClass('hidden');
        AJS.$('#input-noti-group').attr('disabled', false);
        AJS.$('#input-noti-user').attr('disabled', false);
        AJS.$('#input-noti-other').attr('disabled', false);
      }
    },
    fail: function() {
      console.info('get license config fail.');
    }
  });
};

/**경고에 대하여 OnOff 설정 저장**/
function warningOnOffSetting() {
  var btnWarningOn = AJS.$('#btn_warning_on');
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/target/group'
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function(msg) {
      // console.log("target group" + msg);
      // 그룹 설정이 안되어 있으면 활성화 안되도록 수정
      if (msg[0] === "N") {
        btnWarningOn.attr('disabled', true);
        AJS.$('.flx-desc-warning').addClass('hidden');
        AJS.$('.js-flx-message-panel--warning').removeClass('hidden');
        return;
      } else {
        btnWarningOn.attr('disabled', false);
        AJS.$('.flx-desc-warning').removeClass('hidden');
        AJS.$('.js-flx-message-panel--warning').addClass('hidden');
       // checkNotiScheduleJob(msg);
        getNotiSetupInuse();
      }
    },
    fail: function() {
      console.info('get license config fail.');
    }
  });
}


/**NotiSetup의 InUse 값에 따라 OnOff 설정하기**/
function getNotiSetupInuse(){
  var btnNotiOn = AJS.$('#btn_warning_on');
  var btnNotiOff = AJS.$('#btn_warning_off');
  var panelNoti = AJS.$('.js-flx-warning__panel');
  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/notification/get/notiSetup',
    type: 'GET',
    dataType: 'json',
    success: function(response) {
      if (response.inUse) {
        btnNotiOn
            .attr('aria-pressed', true)
            .siblings()
            .attr('aria-pressed', '');
        if (btnNotiOn.index() === 0) {
          panelNoti.removeClass('hidden');
        } else {
          panelNoti.addClass('hidden');
        }
       // AJS.$('#warning_desc').text(v_language === 'ko' ? '활성화 ' : 'enabled');
        AJS.$('#warning_desc').text(enabledMessage);
        AJS.$('.js-warning-submit').addClass('hidden');
        AJS.$('#input-noti').val(response.notiLimit);
        AJS.$('#select-warning-schedule-time').val(response.scheduleHour);
        AJS.$('#select-warning-schedule-day').val(response.scheduleInterval);

        // 스케줄 설정
        fnSetNotificationSchedule(response);
        checkNotiScheduleJob(response);

      } else {
        btnNotiOff
            .attr('aria-pressed', true)
            .siblings()
            .attr('aria-pressed', '');
        if (btnNotiOff.index() === 0) {
          panelNoti.removeClass('hidden');
        } else {
          panelNoti.addClass('hidden');
        }
        AJS.$('.js-warning-submit').addClass('hidden');
        //AJS.$('#warning_desc').text(v_language === 'ko' ? '비활성화 ' : 'disabled');
        AJS.$('#warning_desc').text(disabledMessage);
      }
    },
    fail: function() {
      console.info('get license config fail.');
    }
  });
}


/** OnOff버큰 클릭 시 NotiSetup.Inuse update**/
function saveWarningOnOff(state){

  var uasage = state ? true : false;
  var data = {
    inUse : uasage
  }
  AJS.$.ajax({
    url: CONTEXT_PATH + '/rest/custom/1.0/notification/save/notiSetup',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'PUT',
    dataType: 'json',
    data: JSON.stringify(data),
    success: function(data) {
      notificationSetting();
      warningOnOffSetting();
    },
    error: function(data) {
      console.log(data);
      warningOnOffSetting();
    }
  });

}

var validateEmail = function(pTag, email) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/notification/search/email?email=' + email;
  var tag = AJS.$('#' + pTag);
  var divTag = "<div class='group-items' id='div_User_list' onclick='setEmailNotiList(\"";

  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    timeout: 15000,
    success: function(msg) {
      tag.html('');
      if (msg[0] === 'No Matches') {

        var txt =
            divTag +
            msg[0] +
            '")\'><em>' +
            //(v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            noMatchMessage +
            '</em></div>';
        tag.append(txt);
        AJS.$('#btn_user_group').attr('disabled', true);
      } else {
        AJS.$('#btn_user_group').attr('disabled', false);
        for (arr in msg) {
          if (arr < 6) {
            var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
            tag.append(txt);
          }
        }
      } // else
    },
    error : function(request,status,error){
    },
    fail : function() {
      console.log('message','ajax call fail');
    }
  });
};


var validateNotiUser = function(pTag, userName) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/notification/UserCheck?userName=' + userName;

  var tag = AJS.$('#' + pTag);
  var divTag = "<div class='group-items' id='div_User_list' onclick='setUserNotiList(\"";
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    timeout: 15000,
    success: function(msg) {
      tag.html('');
      if (msg[0] === 'No Matches') {
        var txt =
            divTag +
            msg[0] +
            '")\'><em>' +
            // (v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            noMatchMessage +
            '</em></div>';
        tag.append(txt);
      } else {
        for (arr in msg) {
          if (arr < 6) {
            var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
            tag.append(txt);
          }
        }
      } // else
    },
    error : function(request,status,error){
    },
    fail : function() {
      console.log('message','ajax call fail');
    }
  });
};


// var validateUser = function(pTag, userName) {
//   var url = CONTEXT_PATH + '/rest/custom/1.0/notification/UserCheck?userName=' + userName;
//   var tag = AJS.$('#' + pTag);
//   var divTag = "<div class='group-items' id='div_User_list' onclick='setUserList(\"";
//
//   AJS.$.ajax({
//     url: url,
//     type: 'GET',
//     dataType: 'json',
//     timeout: 15000,
//     success: function(msg) {
//       console.log("msg",msg)
//       tag.html('');
//       if (msg[0] === 'No Matches') {
//         var txt =
//             divTag +
//             msg[0] +
//             '")\'><em>' +
//             (v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
//             '</em></div>';
//         tag.append(txt);
//         AJS.$('#btn_user_group').attr('disabled', true);
//       } else {
//         AJS.$('#btn_user_group').attr('disabled', false);
//         for (arr in msg) {
//           if (arr < 6) {
//             var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
//             tag.append(txt);
//           }
//         }
//       } // else
//     },
//     error : function(request,status,error){
//     },
//     fail : function() {
//       console.log('message','ajax call fail');
//
//     }
//   });
// };


var setUserList = function (username) {
  if (username === 'No Matches') {
    AJS.$('#test-user-name').val('');
  } else {
    AJS.$('#test-user-name').val(username);
  }
  AJS.$('#userList').html('');
};


var setUserNotiList = function(username) {
  if (username === 'No Matches') {
    AJS.$('#input-noti-user').val('');
  } else {
    AJS.$('#input-noti-user').val(username);
  }
  AJS.$('#noti-users').html('');
};

var setUserExcludeTargetList = function(username) {
  if (username === 'No Matches') {
    AJS.$('#input-exclude-table-user').val('');
  } else {
    AJS.$('#input-exclude-table-user').val(username);
  }
  AJS.$('#exclude-setting-users').html('');
};

var validateExcludeUser = function(pTag, userName) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/notification/UserCheck?userName=' + userName;

  var tag = AJS.$('#' + pTag);
  var divTag = "<div class='group-items' id='div_User_list' onclick='setUserExcludeTargetList(\"";
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    timeout: 15000,
    success: function(msg) {
      tag.html('');
      if (msg[0] === 'No Matches') {
        var txt =
            divTag +
            msg[0] +
            '")\'><em>' +
            //(v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            noMatchMessage +
            '</em></div>';
        tag.append(txt);
      } else {
        for (arr in msg) {
          if (arr < 6) {
            var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
            tag.append(txt);
          }
        }
      } // else
    },
    error : function(request,status,error){
    },
    fail : function() {
      console.log('message','ajax call fail');
    }
  });
};

var setEmailNotiList = function(username) {
  if (username === 'No Matches') {
    AJS.$('#input-noti-other').val('');
  } else {
    AJS.$('#input-noti-other').val(username);
  }
  AJS.$('#noti-other').html('');
};

function saveOnOffState(state) {
  const host = location.protocol + "//" + location.host + location.pathname;
  var configData = JSON;
  configData.userLimit = AJS.$('#input-user-count').val();
  //configData.notiLimit = AJS.$('#input-noti').val();
  configData.lastLogin = AJS.$('#input-last-login').val();
  configData.deactiveScheduleHour = AJS.$('#select-schedule-time').val();
  configData.deactiveScheduleInterval = AJS.$('#select-schedule-day').val();
  configData.isInactive = AJS.$('#checkbox-user-inactive').is(':checked');
  configData.isReactive = AJS.$('#checkbox-user-reactive').is(':checked');
  configData.isNotLogin = AJS.$('#checkbox-user-nologin').is(':checked');
  configData.deactiveEnabled = state;
  configData.countCanuseDate = config.countCanuseDate;
  configData.countCanuseGroup = config.countCanuseGroup;
  configData.countSourceDate = config.countSourceDate;
  configData.countSourceGroup = config.countSourceGroup;
  //configData.notiGroup = AJS.$('#input-noti-group').val();
  config.deactiveEnabled = state;
  configData.flexurl = host;

  var url = CONTEXT_PATH + '/rest/custom/1.0/license/control';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'PUT',
    dataType: 'json',
    data: JSON.stringify(configData),
    success: function (data) {
      getLicenseConfig();
      //AJS.flag(alertMsg.success);
    },
    error: function (data) {
      console.log(data);
    }
  });
}


var autoEditSetting = function (state) {
  //auto remove의 edit버튼 설정

  if (state) {
    AJS.$('#btn_edit').css('visibility', 'visible');
    //AJS.$('#btn_editSchedule').css('visibility', 'visible');
    AJS.$('#btn_schedule_test').css('visibility', 'hidden');
    AJS.$('#notiValidGroup_msg').addClass('hidden');
    AJS.$('.js-auto-remove-submit').addClass('hidden');
    AJS.$('#btn_schedule_save').hide();
    AJS.$('#btn_cancel').hide();
    AJS.$('#input-last-login').attr('disabled', true);
    AJS.$('#select-schedule-time').attr('disabled', true);
    AJS.$('#select-schedule-day').attr('disabled', true);
    AJS.$('#checkbox-user-inactive').attr('disabled', true);
    AJS.$('#checkbox-user-reactive').attr('disabled', true);
    AJS.$('#checkbox-user-nologin').attr('disabled', true);
    AJS.$('#select-schedule-week').attr('disabled', true);
    AJS.$('#select-schedule-date').attr('disabled', true);
  } else {
    AJS.$('#btn_edit').css('visibility', 'hidden');
    //AJS.$('#btn_editSchedule').css('visibility', 'hidden');
    AJS.$('#btn_schedule_test').css('visibility', 'visible');
    AJS.$('.js-auto-remove-submit').removeClass('hidden');
    AJS.$('#notiValidGroup_msg').removeClass('hidden');
    AJS.$('#btn_schedule_save').show();
    AJS.$('#btn_cancel').show();
    AJS.$('#input-last-login').attr('disabled', false);
    AJS.$('#select-schedule-time').attr('disabled', false);
    AJS.$('#select-schedule-day').attr('disabled', false);
    AJS.$('#checkbox-user-inactive').attr('disabled', false);
    AJS.$('#checkbox-user-reactive').attr('disabled', false);
    AJS.$('#checkbox-user-nologin').attr('disabled', false);

    if( AJS.$('#select-schedule-day').val() == 7) {
      AJS.$('#select-schedule-week').attr('disabled', false);
    } else if(AJS.$('#select-schedule-day').val() == 30) {
      AJS.$('#select-schedule-date').attr('disabled', false);
    }
  }
}


var editSetting = function(object, state, type) {
  if (state) {
    AJS.$('#btn_warning_edit').css('visibility', 'visible');
    AJS.$('.js-warning-submit').addClass('hidden');
    AJS.$('.input-noti').addClass('hidden');
    AJS.$('#btn_warning_save').hide();
    AJS.$('#btn_warning_cancel').hide();
    AJS.$('#select-warning-schedule-week').attr('disabled', true);
    AJS.$('#select-warning-schedule-date').attr('disabled', true);
  } else {
    AJS.$('#btn_warning_edit').css('visibility', 'hidden');
    AJS.$('.js-warning-submit').removeClass('hidden');
    AJS.$('.input-noti').removeClass('hidden');
    AJS.$('#btn_warning_save').show();
    AJS.$('#btn_warning_cancel').show();

    if( AJS.$('#select-warning-schedule-day').val() == 7) {
      AJS.$('#select-warning-schedule-week').attr('disabled', false);
    } else if(AJS.$('#select-warning-schedule-day').val() == 30) {
      AJS.$('#select-warning-schedule-date').attr('disabled', false);
    }

  }
  if (object == null) return;

  for (var i = 0; i < object.length; i++) {
    //if (object[i] === 'input-noti-group') editNotiGroup(object[i], state);
    document.getElementById(object[i]).disabled = state;
  }
};


/**
 * scheduleValidation
 */
var scheduleValidation = function () {
  var lastLogin = AJS.$('#input-last-login').val();
  var loginday_msg = AJS.$('#last_loginday_msg');
  var bl = true;
  var getOnlyNumber = function (val) {
    return val.trim().replace(/[^0-9]/g, '');
  };
  loginday_msg.addClass('hidden');
  if (lastLogin === '' || (lastLogin === '0' || lastLogin === 0)) {
    loginday_msg.removeClass('hidden');
    bl = false;
  }
  if (bl) {
    AJS.$('#input-last-login')
        .val(null)
        .val(getOnlyNumber(lastLogin));
  }
  return bl;
};



/**
 * warningValidation
 */
var warningValidation = function () {
  var notiUserNum = AJS.$('#input-noti').val();
  var bl = true;

  var getOnlyNumber = function (val) {
    return val.trim().replace(/[^0-9]/g, '');
  };
  AJS.$('#userCount_msg').addClass('hidden');
  if (notiUserNum === '' || (notiUserNum === '0' || notiUserNum === 0)) {
    AJS.$('#userCount_msg').removeClass('hidden');
    bl = false;
  }
  if (bl) {
    AJS.$('#input-noti')
        .val(null)
        .val(getOnlyNumber(notiUserNum));
  }
  return bl;
};


/**
 * schedule save logic
 */
var exceuteSave = function () {
  /*if (type == "auto") {
    var obj = [
      'input-last-login',
      'select-schedule-time',
      'select-schedule-day'
    ];
    saveConfig();

  } else if (type == "noti") {
    var obj = [
      'input-noti',
      'select-warning-schedule-time',
      'select-warning-schedule-day'
    ];
    saveNotiSetupEntity();
  }
  editSetting(obj, true);
*/
};

/**
 * notification save logic
 */
// var notificationSave = function () {
//   var notiGroup = AJS.$('#input-noti-group').val();
//   var url = CONTEXT_PATH + '/GroupCheck?groupName=' + notiGroup;
//   AJS.$.ajax({
//     url: url,
//     headers: {
//       Accept: 'application/json',
//       'Content-Type': 'application/json'
//     },
//     type: 'GET',
//     dataType: 'json',
//     success: function (data) {
//       if (data[0] === 'No Matches') {
//         AJS.$('#notiValidGroup_msg').removeClass('hidden');
//         AJS.$('#noti-groups').empty();
//         return;
//       } else {
//         var obj = [
//           'input-noti',
//           'input-noti-group'
//         ];
//         saveConfig();
//         editSetting(obj, true);
//         return;
//       }
//     },
//     error: function (data) {
//     }
//   });
// };


var runCountReduceCheck = function (userCount) {
 // var value = AJS.$('#reduce-value').val();
  var url =
      CONTEXT_PATH +
      '/rest/custom/1.0/license/reduce/count/check?count=' +
      parseInt(userCount, 10);

  AJS.$('#force-remove')
      .find('.flx-error')
      .addClass('hidden');

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'GET',
    success: function (data) {

      AJS.$('#reduce-run-sync-progress').css('display', 'none');

      if (data.resultMsg === 'exceed') {
        AJS.$('#setUser_exceedMsg').removeClass('hidden');
      } else {
        AJS.dialog2('#member-user-count-dialog').show();
        AJS.$('#flx-underline_UserCount').text(userCount);
      }
      // if (data.resultMsg === 'exceed') {
      //   document.getElementById('reduce-run').disabled = false;
      //   AJS.$('#setUser_exceedMsg').removeClass('hidden');
      //   AJS.$('#setUser_NumberMsg').addClass('hidden');
      //   AJS.$('#reduce-run-sync-progress').css('display', 'none');
      // } else {
      //   document.getElementById('reduce-run').disabled = false;
      //   AJS.$('#reduce-run-sync-progress').css('display', 'none');
      //   AJS.$('#setUser_exceedMsg').addClass('hidden');
      //   AJS.dialog2('#member-user-count-dialog').show();
      //   AJS.$('#flx-underline_UserCount').text(userCount);
      // }
    },
    error: function (data) {
      document.getElementById('reduce-run').disabled = false;
      AJS.$('#reduce-run-sync-progress').css('display', 'none');
    }
  });
};

var createGroupByGroupName = function (groupName) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/group';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    data: groupName, // 데이터를 JSON 형식으로 전송
    dataType: "json",
    type: 'POST',
    success: function (data) {
      AJS.$('#create-group-sync-progress').css('display', 'none');

      if(data) {
        AJS.flag(alertMsg.createGroupSuccess);
      }
      document.getElementById('btn-create-group').disabled = false;
      AJS.$('#create-group-value').val('');
    },
    error: function (data) {
      document.getElementById('btn-create-group').disabled = false;
      AJS.$('#create-group-sync-progress').css('display', 'none');
      AJS.flag(alertMsg.failedCreateGroup);
    }
  });
};


// TODO: group mapping 완료되면 intro페이지 안보이도록 설정 해야 됨
window.addEventListener('DOMContentLoaded', function () {
  var btnIntroStart = document.querySelector('.js-intro-start');

  if(btnIntroStart !== null && btnIntroStart !== undefined){
    btnIntroStart.addEventListener('click', function () {
     // onTogglePanel('.js-flx-intro', '.js-flx-panel');
     //AJS.tabs.change(AJS.$('a[href="#users"]'));
      window.location.replace(AJS.contextPath() + "/plugins/servlet/luffy/license/group");
    });
  }
});

var onTogglePanel = function (closePanel, openPanel) {
  AJS.$(closePanel).removeClass('is-hidden');
  AJS.$(openPanel).addClass('is-hidden');
};


var handleScheduleSelect = function (interval, targetId) {
  if(interval == 7) {
    AJS.$('#'+targetId+'-date-field').hide();
    AJS.$('#'+targetId+'-week-field').show();
  } else if (interval == 30) {
    AJS.$('#'+targetId+'-week-field').hide();
    AJS.$('#'+targetId+'-date-field').show();
  } else {
    AJS.$('#'+targetId+'-date-field').hide();
    AJS.$('#'+targetId+'-week-field').hide();
  }
}

var fnSetRemoveSchedule = function (msg) {
  if(msg.deactiveScheduleInterval === 7) {
    AJS.$('#select-schedule-week').val(msg.deactiveScheduleWeek);
  } else if (msg.deactiveScheduleInterval === 30) {
    AJS.$('#select-schedule-date').val(msg.deactiveScheduleDay);
  }
  handleScheduleSelect(msg.deactiveScheduleInterval, 'schedule');
}

var fnSetNotificationSchedule = function (response) {
  if(response.scheduleInterval === 7) {
    AJS.$('#select-warning-schedule-week').val(response.scheduleWeek);
  } else if (response.scheduleInterval === 30) {
    AJS.$('#select-warning-schedule-date').val(response.scheduleDay);
  }
  handleScheduleSelect(response.scheduleInterval, 'warning-schedule');
}







// 라이선스 그룹 여부에 따라 force remove 패널 활성화 설정
// param: string (라이선스 그룹 명 / N)
function setForceRemove(targetGroup) {
  var isActive = function () {
    return targetGroup === 'N';
  };

  AJS.$('#reduce-value').attr('disabled', isActive());
  AJS.$('#reduce-run').attr('disabled', isActive());

  if (isActive()) {
    AJS.$('.js-flx-message-panel--force').removeClass('hidden');
  } else {
    AJS.$('.js-flx-message-panel--force').addClass('hidden');
  }
}

function xhr(data, type, isAsync, url) {
  return AJS.$.ajax({
    url: url,
    type: type,
    dataType: 'json',
    data: data,
    timeout: 15000,
    async: isAsync || false,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    }
  });
}

// function onAutoComplete(data) {
//   var fragment = document.createDocumentFragment();
//   var isSearchUserName = data.hasOwnProperty('username');
//   var isActiveUserStateBtn = false;
//   // 사용자 이름 검색과 그룹 검색 url이 달라서 url 함수 생성
//   var getReqUrl = function () {
//     var url = CONTEXT_PATH + '/rest/custom/1.0/groups/search';
//     return isSearchUserName ? url + '/username' : url;
//   };
//
//   var result = xhr(data, 'GET', null, getReqUrl());
//
//   var makeNoMatchResult = function (result) {
//     var em = document.createElement('em');
//     var div = document.createElement('div');
//
//     em.textContent = v_language === 'ko' ? '일치하는 항목 없음' : result;
//     div.appendChild(em);
//     div.className = 'group-items';
//     div.dataset.val = 'no';
//
//     fragment.appendChild(div);
//   };
//
//   var makeMatchResult = function (result) {
//     isActiveUserStateBtn = true;
//     result.forEach(function (text, idx) {
//       var div = document.createElement('div');
//       div.textContent = text;
//       div.className = 'group-items';
//       div.dataset.val = text;
//       fragment.appendChild(div);
//     });
//   };
//
//   result.done(function (data) {
//     data[0] === 'No Matches'
//       ? makeNoMatchResult(data[0])
//       : makeMatchResult(data);
//   });
//
//   result.error(function (request, status, error) {
//     console.log('error', error);
//   });
//
//   result.fail(function () {
//     console.log('message', 'ajax call fail');
//   });
//   return {
//     els: fragment,
//     isUserName: isSearchUserName,
//     isActiveUserStateBtn: isActiveUserStateBtn
//   };
// }


function getSyncedInfo() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/synced/info';
  AJS.$.get(url, function (data) {
    console.info(data);
    AJS.$('#synced-info').html(data);
    return data.info;
  });
}

function toggleHint() {
  if (AJS.$('#hint-box').css('display') == 'none') {
    AJS.$('#hint-box').css('display', 'inline-block');
  } else {
    AJS.$('#hint-box').css('display', 'none');
  }
}


var getUserName = function(userName) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/notification/username?username=' + userName;
  var tag = AJS.$('#userList');
  var divTag = "<div class='group-items' id='div_User_list' onclick='setUserList(\"";

  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    timeout: 15000,
    success: function(msg) {
      tag.html('');
      if (msg[0] === 'No Matches') {
        var txt =
            divTag +
            msg[0] +
            '")\'><em>' +
            //(v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            noMatchMessage +
            '</em></div>';
        tag.append(txt);
        AJS.$('#btn_user_group').attr('disabled', true);
      } else {
        AJS.$('#btn_user_group').attr('disabled', false);
        for (arr in msg) {
          if (arr < 6) {
            var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
            tag.append(txt);
          }
        }
      } // else
    },
    error : function(request,status,error){
    },
    fail : function() {
      console.log('message','ajax call fail');

    }
  });
};


/**
 * scehdule setting
 */
var setSchedulerTime = function () {
  var selectMin = AJS.$('#select-schedule-min');
  var selectDay = AJS.$('#select-schedule-day');
  var optionMin, optionDay;
  var minLen = 60;
  var dayLen = 7;
  var isSelected = '';

  for (var i = 1; i <= minLen; i++) {
    if (i == 1) isSelected = 'selected';
    optionMin = '<option value= ' + i + '> ' + i + ' </option>';
    selectMin.append(optionMin);
  }

  for (var i = 1; i <= dayLen; i++) {
    if (i == 1) isSelected = 'selected';
    optionDay = '<option  value= ' + i + '> ' + i + ' </option>';
    selectDay.append(optionDay);
  }
};


var warningEditSetting = function(state) {
  if (state) {
    AJS.$('#btn_warning_edit').css('visibility', 'visible');
    AJS.$('.js-warning-submit').addClass('hidden');
    AJS.$('.input-warning-user-count').addClass('hidden');
    AJS.$('#btn_warning_save').hide();
    AJS.$('#btn_warning_cancel').hide();
    AJS.$('#input-warning-user-count').attr('disabled', true);
    AJS.$('#select-warning-schedule-time').attr('disabled', true);
    AJS.$('#select-warning-schedule-day').attr('disabled', true);
  } else {
    AJS.$('#btn_warning_edit').css('visibility', 'hidden');
    AJS.$('.js-warning-submit').removeClass('hidden');
    AJS.$('.input-warning-user-count').removeClass('hidden');
    AJS.$('#btn_warning_save').show();
    AJS.$('#btn_warning_cancel').show();
    AJS.$('#input-warning-user-count').attr('disabled', false);
    AJS.$('#select-warning-schedule-time').attr('disabled', false);
    AJS.$('#select-warning-schedule-day').attr('disabled', false);
  }
};


function validateAutoCompleteGroups(pTag, groupName) {
  var tag = AJS.$('#' + pTag);
  var url = CONTEXT_PATH + '/rest/custom/1.0/groups/search?search=' + groupName;
  url = encodeURI(url);
  var divTag = "<div class='group-items' id='div_User_list' onclick='setGroupNotiList(\"";
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    timeout: 15000,
    success: function(msg) {
      tag.html('');
      if (msg[0] === 'No Matches') {
        var txt =
            divTag +
            msg[0] +
            '")\'><em>' +
            (v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            '</em></div>';
        tag.append(txt);
      } else {
        for (arr in msg) {
          if (arr < 6) {
            var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
            tag.append(txt);
          }
        }
      } // else
    },
    error : function(request,status,error){
    },
    fail : function() {
      console.log('message','ajax call fail');
    }
  });
}


var validateAutoCompleteUser = function(pTag, userName) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/notification/search/user?userName=' + userName;
  url = encodeURI(url);
  var tag = AJS.$('#' + pTag);
  var divTag = "<div class='group-items' id='div_User_list' onclick='setUserNotiList(\"";
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    timeout: 15000,
    success: function(msg) {
      tag.html('');
      if (msg[0] === 'No Matches') {
        var txt =
            divTag +
            msg[0] +
            '")\'><em>' +
            (v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            '</em></div>';
        tag.append(txt);
      } else {
        for (arr in msg) {
          if (arr < 6) {
            var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
            tag.append(txt);
          }
        }
      } // else
    },
    error : function(request,status,error){
    },
    fail : function() {
      console.log('message','ajax call fail');
    }
  });
};
var validateAutoCompleteEmail = function(pTag, email) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/notification/email/autocomplete?email=' + email;
  url = encodeURI(url);
  var tag = AJS.$('#' + pTag);
  var divTag = "<div class='group-items' id='div_User_list' onclick='setEmailNotiList(\"";
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    timeout: 15000,
    success: function(msg) {
      tag.html('');
      if (msg[0] === 'No Matches') {
        var txt =
            divTag +
            msg[0] +
            '")\'><em>' +
            (v_language === 'ko' ? '일치하는 정보 없음' : msg[0]) +
            '</em></div>';
        tag.append(txt);
        AJS.$('#btn_user_group').attr('disabled', true);
      } else {
        AJS.$('#btn_user_group').attr('disabled', false);
        for (arr in msg) {
          if (arr < 6) {
            var txt = divTag + msg[arr] + '")\'>' + msg[arr] + '</div>';
            tag.append(txt);
          }
        }
      } // else
    },
    error : function(request,status,error){
    },
    fail : function() {
      console.log('message','ajax call fail');
    }
  });
};



// license.vm에서 구현되어 사용 안함
function setGroupNotiList(group) {
  if (group === 'No Matches') {
    AJS.$('#input-notification-group').val('');
  } else {
    AJS.$('#input-notification-group').val(group);
  }
  AJS.$('#notification-groups').html('');
}

// 라이센스 티어 조회
var getLicenseLimit = function() {
  var url = CONTEXT_PATH + '/rest/custom/1.0/auto-login/license-count';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'GET',
    success: function (data) {
      const licenseLimit = data.limit === -1 ? 'unlimited' : data.limit;
      AJS.$("#flx-license-count").text(licenseLimit);

    },
    error: function (data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}


// 자동로그인 페이지 데이터 세팅
var fnAutoLoginDataSetting = function(msg) {
  var licenseKeepingCount = msg.licenseKeepingCount;
  // if(licenseKeepingCount > 0) {
  //   AJS.$('#license_keeping_count_caution_msg').addClass('hidden');
  // } else {
  //   AJS.$('#license_keeping_count_caution_msg').removeClass('hidden');
  // }
  AJS.$('#checkbox-user-reactive').attr('checked', msg.isReactive);
  AJS.$('#input-license-keeping-count').val(licenseKeepingCount);
  AJS.$('#checkbox-user-nologin-in-license-remove').attr('checked', msg.isNotLoginInLicense);
  //var isKeepingCountDirectSet = msg.isKeepingCountDirectSet ? 'Y' : 'N';
  //AJS.$('input[name="radio-keeping-count-direct"][value="'+isKeepingCountDirectSet+'"]').prop('checked', true);

}

var fnLicenseKeepingDataSetting = function(msg) {
  var licenseKeepingCount = msg.licenseKeepingCount;
  var licenseKeepingTimeUnit = msg.licenseKeepingTimeUnit;
  var licenseKeepingInterval = msg.licenseKeepingInterval;
  
  AJS.$('#input-license-keeping-count').val(licenseKeepingCount);
  AJS.$('#checkbox-user-nologin-in-license-remove').attr('checked', msg.isNotLoginInLicense);
  if (licenseKeepingTimeUnit == 1) {
    AJS.$('#select-license-keeping-interval-minute').val(licenseKeepingInterval);
    AJS.$('#select-license-keeping-interval-hour').hide();
    AJS.$('#select-license-keeping-interval-minute').show();
    AJS.$('#select-schedule-license-keeping-time').val(licenseKeepingTimeUnit);
  } else if(licenseKeepingTimeUnit == 60 ) {
    AJS.$('#select-license-keeping-interval-hour').val(licenseKeepingInterval);
    AJS.$('#select-license-keeping-interval-minute').hide();
    AJS.$('#select-license-keeping-interval-hour').show();
    AJS.$('#select-schedule-license-keeping-time').val(licenseKeepingTimeUnit);
  } else {
    // 시간 input hidden
    AJS.$("#select-license-keeping-interval-hour").hide();
    // 단위 selected
    AJS.$("#select-schedule-license-keeping-time").val("1");
  }

}


// 자동 로그인 페이지 자동로그인 on/off 세팅
var fnAutoLoginOnOffSetting = function(msg) {
  var btnOn = AJS.$('#btn_auto_login_on');
  var btnOff = AJS.$('#btn_auto_login_off');
  var panel = AJS.$('.js-flx-auto-login__panel');

  // 그룹 설정이 안되어 있으면 활성화 안되도록 수정
  if (msg.sourceGroup === 'N') {
    btnOn.attr('disabled', true);
    AJS.$('.flx-desc-auto-remove').addClass('hidden');
    AJS.$('.js-flx-message-panel--auto-remove').removeClass('hidden');
    return;
  } else {
    btnOn.attr('disabled', false);
    AJS.$('.flx-desc-auto-remove').removeClass('hidden');
    AJS.$('.js-flx-message-panel--auto-remove').addClass('hidden');
  }

  if (msg.isAutoLogin == true) {
    btnOn
        .attr('aria-pressed', true)
        .siblings()
        .attr('aria-pressed', '');

    if (btnOn.index() === 0) {
      panel.removeClass('hidden');
    } else {
      panel.addClass('hidden');
    }

    //AJS.$('#auto_login_desc').text(v_language === 'ko' ? '활성화 ' : 'enabled');
    AJS.$('#auto_login_desc').text(enabledMessage);

  } else {
    btnOff
        .attr('aria-pressed', true)
        .siblings()
        .attr('aria-pressed', '');

    if (btnOff.index() === 0) {
      panel.removeClass('hidden');
    } else {
      panel.addClass('hidden');
    }

    //AJS.$('#auto_login_desc').text(v_language === 'ko' ? '비활성화 ' : 'disabled');
    AJS.$('#auto_login_desc').text(disabledMessage);
  }

}

// 자동로그인 페이지 라이선스 수 유지 on/off 세팅
var fnLicenseKeepingOnOffSetting = function(msg) {
  var btnOn = AJS.$('#btn_license_keeping_on');
  var btnOff = AJS.$('#btn_license_keeping_off');
  var panel = AJS.$('.js-flx-license-keeping__panel');

  // 그룹 설정이 안되어 있으면 활성화 안되도록 수정
  // if (msg.sourceGroup === 'N') {
  //   btnOn.attr('disabled', true);
  //   AJS.$('.flx-desc-auto-remove').addClass('hidden');
  //   AJS.$('.js-flx-message-panel--auto-remove').removeClass('hidden');
  //   return;
  // } else {
  //   btnOn.attr('disabled', false);
  //   AJS.$('.flx-desc-auto-remove').removeClass('hidden');
  //   AJS.$('.js-flx-message-panel--auto-remove').addClass('hidden');
  // }

  if (msg.isKeepingLicense == true) {
    btnOn
        .attr('aria-pressed', true)
        .siblings()
        .attr('aria-pressed', '');
    

    if (btnOn.index() === 0) {
      panel.removeClass('hidden');
    } else {
      panel.addClass('hidden');
    }

    //AJS.$('#license_keeping_desc').text(v_language === 'ko' ? '활성화 ' : 'enabled');
    AJS.$('#license_keeping_desc').text(enabledMessage);

  } else {
    btnOff
        .attr('aria-pressed', true)
        .siblings()
        .attr('aria-pressed', '');

    if (btnOff.index() === 0) {
      panel.removeClass('hidden');
    } else {
      panel.addClass('hidden');
    }

    //AJS.$('#license_keeping_desc').text(v_language === 'ko' ? '비활성화 ' : 'disabled');
    AJS.$('#license_keeping_desc').text(disabledMessage);
  }
}

// 자동로그인 on/off 수정
var updateAutoLoginStatus = function(state) {
  var configData = JSON;
  configData.isAutoLogin = state;

  var url = CONTEXT_PATH + '/rest/custom/1.0/auto-login';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'PUT',
    dataType: 'json',
    data: JSON.stringify(configData),
    success: function (data) {
      getLicenseConfig();
    },
    error: function (data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}

// 라이선스 수 유지 on/off 수정
var updateKeepingLicenseStatus = function(state) {
  var configData = JSON;
  configData.isKeepingLicense = state;

  var url = CONTEXT_PATH + '/rest/custom/1.0/auto-login/keeping-license';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'PUT',
    dataType: 'json',
    data: JSON.stringify(configData),
    success: function (data) {
      getLicenseConfig();
    },
    error: function (data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}

// 자동로그인 편집 화면
var autoLoginEditSetting = function(state) {
  if(state) {
    AJS.$('.js-auto-remove-submit').addClass('hidden');
    AJS.$('#checkbox-user-reactive').attr('disabled', true);
   // AJS.$('#input-license-keeping-count').attr('disabled', true);
   // AJS.$('#checkbox-user-nologin-in-license-remove').attr('disabled', true);
   // AJS.$('input[name="radio-keeping-count-direct"]').prop('disabled', true);

  } else {
    AJS.$('.js-auto-remove-submit').removeClass('hidden');
    AJS.$('#checkbox-user-reactive').attr('disabled', false);
   // AJS.$('#checkbox-user-nologin-in-license-remove').attr('disabled', false);
    //AJS.$('input[name="radio-keeping-count-direct"]').prop('disabled', false);
    //var isKeepingCountDirectSet = AJS.$('input[name="radio-keeping-count-direct"]:checked').val() === 'N';
  //  AJS.$('#input-license-keeping-count').attr('disabled', false);
  }
}

// 라이선스 수 유지 편집 화면
var keepingLicenseEditSetting = function(state) {
  if(state) {
    AJS.$('.js-auto-remove-submit').addClass('hidden');
    AJS.$('#input-license-keeping-count').attr('disabled', true);
    AJS.$('#checkbox-user-nologin-in-license-remove').attr('disabled', true);
    AJS.$('#select-schedule-license-keeping-time').attr('disabled', true);
    AJS.$('#select-license-keeping-interval-minute').attr('disabled', true);
    AJS.$('#select-license-keeping-interval-hour').attr('disabled', true);

  } else {
    AJS.$('.js-auto-remove-submit').removeClass('hidden');
    AJS.$('#checkbox-user-nologin-in-license-remove').attr('disabled', false);
    AJS.$('#input-license-keeping-count').attr('disabled', false);
    AJS.$('#select-schedule-license-keeping-time').attr('disabled', false);
    AJS.$('#select-license-keeping-interval-minute').attr('disabled', false);
    AJS.$('#select-license-keeping-interval-hour').attr('disabled', false);
  }
}


// 라이선스 수 유지 validation
var setUpdateAutoLoginConfigErrorMessage = function(message) {
  AJS.$('.license-keeping-error').addClass('hidden');
  switch (message) {
    case 'ZERO':
      AJS.$('#license-keeping-error-zero').removeClass("hidden");
      break;
    case 'EXCEED':
      AJS.$('#license-keeping-error-exceed').removeClass("hidden");
      break;
    case 'LOWER':
      AJS.$('#license-keeping-error-lower').removeClass("hidden");
      break;
    default:
      //AJS.$('#license-keeping-error-invalid').removeClass("hidden");
      break;
  }

}


// 자동로그인 설정 저장
var updateAutoLoginConfig = function() {
  var configData = JSON;
 // var isKeepingCountDirectSet = AJS.$('input[name="radio-keeping-count-direct"]:checked').val();
//  configData.isKeepingCountDirectSet = isKeepingCountDirectSet === 'Y';
  configData.isReactive = AJS.$('#checkbox-user-reactive').is(':checked');
  //configData.licenseKeepingCount = AJS.$('#input-license-keeping-count').val();
  configData.isNotLoginInLicense = AJS.$('#checkbox-user-nologin-in-license-remove').is(':checked');

  var url = CONTEXT_PATH + '/rest/custom/1.0/auto-login/config';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'PUT',
    dataType: 'json',
    data: JSON.stringify(configData),
    success: function (data) {
      if(data.resultCode === '00') {
       // AJS.$('.license-keeping-error').addClass('hidden');
        AJS.flag(alertMsg.autoLoginSettingSuccess);
        autoLoginEditSetting(true);
        getLicenseConfig();
      } else  {
       // AJS.flag(alertMsg.licenseKeepingFailInvalid);
       // setUpdateAutoLoginConfigErrorMessage(data.resultMsg);
      }
    },
    error: function (data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}


// 강제 삭제
var reduceUsers = function(value, exclude, id) {
  var url =
      CONTEXT_PATH +
      '/rest/custom/1.0/license/reduce/count/run?count=' + Number(value) + '&exclude=' + exclude + '&id=' + id;

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'DELETE',
    success: function (data) {
    },
    error: function (data) {
    }
  });

}

// 강제삭제 진입 시 작업 진행 여부 조회
var getReduceProgress = function () {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/reduce/progress';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    dataType: "json",
    type: 'GET',
    success: function (response) {
      //console.log("response", response);
      if(response) {
        if(response.jobStatus === 'PROCESSING') {
          getReduceProgressDetail(response.ID);
        } else if(response.jobStatus === 'COMPLETE') {
          AJS.$('#flx-force-remove-processing').addClass('hidden');
          AJS.$('#flx-force-remove-complete').removeClass("hidden");
          AJS.$('#flx-force-remove-complete-time').text(formatTimeStampDate(response.completedAt));
        }
      }

    },
    error: function (response) {
      console.log(response);
    }
  });
};



//const pollingInterval = 1000;
// 강제삭제 진행율 조회
var getReduceProgressDetail = function (id) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/reduce/progress/' + id;

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    dataType: "json",
    type: 'GET',
    success: function (response) {
      //console.log("getReduceProgressDetail : ", response);
      if (response.jobStatus === 'PROCESSING') {
        AJS.$('#flx-force-remove-processing').removeClass("hidden");
        AJS.$('#flx-force-remove-complete').addClass("hidden");
        AJS.$('#flx-force-remove-progress').attr("value", response.progressedPercentage);
        AJS.$('#flx-progressed-percentage').text(Math.trunc(Number(response.progressedPercentage)));
        setTimeout(function () {
          getReduceProgressDetail(id);
        }, 1000);
      } else if (response.jobStatus === 'COMPLETE') {
        //console.log("Job completed: ", response);
        AJS.$('#flx-force-remove-progress').attr("value", 100);
        AJS.$('#flx-progressed-percentage').text(100);
        AJS.flag(alertMsg.removelicencseGroup);
        getReduceProgress();
      }
    },
    error: function (response) {
      console.log(response);
    }
  });
};

var getIsReduceProgress = function () {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/reduce/progress';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    dataType: "json",
    type: 'GET',
    success: function (response) {
      //console.log("response", response);
      if (response && response.jobStatus === 'PROCESSING') {
        AJS.flag(alertMsg.processing);
      } else {
        reduceRunCallBack();
      }
    },
    error: function (response) {
      console.log(response);
    }
  });
};



var reduceRunCallBack = function() {
  AJS.$('#setUser_NumberMsg, #setUser_exceedMsg').addClass('hidden');
  var $userCountInputEl = AJS.$('#reduce-value');
  var userCount = $userCountInputEl
      .val()
      .trim();

  if (!userCount) {
    AJS
        .$('#setUser_NumberMsg')
        .removeClass('hidden');
    return;
  }

  userCount = userCount.replace(/[^0-9]/g, '');
  $userCountInputEl
      .val(null)
      .val(userCount);

  runCountReduceCheck(userCount);
}


// 라이선스 수 유지기능 저장
var updateKeepingLicenseConfig = function() {
  var lkInterval;
  var timeUnit = AJS.$('#select-schedule-license-keeping-time').val();
  if(timeUnit == 1) {
    lkInterval = AJS.$('#select-license-keeping-interval-minute').val();
  } else if (timeUnit == 60) {
    lkInterval = AJS.$('#select-license-keeping-interval-hour').val();
  }
  var configData = JSON;
  configData.licenseKeepingCount = AJS.$('#input-license-keeping-count').val();
  configData.isNotLoginInLicense = AJS.$('#checkbox-user-nologin-in-license-remove').is(':checked');
  configData.licenseKeepingTimeUnit = timeUnit;
  configData.licenseKeepingInterval = lkInterval;
  var url = CONTEXT_PATH + '/rest/custom/1.0/auto-login/keeping-license/config';

  AJS.$.ajax({
    url: url,
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json'
    },
    type: 'PUT',
    dataType: 'json',
    data: JSON.stringify(configData),
    success: function (data) {
      if(data.resultCode === '00') {
        AJS.$('.license-keeping-error').addClass('hidden');
        AJS.flag(alertMsg.autoLoginSettingSuccess);
        keepingLicenseEditSetting(true);
        getLicenseConfig();
      } else  {
        AJS.flag(alertMsg.licenseKeepingFailInvalid);
        setUpdateAutoLoginConfigErrorMessage(data.resultMsg);
      }
    },
    error: function (data) {
      AJS.flag(alertMsg.failedMandatory);
    }
  });
}


function checkLicenseKeepingScheduleJob(msg) {
  var url = CONTEXT_PATH + '/rest/custom/1.0/license/scheduler/check';
  AJS.$.ajax({
    url: url,
    type: 'GET',
    dataType: 'json',
    success: function (result) {
      //console.log("checkLicenseKeepingScheduleJob : ", result)
      if (!result[0].maintainLicenseJob.registed) {
        AJS.$("#license-keeping-no-regist-text").removeClass('hidden');
        AJS.$("#license-keeping-registed-next-runtime-text").addClass('hidden');
      } else {
        AJS.$("#license-keeping-no-regist-text").addClass('hidden');
        AJS.$("#license-keeping-registed-next-runtime-text").removeClass('hidden');
        //var nextRunTime = result[0].maintainLicenseJob.details.nextRunTime;
        var nextRunTime = result[0].maintainLicenseJob.nextRunTime;
        if(!nextRunTime) {
          nextRunTime = result[0].maintainLicenseJob.detailsNextRunTime;
        }
        AJS.$("#registed_license_keeping_job_next_runtime").text(nextRunTime);
      }
    },
    error: function() {
      var calcNextRunTime= getNextRunTimeLicenseKeeping(msg.licenseKeepingInterval, msg.licenseKeepingTimeUnit);
      AJS.$("#registed_license_keeping_job_next_runtime").text(calcNextRunTime);
      AJS.$("#license-keeping-registed-next-runtime-text").removeClass('hidden');
    }
  });
}
