(function(g) {
  var config = {
    tabEl: null,
    btnEl: null,
    panelEl: null,
    storageKey: 'flex.close.message'
  };

  // @argument: bool
  var displayPanel = function (isClosed) {
    isClosed ? config.panelEl.classList.add('hide') : config.panelEl.classList.remove('hide');
  };

  var onClickHidePanel = function () {    
    config.btnEl.addEventListener('click', function () { 
      displayPanel(true);
    });
  };

  var resetPanel = function () { 
    config.tabEl.addEventListener('click', function (e) { 
      var currentEl = e.target;

      if (currentEl.nodeName.toLowerCase() !== 'a') return;
      
      currentEl.id !== 'aui-uid-0' && displayPanel(false);
    });
  };

  var init = function () { 
    config.tabEl = document.querySelector('.js-tabs-menu');
    config.btnEl = document.querySelector('.js-btn-flx-message-panel');
    config.panelEl = document.querySelector('.js-flx-message-panel');
    
    onClickHidePanel();
    resetPanel();
  };

  g.showHideWarningPanel = init;
}(window));