/**
 * dashboard.js
 * 최초생성일: 2020. 05. 07
 *  설명:
 *  관리자 설정 메뉴를 묶어서 dashboard 형태로 보여 준다.
 */
  var configDashboard;
  var licensedUsedMessage = AJS.I18n.getText("-dashboard.license-usage.chart.item.used").toString();
  var licensedRemainedMessage = AJS.I18n.getText("-dashboard.license-usage.chart.item.remain").toString();
  var licensedUsersMessage = AJS.I18n.getText("-dashboard.registered-users.chart.item.licensed").toString();
  var unlicensedUsersMessage = AJS.I18n.getText("-dashboard.registered-users.chart.item.unlicensed").toString();
  var removeWarningMultiOneMessgae = AJS.I18n.getText("-dashboard.remove-warning.notification.list.item.multi-1").toString();
  var removeWarningMultiTwoMessgae = AJS.I18n.getText("-dashboard.remove-warning.notification.list.item.multi-2").toString();
  var unlimitedMessage = AJS.I18n.getText("-common.text.unlimited").toString();
  var intervalDailyMessage = AJS.I18n.getText("-common.text.interval.daily").toString();
  var intervalWeeklyMessage = AJS.I18n.getText("-common.text.interval.weekly").toString();
  var intervalMonthlyMessage = AJS.I18n.getText("-common.text.interval.monthly").toString();

  var getDashBoardInfo = function () {
    var data;
    configDashboard = null;

    openSpinner();

    /** 대시보드 정보 가져오기 */
   // FlexibleApi.call(restApi.getDashBoard(),'GET',data,resultDashBoard);
    FlexibleApi.call(restApi.getScheduleSettingsInfo(),'GET', data, viewAutoRemoveDashboard);
    FlexibleApi.call(restApi.getLicenseLimitInfo(),'GET', data, licenseLimit);
    FlexibleApi.call(restApi.getRegisteredUsersInfo(),'GET', data, registeredUsers);
    FlexibleApi.call(restApi.getGroupMappingInfo(),'GET', data, viewGroupMapping);
    activateInfoBtn();
  }

  // var resultDashBoard = function (data) {
  //   console.log('resultDashBoard',data);
  //   var resultData = data.resultData;
  //
  //   if(data.resultCode === 200){
  //     configDashboard = resultData;
  //
  //     try{
  //       resultIntropage(resultData);
  //       /** 대시보드 설정 메시지  */
  //       ctrlWarningMsg(resultData);
  //
  //       try{
  //         /** 라이선스 차트 */
  //         licenseLimit(resultData);
  //       }catch(e){
  //         console.log(e);
  //       }
  //
  //
  //       /** 유저 정보 차트 */
  //       registeredUsers(resultData);
  //
  //       /** 그룹 매핑 정보 */
  //       viewGroupMapping(resultData);
  //
  //       /** 삭제 라이선스 정보 */
  //       viewRemoveLicensedGroup(resultData);
  //
  //       /** 이메일 노티 관련 정보 */
  //       viewEmailnoti(resultData);
  //
  //       /** 스케쥴 관련 정보  */
  //       viewScheduleInfo(resultData);
  //     }catch (e) {
  //       console.log(e);
  //       setTimeout(function() {
  //         closeSpinner();
  //       }, 1000);
  //     }
  //
  //   }
  //   activateInfoBtn();
  //
  //   setTimeout(function() {
  //     closeSpinner();
  //   }, 1000);
  //
  // }

var viewAutoRemoveDashboard = function (data) {

  var resultData = data.resultData;

  configDashboard = resultData;

  /** 스케쥴 관련 정보  */
  viewScheduleInfo(resultData);

  /** 대시보드 설정 메시지  */
  ctrlWarningMsg(resultData);

  /** 삭제 라이선스 정보 */
  viewRemoveLicensedGroup(resultData);

  /** 이메일 노티 관련 정보 */
  viewEmailnoti(resultData);

  AJS.$('.flx-spinner-d').removeClass('is-active');
}

  /**
   * 소개 페이지 조회 후 다른쪽 이벤트를 같이 사용하고 있어 인트로 페이지로 넘어간다. 최초 한번만 실행되게 ...
   */
  var setIntroPage = function () {
    var data;
    FlexibleApi.call(restApi.getGroupMappingInfo(),'GET',data,resultIntropage);
  }
  var resultIntropage = function (data) {
    var resultData = data.resultData;
    if(resultData.boardEntity.sourceGroup ==='N') {
      onTogglePanel('.js-flx-intro', '.js-flx-panel');
    }
  }

var viewEmailnoti = function (resultData) {
  AJS.$('#board_emailUsers').text(Format.number(resultData.emailNotiLimit));
  var splitGroup, splitUser, splitExternal;

  if (resultData.notiGroupInfo !== '') {
    splitGroup = resultData.notiGroupInfo.split('_');
    if (splitGroup[1] === '0') {
      AJS.$('#board_notifiGroup').text(splitGroup[0]);
    } else {
      AJS.$('#board_notifiGroup').text(splitGroup[0] + ' ' + removeWarningMultiOneMessgae + ' ' + splitGroup[1] + ' ' + removeWarningMultiTwoMessgae);
    }
  } else {
   // AJS.$('#board_notifiGroup').text(v_language == 'ko' ? '적용된 그룹 없음' : 'No group applied');
  }

  if (resultData.notiUserInfo !== '') {
    splitUser = resultData.notiUserInfo.split('_');
    if (splitUser[1] === '0') {
      AJS.$('#board_notifiUser').text(splitUser[0]);
    } else {
      AJS.$('#board_notifiUser').text(splitUser[0] + ' ' + removeWarningMultiOneMessgae + ' ' + splitUser[1] + ' ' + removeWarningMultiTwoMessgae);
    }
  } else {
   // AJS.$('#board_notifiUser').text(v_language == 'ko' ? '적용된 사용자 없음' : 'No user applied');
  }

  if (resultData.notiOtherEmailInfo !== '') {
    splitExternal = resultData.notiOtherEmailInfo.split('_');
    if (splitExternal[1] === '0') {
      AJS.$('#board_notifiOther').text(splitExternal[0]);
    } else {
      AJS.$('#board_notifiOther').text(splitExternal[0] + ' ' + removeWarningMultiOneMessgae + ' ' + splitExternal[1] + ' ' + removeWarningMultiTwoMessgae);
    }
  } else {
   // AJS.$('#board_notifiOther').text(v_language == 'ko' ? '적용된 기타 이메일 없음' : 'No external email applied');
  }
}

var viewScheduleInfo = function (resultData) {
  var startTime = resultData.boardEntity.deactiveScheduleHour;
  var interval = resultData.boardEntity.deactiveScheduleInterval;
  AJS.$('#board_scheduleTime').text(getTimeMapping(startTime));
  AJS.$('#board_scheduleInterval').text(getIntervalMapping(interval));
 // var el = document.getElementById( 'board_scheduleInterval');
 // el.setAttribute('data-term',inteval);

  var notificationStartTime = resultData.emailScheduleHour;
  var notificationInterval = resultData.emailScheduleInterval;
  AJS.$('#board_warningTime').text(getTimeMapping(notificationStartTime));
  AJS.$('#board_warningInterval').text(getIntervalMapping(notificationInterval));
 // var el = document.getElementById( 'board_warningInterval');
 // el.setAttribute('data-term',notificationInteval);

}

var viewRemoveLicensedGroup = function (resultData) {
  var Entity  = resultData.boardEntity;
  var removeCount = resultData.removeUsersCount;
  var canuseCount = resultData.licenseGroup.count;
  var deactiveEnabled = resultData.boardEntity.deactiveEnabled;
  var removeUsres = Number(parseInt(canuseCount) - parseInt(removeCount));
  var emailDeactiveEnabled = resultData.emailInuse;

  AJS.$('#lastLogin_day').text(resultData.boardEntity.lastLogin);

  if(Entity.lastLogin !=='N') {
    AJS.$('#remove_Users').text(toNumber(removeCount));
    AJS.$('#remove_TotalCount').text(Math.sign(removeUsres) === -1 ? 0 : toNumber(removeUsres));
  }
  if(deactiveEnabled || emailDeactiveEnabled)
    AJS.$('.flx-dash-auto-remove').removeClass('is-disabled');
  else
    AJS.$('.flx-dash-auto-remove').addClass('is-disabled');


  if(resultData.boardEntity.lastLogin === 0)
    AJS.$('#p_removeInfo').css('display','none');
  else
    AJS.$('#p_removeInfo').css('display','block');
}

  var viewGroupMapping = function (data) {
    var resultData = data.resultData;
    var Entity  = resultData.boardEntity;
    if(Entity.sourceGroup !=='N'){

      AJS.$.each(Entity,function (i,v) {
        AJS.$('#'+ i).text(v);
      });

      dashboard_groupCss('none','none');

      AJS.$('.js-dash-time').text(resultData.userGroup.day + " (KST)");

    }else{
      dashboard_groupCss('block','block');

     resultIntropage(resultData);
      /** 대시보드 설정 메시지  */
      ctrlWarningMsg(resultData);
    }

    var userGroups = resultData.userGroup;
    var userGroupSize = 0;
    var userGroupName = '';

    for (var i = 0; i < userGroups.length; i++) {
      userGroupSize = userGroupSize + parseInt(userGroups[i].size);

      if (i === 0) {
        userGroupName = userGroups[0].group;
      } else {
        userGroupName = userGroupName + ', ' + userGroups[i].group;
      }

    }

    AJS.$('#sourceGroup').text(resultData.userGroupsNames);
    AJS.$('#board_UserGroupCount').text(resultData.userGroupsCount);
    AJS.$('#board_LicensedGroupCount').text(resultData.licenseGroup.count);
    AJS.$('.flx-spinner-c').removeClass('is-active');
  }

var ctrlWarningMsg = function (resultData) {
  var entity = resultData.boardEntity;
  var notiLimit = resultData.emailNotiLimit;

  if(entity.sourceGroup === 'N' || entity.lastLogin === 0 || notiLimit === 0) {
    AJS.$('#summary').addClass('not-has-entity');
  }
  else {
    AJS.$('#summary').removeClass('not-has-entity');
  }
}

var handleCssMessage = function(el, data) {
  var style = document.createElement('style');
  style.innerHTML = el + '{ content: attr('+data+'); }';
  document.head.appendChild(style);
}

var licenseLimit = function (data) {

  handleCssMessage('.flx-chart .chart-wrap--license::before', 'data-max');
  handleCssMessage('.flx-chart .chart-wrap--license::after', 'data-licenses');

  var resultData = data.resultData;
  var totalLicense;
  var usedCount = resultData.countLicense;
  var remainCount;
  var usedPercent;
  var remainPercent;

  if(resultData.maximumNumberOfUsers === -1) {
    //totalLicense = v_language && (v_language === 'ko') ? '무제한' : 'Unlimited';
    //remainCount = v_language && (v_language === 'ko') ? '무제한' : 'Unlimited';
    totalLicense = unlimitedMessage;
    remainCount = unlimitedMessage;
    usedPercent = 0;
    remainPercent = 100;
    AJS.$('.chart-wrap--license').addClass('is-unlimited');
  } else {
    totalLicense = resultData.maximumNumberOfUsers;
    remainCount = Number(totalLicense) - Number(usedCount);
    usedPercent = Number((usedCount / totalLicense * 100).toFixed(1));
    remainPercent = Number((remainCount / totalLicense * 100).toFixed(1));
    if(remainPercent < 0) remainPercent = 0;
    AJS.$('.chart-wrap--license').removeClass('is-unlimited');
  }

  AJS.$('#licenseTotalUsers').text(totalLicense);
  AJS.$('#licensedUsed').text(usedCount);
  AJS.$('#licensedRemained').text(remainCount);

  var id = '#license-chart';
  var total = totalLicense;
  var userLabels, datas, colors = {};

  // if (parent.v_language === 'ko') {
  //   userLabels = ['사용 라이선스', '남은 라이선스'];
  // } else {
  //   userLabels = ['Licensed Used', 'Licensed Remained'];
  // }

  userLabels = [licensedUsedMessage, licensedRemainedMessage];

  datas = [[userLabels[0], usedPercent], [userLabels[1], remainPercent]];
  colors[userLabels[0]] = '#000965';
  colors[userLabels[1]] = '#bbcdef';

  createChart(id,datas,total,colors);
  AJS.$('.chart-wrap--license').removeClass('is-invisible');
  AJS.$('.flx-spinner-a').removeClass('is-active');
  var convertColorLabel = userLabels[0].replace(/ /g, "-");
  AJS.$('.bb-chart-arc.bb-target-'+convertColorLabel+' text').css('fill', '#fff');
}

var registeredUsers = function (data) {

  handleCssMessage('.flx-chart .chart-wrap--register::before', 'data-total');
  handleCssMessage('.flx-chart .chart-wrap--register::after', 'data-user');

  var resultData = data.resultData;
  var rgUsers = resultData.countRegisterUsers;
  var lsUsed = resultData.countLicense;
  var unLsUsers = Number(rgUsers) - Number(lsUsed);
  var isUsedPercent = unLsUsers === 0 ? 100 : Number((lsUsed / rgUsers * 100).toFixed(1)) ;
  var unLsUsersPercent = Number(100 - isUsedPercent).toFixed(1);

  AJS.$('#registeredUsers').text(rgUsers);
  AJS.$('#licensedUsers').text(lsUsed);
  AJS.$('#unlicensedUsers').text(unLsUsers);

  var id = '#registered-chart';
  var userLabels, datas, colors = {};

  // if (parent.v_language === 'ko') {
  //   userLabels = ['라이선스 사용자', '라이선스 미사용자'];
  // } else {
  //   userLabels = ['Licensed Users', 'Unlicensed Users'];
  // }
  userLabels = [licensedUsersMessage, unlicensedUsersMessage];

  datas = [[userLabels[0], isUsedPercent], [userLabels[1], unLsUsersPercent]];
  colors[userLabels[0]] = '#000965';
  colors[userLabels[1]] = '#bbcdef';

  createChart(id,datas,rgUsers,colors);
  AJS.$('.chart-wrap--register').removeClass('is-invisible');
  AJS.$('.flx-spinner-b').removeClass('is-active');
  var convertColorLabel = userLabels[0].replace(/ /g, "-");
  AJS.$('.bb-chart-arc.bb-target-'+convertColorLabel+' text').css('fill', '#fff');
}

var createChart = function (id,datas,total,colors) {
  chart(id, datas, total).data.colors(colors);
}

var chart = function(dom, datas, centerTxt) {
  return bb.generate({
    bindto: dom,
    data: {
      type: 'donut',
      columns: datas,
      // onover: function(d, element) {
      //   console.log('d',d);
      //   console.log('element',element);
      //
      //    var data =  {id: d.id, value: d.value, ratio: 11, index: d.index, name: d.name};
      //   console.log('data',data);
      //    return data;
      // }
    },
    tooltip: {
      format: {
        name: function(name, ratio, id, index) { return name; },
        // value: function(value, ratio, id, index) { return Math.floor((ratio * 100).toFixed(2)) + '%'; }
        value: function(value, ratio, id, index) { return value + '%'; }
      },
    },
    donut: {
      title: centerTxt.toString(),
      label: {
        ratio: 1,
        format: function(value, ratio, id) {
          return value + '%';
        }
      }
    },
    legend: {
      show: false
    },
    size: {
      width: 200,
      height: 200
    }
  });
};


var activateInfoBtn = function() {
  var btnInfos = Array.from(document.querySelectorAll('.js-flx-info-btn'));
  var infoEls = Array.from(document.querySelectorAll('.flx-info-call-out'));

  var resetInfoElStyle = function() {
    infoEls.forEach(function(el, idx) {
      el.classList.remove('is-active');
    });
  };

  btnInfos.forEach(function(el, idx) {
    el.addEventListener('mouseenter', function(e) {
      infoEls[idx].classList.add('is-active');
    });

    el.addEventListener('mouseleave', resetInfoElStyle);
  });

};


  var fnCheckStart = function () {
    var entity = configDashboard.boardEntity;
    var notiLimit = configDashboard.emailNotiLimit;

    const host = location.protocol + "//" + location.host;

    const standDevide = '/servlet';
    const ctx = location
        .pathname
        .split(standDevide)[0];

    if(entity.sourceGroup === 'N'){
      var href = host + ctx + standDevide + '/luffy/license/group';
      location.href = href;
      return;
    }
    if(entity.lastLogin === 0){
      var href = host + ctx + standDevide + '/luffy/license/remove';
      location.href = href;
      return;
    }
    if(notiLimit === 0){
      var href = host + ctx + standDevide + '/luffy/license/notification';
      location.href = href;
      return;
    }

    // var entity = configDashboard.boardEntity;
    // if(entity.sourceGroup === 'N'){
    //   AJS.tabs.change(AJS.$('a[href="#users"]'));
    //   return;
    // }
    // if(entity.notiLimit === 0 || (entity.notiGroup === null || entity.notiGroup === '')){
    //   AJS.tabs.change(AJS.$('a[href="#schedule"]'));
    //   return;
    // }

  }

  var closeSpinner = function () {
   // AJS.$('.flx-spinner').removeClass('is-active');
  }

  var openSpinner = function () {
   // AJS.$('.flx-spinner').addClass('is-active');
    AJS.$('.flx-spinner-a').addClass('is-active');
    AJS.$('.flx-spinner-b').addClass('is-active');
    AJS.$('.flx-spinner-c').addClass('is-active');
    AJS.$('.flx-spinner-d').addClass('is-active');
  }

  var getTimeMapping = function (time) {
    var setTime;
    if(time.toString().length === 1)
      setTime = '0'+ time;
    else
      setTime = time;

    if(time === 0)
      setTime ='24';

    return setTime + ':00';
  }


var dashboard_groupCss = function (c3,c4) {
  // AJS.$('#display_Group').css('display', c1);
  // AJS.$('#display_Licensed').css('display', c2);
  AJS.$('#display_userGroup').css('display', c3);
  AJS.$('#display_LicensedGroup').css('display', c4);
}

  var getIntervalMapping = function (day) {
    var setInterval;
    if(day === 1)
       setInterval = intervalDailyMessage;
    if(day === 7)
       setInterval = intervalWeeklyMessage;
    if(day === 30)
       setInterval = intervalMonthlyMessage;

    return setInterval;
  }


  // window.addEventListener('load', function() {
  //   // getDashBoardInfo();
  //   // resultDashBoard();
  //
  //   var colors = {
  //     data1: '#79F2C0',
  //     data2: '#DFE1E6'
  //   };
  //
  //   chart('#license-chart', [["data1", 30],["data2", 120]], 25).data.colors(colors);
  //   chart('#registered-chart', [["data1", 30],["data2", 120]], 120).data.colors(colors);
  //
  //   activateInfoBtn();
  // });

