/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.utils;

import com.atlassian.sal.api.message.I18nResolver;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailTemplate {
    private static final Logger log = LoggerFactory.getLogger(MailTemplate.class);

    @Inject
    public MailTemplate() {
    }

    public static String getSubjectByOverUsers(I18nResolver i18n, Locale locale) {
        String html_ko = "[Confluence] \uc0ac\uc6a9\uc790 \uc218 \uacbd\uace0 \uc54c\ub9bc";
        String html_en = "[Confluence] User Count Alert Notification";
        return "[Confluence] " + i18n.getText(locale, "-mail.subject.over-user");
    }

    public static String getSubjectByRemoveUsers(I18nResolver i18n, Locale locale) {
        String html_ko = "[Confluence] \uc0ac\uc6a9\uc790 \ub77c\uc774\uc120\uc2a4 \uc81c\uac70 \uc54c\ub9bc";
        String html_en = "[Confluence] User License Remove Notification";
        return "[Confluence] " + i18n.getText(locale, "-mail.subject.remove-user");
    }

    public static String getBodyByOverUsers(I18nResolver i18n, Locale locale, String baseurl, int licenseGroupCnt) {
        String html_en = "<table cellpadding=\"0\" cellspacing=\"0\"style=\"border: 0; width: 100%;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Noto Sans,Ubuntu,Droid Sans,Helvetica Neue,sans-serif;color:#172b4d;font-size:14px;line-height:22px;\">\n        <tbody>\n          <tr>\n            <td>\n              <div style=\"width: 580px; margin: 0 auto;\">\n                <h1 style=\"font-size:24px;font-style:inherit;font-weight:500;letter-spacing:-0.01em;line-height:28px;margin:auto;margin-top:28px;text-align:left; padding: 40px 0; border-bottom: 1px solid #ccc;\">\n                  <img src=\"https://flexjira.osci.kr/images/pluginLogo.png\" style=\"width: 30px;vertical-align: top;margin-right: 10px;\" alt=\"\">Flexible User License</h1>\n                <div style=\"margin-top: 60px;\"><p style=\"padding-left: 30px;\">" + i18n.getText(locale, "-mail.over-user.licensed-group-alert-count") + ": <strong style=\"color:#0052cc;\">" + licenseGroupCnt + "</strong></p></div>\n                <div><p style=\"padding-left: 30px;\">" + i18n.getText(locale, "-mail.over-user.description.warning-1") + " <em style=\"font-weight: bold; font-style: normal;color:#0052cc;\">" + i18n.getText(locale, "-mail.over-user.description.warning-2") + "</em></p></div>\n              </div>\n            </td>\n          </tr>\n          <tr>\n            <td align=\"center\" style=\"padding-bottom:20px;padding-top:40px\">\n              <div style=\"width: 580px; margin: 40px auto 0;\">\n                <a style=\"box-sizing:border-box;border-radius:3px;border-width:0;display:inline-flex;font-style:normal;font-size:inherit;margin:0;outline:none;padding:8px 16px;text-align:center;vertical-align:middle;white-space:nowrap;background:#0052cc;color:#fff;text-decoration:none\"\n                  href=\"" + baseurl + "\" target=\"_blank\">" + i18n.getText(locale, "-mail.common.button") + "</a>\n              </div>\n            </td>\n          </tr>\n          <tr><td style=\"font-family:'Helvetica neue',Helvetica,Arial,Verdana,sans-serif;font-size:13px;line-height:19px;color:#707070;\">\n              <div style=\"width: 580px; margin: 60px auto 0; border-top: 1px solid #ccc; padding-top: 20px; text-align: center;\">\n                <p>" + i18n.getText(locale, "-mail.common.footer") + "</p>\n                <p>" + i18n.getText(locale, "-mail.common.copylight") + "</p>\n              </div></td>\n          </tr></tbody></table>";
        return html_en;
    }

    public static String getBodyByRemoveUsers(I18nResolver i18n, Locale locale, String baseurl, String canUseGroup, int lastLogin, int removeUserCount, int userCount) {
        String html_en = "<table cellpadding=\"0\" cellspacing=\"0\"style=\"border: 0; width: 100%;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Noto Sans,Ubuntu,Droid Sans,Helvetica Neue,sans-serif;color:#172b4d;font-size:14px;line-height:22px;\">\n        <tbody>\n          <tr>\n            <td>\n              <div style=\"width: 580px; margin: 0 auto;\">\n                <h1 style=\"font-size:24px;font-style:inherit;font-weight:500;letter-spacing:-0.01em;line-height:28px;margin:auto;margin-top:28px;text-align:left; padding: 40px 0; border-bottom: 1px solid #ccc;\">\n                  <img src=\"https://flexjira.osci.kr/images/pluginLogo.png\" style=\"width: 30px;vertical-align: top;margin-right: 10px;\" alt=\"\">Flexible User License</h1>\n               <div style=\"margin-top: 60px;\"><p style=\"padding-left: 30px;\">" + i18n.getText(locale, "-mail.remove-user.date") + ": <strong style=\"color:#0052cc;\">" + new Date(System.currentTimeMillis()).toString() + "</strong></p>\n               <p style=\"margin-top: 60px;\"><p style=\"padding-left: 30px;\">" + i18n.getText(locale, "-mail.remove-user.license-group-name") + ": <strong style=\"color:#0052cc;\">" + canUseGroup + "</strong></p>\n               <p style=\"margin-top: 60px;\"><p style=\"padding-left: 30px;\">" + i18n.getText(locale, "-mail.remove-user.last-login-day-set") + ": <strong style=\"color:#0052cc;\">" + lastLogin + "</strong></p>\n               <p style=\"margin-top: 60px;\"><p style=\"padding-left: 30px;\">" + i18n.getText(locale, "-mail.remove-user.removed-users-count") + ": <strong style=\"color:#0052cc;\">" + removeUserCount + "</strong></p>\n               <p style=\"margin-top: 60px;\"><p style=\"padding-left: 30px;\">" + i18n.getText(locale, "-mail.remove-user.current-users-count") + ": <strong style=\"color:#0052cc;\">" + userCount + "</strong></p></div>\n               <div><p style=\"padding-left: 30px;\"><em style=\"font-weight: bold; font-style: normal;color:#0052cc;\">" + i18n.getText(locale, "-mail.remove-user.description.remove-1") + " " + removeUserCount + " " + i18n.getText(locale, "-mail.remove-user.description.remove-2") + "</em></p></div>\n              </div>\n            </td>\n          </tr>\n          <tr>\n            <td align=\"center\" style=\"padding-bottom:20px;padding-top:40px\">\n              <div style=\"width: 580px; margin: 40px auto 0;\">\n                <a style=\"box-sizing:border-box;border-radius:3px;border-width:0;display:inline-flex;font-style:normal;font-size:inherit;margin:0;outline:none;padding:8px 16px;text-align:center;vertical-align:middle;white-space:nowrap;background:#0052cc;color:#fff;text-decoration:none\"\n                  href=\"" + baseurl + "\" target=\"_blank\">" + i18n.getText(locale, "-mail.common.button") + "</a>\n              </div>\n            </td>\n          </tr>\n          <tr><td style=\"font-family:'Helvetica neue',Helvetica,Arial,Verdana,sans-serif;font-size:13px;line-height:19px;color:#707070;\">\n              <div style=\"width: 580px; margin: 60px auto 0; border-top: 1px solid #ccc; padding-top: 20px; text-align: center;\">\n                <p>" + i18n.getText(locale, "-mail.common.footer") + "</p>\n                <p>" + i18n.getText(locale, "-mail.common.copylight") + "</p>\n              </div></td>\n          </tr></tbody></table>";
        return html_en;
    }
}

