/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);

    public static String getHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException e) {
            log.error("getHostName : ", (Throwable)e);
            return "Unknown Host";
        }
    }

    public static List<String> getServerIpAddress() {
        ArrayList<String> ipAddressList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress ia = inetAddresses.nextElement();
                    if (ia.isLoopbackAddress() || !ia.isSiteLocalAddress()) continue;
                    ipAddressList.add(ia.getHostAddress());
                    log.warn("getServerIpAddress() ip : {} ", (Object)ia.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            log.error("getServerIpAddress : ", (Throwable)e);
        }
        return ipAddressList;
    }
}

