/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.servlets;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class NotiServlet
extends HttpServlet {
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final WebSudoManager webSudo;
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final PermissionManager permissionManager;

    @Inject
    public NotiServlet(TemplateRenderer renderer, WebSudoManager webSudo, PluginLicenseManager licenseManager, PermissionManager permissionManager) {
        this.renderer = renderer;
        this.webSudo = webSudo;
        this.licenseManager = licenseManager;
        this.permissionManager = permissionManager;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html;charset=utf-8");
        String errorMessage = null;
        PrintWriter w = resp.getWriter();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        boolean isAdmin = this.isAdmin((User)currentUser);
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                switch ((LicenseError)license.getError().get()) {
                    case EXPIRED: {
                        errorMessage = "license has expired.";
                        break;
                    }
                    case TYPE_MISMATCH: {
                        errorMessage = "License type mismatch.";
                        break;
                    }
                    case USER_MISMATCH: {
                        errorMessage = "License user mismatch.";
                        break;
                    }
                    case VERSION_MISMATCH: {
                        errorMessage = "License version mismatch.";
                        break;
                    }
                    case EDITION_MISMATCH: {
                        errorMessage = "License edition mismatch.";
                        break;
                    }
                    case ROLE_EXCEEDED: {
                        errorMessage = "License role exceeded.";
                        break;
                    }
                    case ROLE_UNDEFINED: {
                        errorMessage = "License role undefined.";
                        break;
                    }
                }
            } else if (!isAdmin) {
                errorMessage = "Only administrators can access this page.";
            } else {
                try {
                    this.webSudo.willExecuteWebSudoRequest(req);
                    this.renderer.render("ui/page/notification.vm", (Writer)resp.getWriter());
                    return;
                }
                catch (WebSudoSessionException wes) {
                    this.webSudo.enforceWebSudoProtection(req, resp);
                }
            }
        } else {
            errorMessage = "Flexible User License is  Unlicensed.";
        }
        if (errorMessage != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("errorMessage", errorMessage);
                this.webSudo.willExecuteWebSudoRequest(req);
                this.renderer.render("ui/license-message.vm", map, (Writer)resp.getWriter());
                return;
            }
            catch (WebSudoSessionException wes) {
                this.webSudo.enforceWebSudoProtection(req, resp);
            }
        }
    }

    public boolean isAdmin(User user) {
        if (user == null) {
            return false;
        }
        return this.permissionManager.isConfluenceAdministrator(user);
    }
}

