/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.luffy.servlets;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.templaterenderer.annotations.HtmlSafe;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class LicenseServlet
extends HttpServlet {
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final WebSudoManager webSudo;
    @ComponentImport
    private final PluginLicenseManager licenseManager;

    @Inject
    public LicenseServlet(TemplateRenderer renderer, WebSudoManager webSudo, PluginLicenseManager licenseManager) {
        this.renderer = renderer;
        this.webSudo = webSudo;
        this.licenseManager = licenseManager;
    }

    @HtmlSafe
    @com.atlassian.velocity.htmlsafe.HtmlSafe
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String errorMessage = null;
        PrintWriter w = resp.getWriter();
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                switch ((LicenseError)license.getError().get()) {
                    case EXPIRED: {
                        errorMessage = "license has expired.";
                        break;
                    }
                    case TYPE_MISMATCH: {
                        errorMessage = "License type mismatch.";
                        break;
                    }
                    case USER_MISMATCH: {
                        errorMessage = "License user mismatch.";
                        break;
                    }
                    case VERSION_MISMATCH: {
                        errorMessage = "License version mismatch.";
                        break;
                    }
                    case EDITION_MISMATCH: {
                        errorMessage = "License edition mismatch.";
                        break;
                    }
                    case ROLE_EXCEEDED: {
                        errorMessage = "License role exceeded.";
                        break;
                    }
                    case ROLE_UNDEFINED: {
                        errorMessage = "License role undefined.";
                        break;
                    }
                }
            } else {
                try {
                    this.webSudo.willExecuteWebSudoRequest(req);
                    this.renderer.render("ui/license.vm", (Writer)resp.getWriter());
                    return;
                }
                catch (WebSudoSessionException wes) {
                    this.webSudo.enforceWebSudoProtection(req, resp);
                }
            }
        } else {
            errorMessage = "Flexible User License is  Unlicensed.";
        }
        if (errorMessage != null) {
            Object writer = null;
            Map map = MacroUtils.defaultVelocityContext();
            map.put("errorMessage", errorMessage);
            this.webSudo.willExecuteWebSudoRequest(req);
            this.renderer.render("ui/license-message.vm", map, (Writer)resp.getWriter());
            return;
        }
    }
}

